/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.util.Arrays;
import org.apache.flink.runtime.deployment.ResultPartitionDeploymentDescriptor;
import org.apache.flink.runtime.io.disk.FileChannelManager;
import org.apache.flink.runtime.io.disk.FileChannelManagerImpl;
import org.apache.flink.runtime.io.network.buffer.BufferPoolFactory;
import org.apache.flink.runtime.io.network.buffer.NetworkBufferPool;
import org.apache.flink.runtime.io.network.partition.BoundedBlockingSubpartition;
import org.apache.flink.runtime.io.network.partition.BoundedBlockingSubpartitionType;
import org.apache.flink.runtime.io.network.partition.PipelinedSubpartition;
import org.apache.flink.runtime.io.network.partition.ReleaseOnConsumptionResultPartition;
import org.apache.flink.runtime.io.network.partition.ResultPartition;
import org.apache.flink.runtime.io.network.partition.ResultPartitionFactory;
import org.apache.flink.runtime.io.network.partition.ResultPartitionManager;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.shuffle.PartitionDescriptorBuilder;
import org.apache.flink.runtime.shuffle.ShuffleDescriptor;
import org.apache.flink.runtime.util.EnvironmentInformation;
import org.apache.flink.runtime.util.NettyShuffleDescriptorBuilder;
import org.apache.flink.util.TestLogger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class ResultPartitionFactoryTest
extends TestLogger {
    private static final String tempDir = EnvironmentInformation.getTemporaryFileDirectory();
    private static final int SEGMENT_SIZE = 64;
    private static FileChannelManager fileChannelManager;

    @BeforeClass
    public static void setUp() {
        fileChannelManager = new FileChannelManagerImpl(new String[]{tempDir}, "testing");
    }

    @AfterClass
    public static void shutdown() throws Exception {
        fileChannelManager.close();
    }

    @Test
    public void testBoundedBlockingSubpartitionsCreated() {
        ResultPartition resultPartition = ResultPartitionFactoryTest.createResultPartition(false, ResultPartitionType.BLOCKING);
        Arrays.stream(resultPartition.subpartitions).forEach(sp -> MatcherAssert.assertThat((Object)sp, (Matcher)CoreMatchers.instanceOf(BoundedBlockingSubpartition.class)));
    }

    @Test
    public void testPipelinedSubpartitionsCreated() {
        ResultPartition resultPartition = ResultPartitionFactoryTest.createResultPartition(false, ResultPartitionType.PIPELINED);
        Arrays.stream(resultPartition.subpartitions).forEach(sp -> MatcherAssert.assertThat((Object)sp, (Matcher)CoreMatchers.instanceOf(PipelinedSubpartition.class)));
    }

    @Test
    public void testConsumptionOnReleaseForced() {
        ResultPartition resultPartition = ResultPartitionFactoryTest.createResultPartition(true, ResultPartitionType.BLOCKING);
        MatcherAssert.assertThat((Object)resultPartition, (Matcher)CoreMatchers.instanceOf(ReleaseOnConsumptionResultPartition.class));
    }

    @Test
    public void testConsumptionOnReleaseEnabledForNonBlocking() {
        ResultPartition resultPartition = ResultPartitionFactoryTest.createResultPartition(false, ResultPartitionType.PIPELINED);
        MatcherAssert.assertThat((Object)resultPartition, (Matcher)CoreMatchers.instanceOf(ReleaseOnConsumptionResultPartition.class));
    }

    @Test
    public void testConsumptionOnReleaseDisabled() {
        ResultPartition resultPartition = ResultPartitionFactoryTest.createResultPartition(false, ResultPartitionType.BLOCKING);
        MatcherAssert.assertThat((Object)resultPartition, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.instanceOf(ReleaseOnConsumptionResultPartition.class)));
    }

    private static ResultPartition createResultPartition(boolean releasePartitionOnConsumption, ResultPartitionType partitionType) {
        ResultPartitionFactory factory = new ResultPartitionFactory(new ResultPartitionManager(), fileChannelManager, (BufferPoolFactory)new NetworkBufferPool(1, 64, 1), BoundedBlockingSubpartitionType.AUTO, 1, 1, 64, releasePartitionOnConsumption, false, "LZ4", Integer.MAX_VALUE);
        ResultPartitionDeploymentDescriptor descriptor = new ResultPartitionDeploymentDescriptor(PartitionDescriptorBuilder.newBuilder().setPartitionType(partitionType).build(), (ShuffleDescriptor)NettyShuffleDescriptorBuilder.newBuilder().buildLocal(), 1, true);
        return factory.create("test", 0, descriptor);
    }
}

