/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.io.IOException;
import org.apache.flink.runtime.deployment.ResultPartitionDeploymentDescriptor;
import org.apache.flink.runtime.io.disk.FileChannelManager;
import org.apache.flink.runtime.io.network.NettyShuffleEnvironment;
import org.apache.flink.runtime.io.network.api.writer.ResultPartitionWriter;
import org.apache.flink.runtime.io.network.buffer.BufferBuilderTestUtils;
import org.apache.flink.runtime.io.network.partition.BufferAvailabilityListener;
import org.apache.flink.runtime.io.network.partition.NoOpBufferAvailablityListener;
import org.apache.flink.runtime.io.network.partition.PartitionNotFoundException;
import org.apache.flink.runtime.io.network.partition.ResultPartition;
import org.apache.flink.runtime.io.network.partition.ResultPartitionBuilder;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.ResultPartitionProvider;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.shuffle.NettyShuffleDescriptor;
import org.apache.flink.runtime.shuffle.PartitionDescriptor;
import org.apache.flink.runtime.shuffle.PartitionDescriptorBuilder;
import org.apache.flink.runtime.shuffle.ShuffleDescriptor;
import org.apache.flink.runtime.util.NettyShuffleDescriptorBuilder;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

public enum PartitionTestUtils {


    public static ResultPartition createPartition() {
        return PartitionTestUtils.createPartition(ResultPartitionType.PIPELINED_BOUNDED);
    }

    public static ResultPartition createPartition(ResultPartitionType type) {
        return new ResultPartitionBuilder().setResultPartitionType(type).build();
    }

    public static ResultPartition createPartition(ResultPartitionType type, FileChannelManager channelManager) {
        return new ResultPartitionBuilder().setResultPartitionType(type).setFileChannelManager(channelManager).build();
    }

    public static ResultPartition createPartition(ResultPartitionType type, FileChannelManager channelManager, boolean compressionEnabled, int networkBufferSize) {
        return new ResultPartitionBuilder().setResultPartitionType(type).setFileChannelManager(channelManager).setBlockingShuffleCompressionEnabled(compressionEnabled).setNetworkBufferSize(networkBufferSize).build();
    }

    public static ResultPartition createPartition(NettyShuffleEnvironment environment, ResultPartitionType partitionType, int numChannels) {
        return new ResultPartitionBuilder().setResultPartitionManager(environment.getResultPartitionManager()).setupBufferPoolFactoryFromNettyShuffleEnvironment(environment).setResultPartitionType(partitionType).setNumberOfSubpartitions(numChannels).build();
    }

    public static ResultPartition createPartition(NettyShuffleEnvironment environment, FileChannelManager channelManager, ResultPartitionType partitionType, int numChannels) {
        return new ResultPartitionBuilder().setResultPartitionManager(environment.getResultPartitionManager()).setupBufferPoolFactoryFromNettyShuffleEnvironment(environment).setFileChannelManager(channelManager).setResultPartitionType(partitionType).setNumberOfSubpartitions(numChannels).build();
    }

    static void verifyCreateSubpartitionViewThrowsException(ResultPartitionProvider partitionManager, ResultPartitionID partitionId) throws IOException {
        try {
            partitionManager.createSubpartitionView(partitionId, 0, (BufferAvailabilityListener)new NoOpBufferAvailablityListener());
            Assert.fail((String)"Should throw a PartitionNotFoundException.");
        }
        catch (PartitionNotFoundException notFound) {
            Assert.assertThat((Object)partitionId, (Matcher)Matchers.is((Object)notFound.getPartitionId()));
        }
    }

    public static ResultPartitionDeploymentDescriptor createPartitionDeploymentDescriptor(ResultPartitionType partitionType) {
        NettyShuffleDescriptor shuffleDescriptor = NettyShuffleDescriptorBuilder.newBuilder().buildLocal();
        PartitionDescriptor partitionDescriptor = PartitionDescriptorBuilder.newBuilder().setPartitionId(shuffleDescriptor.getResultPartitionID().getPartitionId()).setPartitionType(partitionType).build();
        return new ResultPartitionDeploymentDescriptor(partitionDescriptor, (ShuffleDescriptor)shuffleDescriptor, 1, true);
    }

    public static void writeBuffers(ResultPartitionWriter partition, int numberOfBuffers, int bufferSize) throws IOException {
        for (int i = 0; i < numberOfBuffers; ++i) {
            partition.addBufferConsumer(BufferBuilderTestUtils.createFilledFinishedBufferConsumer(bufferSize), 0);
        }
        partition.finish();
    }
}

