/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.api.writer;

import java.io.IOException;
import java.util.ArrayDeque;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferBuilder;
import org.apache.flink.runtime.io.network.buffer.BufferConsumer;
import org.apache.flink.runtime.io.network.buffer.BufferProvider;
import org.apache.flink.runtime.io.network.partition.MockResultPartitionWriter;
import org.apache.flink.util.Preconditions;

@ThreadSafe
public abstract class AbstractCollectingResultPartitionWriter
extends MockResultPartitionWriter {
    private final BufferProvider bufferProvider;
    private final ArrayDeque<BufferConsumer> bufferConsumers = new ArrayDeque();

    public AbstractCollectingResultPartitionWriter(BufferProvider bufferProvider) {
        this.bufferProvider = (BufferProvider)Preconditions.checkNotNull((Object)bufferProvider);
    }

    @Override
    public BufferBuilder getBufferBuilder(int targetChannel) throws IOException, InterruptedException {
        return this.bufferProvider.requestBufferBuilderBlocking(targetChannel);
    }

    @Override
    public BufferBuilder tryGetBufferBuilder(int targetChannel) throws IOException {
        return this.bufferProvider.requestBufferBuilder(targetChannel);
    }

    @Override
    public synchronized boolean addBufferConsumer(BufferConsumer bufferConsumer, int targetChannel, boolean isPriorityEvent) throws IOException {
        Preconditions.checkState((targetChannel < this.getNumberOfSubpartitions() ? 1 : 0) != 0);
        this.bufferConsumers.add(bufferConsumer);
        this.processBufferConsumers();
        return true;
    }

    private void processBufferConsumers() throws IOException {
        while (!this.bufferConsumers.isEmpty()) {
            BufferConsumer bufferConsumer = this.bufferConsumers.peek();
            Buffer buffer = bufferConsumer.build();
            try {
                this.deserializeBuffer(buffer);
                if (!bufferConsumer.isFinished()) break;
                this.bufferConsumers.pop().close();
            }
            finally {
                buffer.recycleBuffer();
            }
        }
    }

    @Override
    public synchronized void flushAll() {
        try {
            this.processBufferConsumers();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void flush(int subpartitionIndex) {
        this.flushAll();
    }

    protected abstract void deserializeBuffer(Buffer var1) throws IOException;
}

