/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network;

import java.time.Duration;
import java.util.concurrent.Executor;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.concurrent.Executors;
import org.apache.flink.runtime.io.network.NettyShuffleEnvironment;
import org.apache.flink.runtime.io.network.NettyShuffleServiceFactory;
import org.apache.flink.runtime.io.network.TaskEventDispatcher;
import org.apache.flink.runtime.io.network.TaskEventPublisher;
import org.apache.flink.runtime.io.network.netty.NettyConfig;
import org.apache.flink.runtime.io.network.partition.BoundedBlockingSubpartitionType;
import org.apache.flink.runtime.io.network.partition.ResultPartitionManager;
import org.apache.flink.runtime.metrics.groups.UnregisteredMetricGroups;
import org.apache.flink.runtime.taskmanager.NettyShuffleEnvironmentConfiguration;
import org.apache.flink.runtime.util.EnvironmentInformation;

public class NettyShuffleEnvironmentBuilder {
    private static final int DEFAULT_NETWORK_BUFFER_SIZE = 32768;
    private static final int DEFAULT_NUM_NETWORK_BUFFERS = 1024;
    private static final String[] DEFAULT_TEMP_DIRS = new String[]{EnvironmentInformation.getTemporaryFileDirectory()};
    private static final Duration DEFAULT_REQUEST_SEGMENTS_TIMEOUT = Duration.ofMillis(30000L);
    private int bufferSize = 32768;
    private int numNetworkBuffers = 1024;
    private int partitionRequestInitialBackoff;
    private int partitionRequestMaxBackoff;
    private int networkBuffersPerChannel = 2;
    private int floatingNetworkBuffersPerGate = 8;
    private int maxBuffersPerChannel = Integer.MAX_VALUE;
    private boolean blockingShuffleCompressionEnabled = false;
    private String compressionCodec = "LZ4";
    private ResourceID taskManagerLocation = ResourceID.generate();
    private NettyConfig nettyConfig;
    private MetricGroup metricGroup = UnregisteredMetricGroups.createUnregisteredTaskManagerMetricGroup();
    private ResultPartitionManager resultPartitionManager = new ResultPartitionManager();
    private Executor ioExecutor = Executors.directExecutor();

    public NettyShuffleEnvironmentBuilder setTaskManagerLocation(ResourceID taskManagerLocation) {
        this.taskManagerLocation = taskManagerLocation;
        return this;
    }

    public NettyShuffleEnvironmentBuilder setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
        return this;
    }

    public NettyShuffleEnvironmentBuilder setNumNetworkBuffers(int numNetworkBuffers) {
        this.numNetworkBuffers = numNetworkBuffers;
        return this;
    }

    public NettyShuffleEnvironmentBuilder setPartitionRequestInitialBackoff(int partitionRequestInitialBackoff) {
        this.partitionRequestInitialBackoff = partitionRequestInitialBackoff;
        return this;
    }

    public NettyShuffleEnvironmentBuilder setPartitionRequestMaxBackoff(int partitionRequestMaxBackoff) {
        this.partitionRequestMaxBackoff = partitionRequestMaxBackoff;
        return this;
    }

    public NettyShuffleEnvironmentBuilder setNetworkBuffersPerChannel(int networkBuffersPerChannel) {
        this.networkBuffersPerChannel = networkBuffersPerChannel;
        return this;
    }

    public NettyShuffleEnvironmentBuilder setFloatingNetworkBuffersPerGate(int floatingNetworkBuffersPerGate) {
        this.floatingNetworkBuffersPerGate = floatingNetworkBuffersPerGate;
        return this;
    }

    public NettyShuffleEnvironmentBuilder setMaxBuffersPerChannel(int maxBuffersPerChannel) {
        this.maxBuffersPerChannel = maxBuffersPerChannel;
        return this;
    }

    public NettyShuffleEnvironmentBuilder setBlockingShuffleCompressionEnabled(boolean blockingShuffleCompressionEnabled) {
        this.blockingShuffleCompressionEnabled = blockingShuffleCompressionEnabled;
        return this;
    }

    public NettyShuffleEnvironmentBuilder setCompressionCodec(String compressionCodec) {
        this.compressionCodec = compressionCodec;
        return this;
    }

    public NettyShuffleEnvironmentBuilder setNettyConfig(NettyConfig nettyConfig) {
        this.nettyConfig = nettyConfig;
        return this;
    }

    public NettyShuffleEnvironmentBuilder setMetricGroup(MetricGroup metricGroup) {
        this.metricGroup = metricGroup;
        return this;
    }

    public NettyShuffleEnvironmentBuilder setResultPartitionManager(ResultPartitionManager resultPartitionManager) {
        this.resultPartitionManager = resultPartitionManager;
        return this;
    }

    public NettyShuffleEnvironmentBuilder setIoExecutor(Executor ioExecutor) {
        this.ioExecutor = ioExecutor;
        return this;
    }

    public NettyShuffleEnvironment build() {
        return NettyShuffleServiceFactory.createNettyShuffleEnvironment((NettyShuffleEnvironmentConfiguration)new NettyShuffleEnvironmentConfiguration(this.numNetworkBuffers, 32768, this.partitionRequestInitialBackoff, this.partitionRequestMaxBackoff, this.networkBuffersPerChannel, this.floatingNetworkBuffersPerGate, DEFAULT_REQUEST_SEGMENTS_TIMEOUT, false, this.nettyConfig, DEFAULT_TEMP_DIRS, BoundedBlockingSubpartitionType.AUTO, false, this.blockingShuffleCompressionEnabled, this.compressionCodec, this.maxBuffersPerChannel), (ResourceID)this.taskManagerLocation, (TaskEventPublisher)new TaskEventDispatcher(), (ResultPartitionManager)this.resultPartitionManager, (MetricGroup)this.metricGroup, (Executor)this.ioExecutor);
    }
}

