/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph.utils;

import java.net.InetAddress;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.clusterframework.types.SlotProfile;
import org.apache.flink.runtime.concurrent.FutureUtils;
import org.apache.flink.runtime.executiongraph.utils.SimpleAckingTaskManagerGateway;
import org.apache.flink.runtime.instance.SimpleSlotContext;
import org.apache.flink.runtime.instance.SlotSharingGroupId;
import org.apache.flink.runtime.jobmanager.scheduler.NoResourceAvailableException;
import org.apache.flink.runtime.jobmanager.scheduler.ScheduledUnit;
import org.apache.flink.runtime.jobmanager.slots.TaskManagerGateway;
import org.apache.flink.runtime.jobmaster.LogicalSlot;
import org.apache.flink.runtime.jobmaster.SlotContext;
import org.apache.flink.runtime.jobmaster.SlotOwner;
import org.apache.flink.runtime.jobmaster.SlotRequestId;
import org.apache.flink.runtime.jobmaster.TestingLogicalSlot;
import org.apache.flink.runtime.jobmaster.TestingLogicalSlotBuilder;
import org.apache.flink.runtime.jobmaster.slotpool.SlotProvider;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.Preconditions;

public class SimpleSlotProvider
implements SlotProvider,
SlotOwner {
    private final Object lock = new Object();
    private final ArrayDeque<SlotContext> slots;
    private final HashMap<SlotRequestId, SlotContext> allocatedSlots;

    public SimpleSlotProvider(int numSlots) {
        this(numSlots, new SimpleAckingTaskManagerGateway());
    }

    public SimpleSlotProvider(int numSlots, TaskManagerGateway taskManagerGateway) {
        Preconditions.checkArgument((numSlots >= 0 ? 1 : 0) != 0, (Object)"numSlots must be >= 0");
        this.slots = new ArrayDeque(numSlots);
        for (int i = 0; i < numSlots; ++i) {
            SimpleSlotContext as = new SimpleSlotContext(new AllocationID(), new TaskManagerLocation(ResourceID.generate(), InetAddress.getLoopbackAddress(), 10000 + i), 0, taskManagerGateway, ResourceProfile.ANY);
            this.slots.add(as);
        }
        this.allocatedSlots = new HashMap(this.slots.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<LogicalSlot> allocateSlot(SlotRequestId slotRequestId, ScheduledUnit task, SlotProfile slotProfile, Time allocationTimeout) {
        Object object = this.lock;
        synchronized (object) {
            SlotContext slot = this.slots.isEmpty() ? null : this.slots.removeFirst();
            if (slot != null) {
                TestingLogicalSlot result = new TestingLogicalSlotBuilder().setTaskManagerLocation(slot.getTaskManagerLocation()).setTaskManagerGateway(slot.getTaskManagerGateway()).setSlotNumber(slot.getPhysicalSlotNumber()).setAllocationId(slot.getAllocationId()).setSlotRequestId(slotRequestId).setSlotSharingGroupId(task.getSlotSharingGroupId()).setSlotOwner(this).createTestingLogicalSlot();
                this.allocatedSlots.put(slotRequestId, slot);
                return CompletableFuture.completedFuture(result);
            }
            return FutureUtils.completedExceptionally((Throwable)new NoResourceAvailableException());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelSlotRequest(SlotRequestId slotRequestId, @Nullable SlotSharingGroupId slotSharingGroupId, Throwable cause) {
        Object object = this.lock;
        synchronized (object) {
            SlotContext slotContext = this.allocatedSlots.remove(slotRequestId);
            if (slotContext == null) {
                throw new FlinkRuntimeException("Unknown slot request id " + slotRequestId + '.');
            }
            this.slots.add(slotContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnLogicalSlot(LogicalSlot logicalSlot) {
        Object object = this.lock;
        synchronized (object) {
            SimpleSlotContext as = new SimpleSlotContext(logicalSlot.getAllocationId(), logicalSlot.getTaskManagerLocation(), logicalSlot.getPhysicalSlotNumber(), logicalSlot.getTaskManagerGateway(), ResourceProfile.ANY);
            this.slots.add(as);
            this.allocatedSlots.remove(logicalSlot.getSlotRequestId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfAvailableSlots() {
        Object object = this.lock;
        synchronized (object) {
            return this.slots.size();
        }
    }
}

