/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph.restart;

import org.apache.flink.runtime.concurrent.ManuallyTriggeredScheduledExecutor;
import org.apache.flink.runtime.concurrent.ScheduledExecutor;
import org.apache.flink.runtime.executiongraph.restart.NoOpRestarter;
import org.apache.flink.runtime.executiongraph.restart.RestartCallback;
import org.apache.flink.runtime.executiongraph.restart.RestartStrategy;
import org.apache.flink.runtime.executiongraph.restart.ThrowingRestartStrategy;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ThrowingRestartStrategyFactoryTest
extends TestLogger {
    private RestartStrategy restartStrategy;

    @Before
    public void setUp() {
        this.restartStrategy = new ThrowingRestartStrategy();
    }

    @Test
    public void restartShouldThrowException() {
        ManuallyTriggeredScheduledExecutor manuallyTriggeredScheduledExecutor = new ManuallyTriggeredScheduledExecutor();
        try {
            this.restartStrategy.restart((RestartCallback)new NoOpRestarter(), (ScheduledExecutor)manuallyTriggeredScheduledExecutor);
            Assert.fail((String)"Expected exception not thrown");
        }
        catch (IllegalStateException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"Unexpected restart() call")));
            Assert.assertThat((Object)manuallyTriggeredScheduledExecutor.numQueuedRunnables(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)0)));
        }
    }

    @Test
    public void canRestartShouldThrowException() {
        try {
            this.restartStrategy.canRestart();
            Assert.fail((String)"Expected exception not thrown");
        }
        catch (IllegalStateException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"Unexpected canRestart() call")));
        }
    }
}

