/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph.restart;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.core.testutils.OneShotLatch;
import org.apache.flink.runtime.concurrent.ScheduledExecutor;
import org.apache.flink.runtime.concurrent.ScheduledExecutorServiceAdapter;
import org.apache.flink.runtime.executiongraph.restart.FailureRateRestartStrategy;
import org.apache.flink.runtime.executiongraph.restart.LatchedRestarter;
import org.apache.flink.runtime.executiongraph.restart.NoOpRestarter;
import org.apache.flink.runtime.executiongraph.restart.RestartCallback;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class FailureRateRestartStrategyTest {
    public final ScheduledExecutorService executorService = Executors.newScheduledThreadPool(4);
    public final ScheduledExecutor executor = new ScheduledExecutorServiceAdapter(this.executorService);

    @After
    public void shutdownExecutor() {
        this.executorService.shutdownNow();
    }

    @Test
    public void testManyFailuresWithinRate() throws Exception {
        int numAttempts = 10;
        boolean intervalMillis = true;
        FailureRateRestartStrategy restartStrategy = new FailureRateRestartStrategy(1, Time.milliseconds((long)1L), Time.milliseconds((long)0L));
        for (int attempsLeft = 10; attempsLeft > 0; --attempsLeft) {
            Assert.assertTrue((boolean)restartStrategy.canRestart());
            restartStrategy.restart((RestartCallback)new NoOpRestarter(), this.executor);
            FailureRateRestartStrategyTest.sleepGuaranteed(2L);
        }
        Assert.assertTrue((boolean)restartStrategy.canRestart());
    }

    @Test
    public void testFailuresExceedingRate() throws Exception {
        int numFailures = 3;
        int intervalMillis = 10000;
        FailureRateRestartStrategy restartStrategy = new FailureRateRestartStrategy(3, Time.milliseconds((long)10000L), Time.milliseconds((long)0L));
        for (int failuresLeft = 3; failuresLeft > 0; --failuresLeft) {
            Assert.assertTrue((boolean)restartStrategy.canRestart());
            restartStrategy.restart((RestartCallback)new NoOpRestarter(), this.executor);
        }
        Assert.assertFalse((boolean)restartStrategy.canRestart());
    }

    @Test
    public void testDelay() throws Exception {
        long restartDelay = 2L;
        int numberRestarts = 10;
        FailureRateRestartStrategy strategy = new FailureRateRestartStrategy(11, Time.milliseconds((long)1L), Time.milliseconds((long)2L));
        for (int restartsLeft = 10; restartsLeft > 0; --restartsLeft) {
            Assert.assertTrue((boolean)strategy.canRestart());
            OneShotLatch sync = new OneShotLatch();
            LatchedRestarter restarter = new LatchedRestarter(sync);
            long time = System.nanoTime();
            strategy.restart((RestartCallback)restarter, this.executor);
            sync.await();
            long elapsed = System.nanoTime() - time;
            Assert.assertTrue((String)"Not enough delay", (elapsed >= 2000000L ? 1 : 0) != 0);
        }
    }

    private static void sleepGuaranteed(long millis) throws InterruptedException {
        long nanosToSleep;
        long deadline = System.nanoTime() + millis * 1000000L;
        while ((nanosToSleep = deadline - System.nanoTime()) > 0L) {
            long millisToSleep = nanosToSleep / 1000000L;
            if (nanosToSleep % 1000000L != 0L) {
                ++millisToSleep;
            }
            Thread.sleep(millisToSleep);
        }
    }
}

