/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph.failover.flip1.partitionrelease;

import java.util.Collections;
import org.apache.flink.runtime.executiongraph.failover.flip1.partitionrelease.PipelinedRegionExecutionView;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.runtime.scheduler.strategy.SchedulingPipelinedRegion;
import org.apache.flink.runtime.scheduler.strategy.TestingSchedulingExecutionVertex;
import org.apache.flink.runtime.scheduler.strategy.TestingSchedulingPipelinedRegion;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public class PipelinedRegionExecutionViewTest
extends TestLogger {
    private static final ExecutionVertexID TEST_EXECUTION_VERTEX_ID = new ExecutionVertexID(new JobVertexID(), 0);
    private static final TestingSchedulingPipelinedRegion TEST_PIPELINED_REGION = new TestingSchedulingPipelinedRegion(Collections.singleton(new TestingSchedulingExecutionVertex(TEST_EXECUTION_VERTEX_ID.getJobVertexId(), TEST_EXECUTION_VERTEX_ID.getSubtaskIndex())));

    @Test
    public void regionIsUnfinishedIfNotAllVerticesAreFinished() {
        PipelinedRegionExecutionView pipelinedRegionExecutionView = new PipelinedRegionExecutionView((SchedulingPipelinedRegion)TEST_PIPELINED_REGION);
        Assert.assertFalse((boolean)pipelinedRegionExecutionView.isFinished());
    }

    @Test
    public void regionIsFinishedIfAllVerticesAreFinished() {
        PipelinedRegionExecutionView pipelinedRegionExecutionView = new PipelinedRegionExecutionView((SchedulingPipelinedRegion)TEST_PIPELINED_REGION);
        pipelinedRegionExecutionView.vertexFinished(TEST_EXECUTION_VERTEX_ID);
        Assert.assertTrue((boolean)pipelinedRegionExecutionView.isFinished());
    }

    @Test
    public void vertexCanBeUnfinished() {
        PipelinedRegionExecutionView pipelinedRegionExecutionView = new PipelinedRegionExecutionView((SchedulingPipelinedRegion)TEST_PIPELINED_REGION);
        pipelinedRegionExecutionView.vertexFinished(TEST_EXECUTION_VERTEX_ID);
        pipelinedRegionExecutionView.vertexUnfinished(TEST_EXECUTION_VERTEX_ID);
        Assert.assertFalse((boolean)pipelinedRegionExecutionView.isFinished());
    }

    @Test(expected=IllegalArgumentException.class)
    public void finishingUnknownVertexThrowsException() {
        PipelinedRegionExecutionView pipelinedRegionExecutionView = new PipelinedRegionExecutionView((SchedulingPipelinedRegion)TEST_PIPELINED_REGION);
        ExecutionVertexID unknownVertexId = new ExecutionVertexID(new JobVertexID(), 0);
        pipelinedRegionExecutionView.vertexFinished(unknownVertexId);
    }
}

