/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph.failover.flip1;

import java.util.HashSet;
import org.apache.flink.runtime.executiongraph.failover.flip1.FailureHandlingResult;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public class FailureHandlingResultTest
extends TestLogger {
    @Test
    public void testNormalFailureHandlingResult() {
        HashSet<ExecutionVertexID> tasks = new HashSet<ExecutionVertexID>();
        tasks.add(new ExecutionVertexID(new JobVertexID(), 0));
        long delay = 1234L;
        FailureHandlingResult result = FailureHandlingResult.restartable(tasks, (long)delay, (boolean)false);
        Assert.assertTrue((boolean)result.canRestart());
        Assert.assertEquals((long)delay, (long)result.getRestartDelayMS());
        Assert.assertEquals(tasks, (Object)result.getVerticesToRestart());
        try {
            result.getError();
            Assert.fail((String)"Cannot get error when the restarting is accepted");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testRestartingSuppressedFailureHandlingResult() {
        Exception error = new Exception("test error");
        FailureHandlingResult result = FailureHandlingResult.unrecoverable((Throwable)error, (boolean)false);
        Assert.assertFalse((boolean)result.canRestart());
        Assert.assertEquals((Object)error, (Object)result.getError());
        try {
            result.getVerticesToRestart();
            Assert.fail((String)"get tasks to restart is not allowed when restarting is suppressed");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            result.getRestartDelayMS();
            Assert.fail((String)"get restart delay is not allowed when restarting is suppressed");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }
}

