/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.clusterframework.types.SlotProfile;
import org.apache.flink.runtime.concurrent.ComponentMainThreadExecutor;
import org.apache.flink.runtime.instance.SlotSharingGroupId;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobmanager.scheduler.ScheduledUnit;
import org.apache.flink.runtime.jobmaster.LogicalSlot;
import org.apache.flink.runtime.jobmaster.SlotRequestId;
import org.apache.flink.runtime.jobmaster.slotpool.Scheduler;
import org.apache.flink.util.Preconditions;

class ProgrammedSlotProvider
implements Scheduler {
    private final Map<JobVertexID, CompletableFuture<LogicalSlot>[]> slotFutures = new HashMap<JobVertexID, CompletableFuture<LogicalSlot>[]>();
    private final Map<JobVertexID, CompletableFuture<Boolean>[]> slotFutureRequested = new HashMap<JobVertexID, CompletableFuture<Boolean>[]>();
    private final Set<SlotRequestId> slotRequests = new HashSet<SlotRequestId>();
    private final Set<SlotRequestId> canceledSlotRequests = new HashSet<SlotRequestId>();
    private final int parallelism;

    public ProgrammedSlotProvider(int parallelism) {
        Preconditions.checkArgument((parallelism > 0 ? 1 : 0) != 0);
        this.parallelism = parallelism;
    }

    public void addSlot(JobVertexID vertex, int subtaskIndex, CompletableFuture<LogicalSlot> future) {
        Preconditions.checkNotNull((Object)vertex);
        Preconditions.checkNotNull(future);
        Preconditions.checkArgument((subtaskIndex >= 0 && subtaskIndex < this.parallelism ? 1 : 0) != 0);
        CompletableFuture<LogicalSlot>[] futures = this.slotFutures.get(vertex);
        CompletableFuture<Boolean>[] requestedFutures = this.slotFutureRequested.get(vertex);
        if (futures == null) {
            CompletableFuture[] newArray = new CompletableFuture[this.parallelism];
            futures = newArray;
            this.slotFutures.put(vertex, futures);
            requestedFutures = new CompletableFuture[this.parallelism];
            this.slotFutureRequested.put(vertex, requestedFutures);
        }
        futures[subtaskIndex] = future;
        requestedFutures[subtaskIndex] = new CompletableFuture();
    }

    public void addSlots(JobVertexID vertex, CompletableFuture<LogicalSlot>[] futures) {
        Preconditions.checkNotNull((Object)vertex);
        Preconditions.checkNotNull(futures);
        Preconditions.checkArgument((futures.length == this.parallelism ? 1 : 0) != 0);
        this.slotFutures.put(vertex, futures);
        CompletableFuture[] requestedFutures = new CompletableFuture[futures.length];
        for (int i = 0; i < futures.length; ++i) {
            requestedFutures[i] = new CompletableFuture();
        }
        this.slotFutureRequested.put(vertex, requestedFutures);
    }

    public CompletableFuture<Boolean> getSlotRequestedFuture(JobVertexID jobVertexId, int subtaskIndex) {
        return this.slotFutureRequested.get(jobVertexId)[subtaskIndex];
    }

    public Set<SlotRequestId> getSlotRequests() {
        return Collections.unmodifiableSet(this.slotRequests);
    }

    public Set<SlotRequestId> getCanceledSlotRequests() {
        return Collections.unmodifiableSet(this.canceledSlotRequests);
    }

    public CompletableFuture<LogicalSlot> allocateSlot(SlotRequestId slotRequestId, ScheduledUnit task, SlotProfile slotProfile, Time allocationTimeout) {
        CompletableFuture<LogicalSlot> future;
        JobVertexID vertexId = task.getJobVertexId();
        int subtask = task.getSubtaskIndex();
        CompletableFuture<LogicalSlot>[] forTask = this.slotFutures.get(vertexId);
        if (forTask != null && (future = forTask[subtask]) != null) {
            this.slotFutureRequested.get(vertexId)[subtask].complete(true);
            this.slotRequests.add(slotRequestId);
            return future;
        }
        throw new IllegalArgumentException("No registered slot future for task " + vertexId + " (" + subtask + ')');
    }

    public void cancelSlotRequest(SlotRequestId slotRequestId, @Nullable SlotSharingGroupId slotSharingGroupId, Throwable cause) {
        this.canceledSlotRequests.add(slotRequestId);
    }

    public void start(@Nonnull ComponentMainThreadExecutor mainThreadExecutor) {
    }

    public boolean requiresPreviousExecutionGraphAllocations() {
        return false;
    }

    public void returnLogicalSlot(LogicalSlot logicalSlot) {
        throw new UnsupportedOperationException();
    }
}

