/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.runtime.akka.AkkaUtils;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.ExecutionGraphTestUtils;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.executiongraph.IntermediateResult;
import org.apache.flink.runtime.executiongraph.SlotProviderStrategy;
import org.apache.flink.runtime.executiongraph.TestingSlotProvider;
import org.apache.flink.runtime.executiongraph.TestingSlotProviderStrategy;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobmanager.scheduler.LocationPreferenceConstraint;
import org.apache.flink.runtime.jobmaster.TestingLogicalSlot;
import org.apache.flink.runtime.jobmaster.TestingLogicalSlotBuilder;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public class ExecutionVertexSchedulingTest
extends TestLogger {
    @Test
    public void testSlotReleasedWhenScheduledImmediately() {
        try {
            ExecutionJobVertex ejv = ExecutionGraphTestUtils.getExecutionJobVertex(new JobVertexID());
            ExecutionVertex vertex = new ExecutionVertex(ejv, 0, new IntermediateResult[0], AkkaUtils.getDefaultTimeout());
            TestingLogicalSlot slot = new TestingLogicalSlotBuilder().createTestingLogicalSlot();
            slot.releaseSlot(new Exception("Test Exception"));
            Assert.assertFalse((boolean)slot.isAlive());
            CompletableFuture<TestingLogicalSlot> future = new CompletableFuture<TestingLogicalSlot>();
            future.complete(slot);
            Assert.assertEquals((Object)ExecutionState.CREATED, (Object)vertex.getExecutionState());
            vertex.scheduleForExecution((SlotProviderStrategy)TestingSlotProviderStrategy.from(new TestingSlotProvider(i -> future)), LocationPreferenceConstraint.ALL, Collections.emptySet());
            Assert.assertEquals((Object)ExecutionState.FAILED, (Object)vertex.getExecutionState());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSlotReleasedWhenScheduledQueued() {
        try {
            ExecutionJobVertex ejv = ExecutionGraphTestUtils.getExecutionJobVertex(new JobVertexID());
            ExecutionVertex vertex = new ExecutionVertex(ejv, 0, new IntermediateResult[0], AkkaUtils.getDefaultTimeout());
            TestingLogicalSlot slot = new TestingLogicalSlotBuilder().createTestingLogicalSlot();
            slot.releaseSlot(new Exception("Test Exception"));
            Assert.assertFalse((boolean)slot.isAlive());
            CompletableFuture<TestingLogicalSlot> future = new CompletableFuture<TestingLogicalSlot>();
            Assert.assertEquals((Object)ExecutionState.CREATED, (Object)vertex.getExecutionState());
            vertex.scheduleForExecution((SlotProviderStrategy)TestingSlotProviderStrategy.from(new TestingSlotProvider(ignore -> future)), LocationPreferenceConstraint.ALL, Collections.emptySet());
            Assert.assertEquals((Object)ExecutionState.SCHEDULED, (Object)vertex.getExecutionState());
            future.complete(slot);
            Assert.assertEquals((Object)ExecutionState.FAILED, (Object)vertex.getExecutionState());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testScheduleToDeploying() {
        try {
            ExecutionJobVertex ejv = ExecutionGraphTestUtils.getExecutionJobVertex(new JobVertexID());
            ExecutionVertex vertex = new ExecutionVertex(ejv, 0, new IntermediateResult[0], AkkaUtils.getDefaultTimeout());
            TestingLogicalSlot slot = new TestingLogicalSlotBuilder().createTestingLogicalSlot();
            CompletableFuture<TestingLogicalSlot> future = CompletableFuture.completedFuture(slot);
            Assert.assertEquals((Object)ExecutionState.CREATED, (Object)vertex.getExecutionState());
            vertex.scheduleForExecution((SlotProviderStrategy)TestingSlotProviderStrategy.from(new TestingSlotProvider(ignore -> future)), LocationPreferenceConstraint.ALL, Collections.emptySet());
            Assert.assertEquals((Object)ExecutionState.DEPLOYING, (Object)vertex.getExecutionState());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

