/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.BlobServerOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.blob.BlobServer;
import org.apache.flink.runtime.blob.BlobStore;
import org.apache.flink.runtime.blob.PermanentBlobKey;
import org.apache.flink.runtime.blob.VoidBlobStore;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionGraphDeploymentTest;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.types.Either;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class ExecutionGraphDeploymentWithBlobServerTest
extends ExecutionGraphDeploymentTest {
    private Set<byte[]> seenHashes = Collections.newSetFromMap(new ConcurrentHashMap());
    protected BlobServer blobServer = null;

    @Before
    public void setupBlobServer() throws IOException {
        Configuration config = new Configuration();
        config.setInteger(BlobServerOptions.OFFLOAD_MINSIZE, 0);
        this.blobServer = (BlobServer)Mockito.spy((Object)new BlobServer(config, (BlobStore)new VoidBlobStore()));
        this.blobWriter = this.blobServer;
        this.blobCache = this.blobServer;
        this.seenHashes.clear();
        ((BlobServer)Mockito.doAnswer(invocation -> {
            PermanentBlobKey key = (PermanentBlobKey)invocation.callRealMethod();
            Assert.assertTrue((boolean)this.seenHashes.add(key.getHash()));
            return key;
        }).when((Object)this.blobServer)).putPermanent((JobID)Matchers.any(JobID.class), (byte[])Matchers.any());
        this.blobServer.start();
    }

    @After
    public void shutdownBlobServer() throws IOException {
        if (this.blobServer != null) {
            this.blobServer.close();
        }
    }

    @Override
    protected void checkJobOffloaded(ExecutionGraph eg) throws Exception {
        Either jobInformationOrBlobKey = eg.getJobInformationOrBlobKey();
        Assert.assertTrue((boolean)jobInformationOrBlobKey.isRight());
        this.blobServer.getFile(eg.getJobID(), (PermanentBlobKey)jobInformationOrBlobKey.right());
    }

    @Override
    protected void checkTaskOffloaded(ExecutionGraph eg, JobVertexID jobVertexId) throws Exception {
        Either taskInformationOrBlobKey = eg.getJobVertex(jobVertexId).getTaskInformationOrBlobKey();
        Assert.assertTrue((boolean)taskInformationOrBlobKey.isRight());
        this.blobServer.getFile(eg.getJobID(), (PermanentBlobKey)taskInformationOrBlobKey.right());
    }
}

