/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.util.function.Predicate;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.runtime.concurrent.ComponentMainThreadExecutor;
import org.apache.flink.runtime.concurrent.ComponentMainThreadExecutorServiceAdapter;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.AccessExecution;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionGraphTestUtils;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.executiongraph.TestRestartStrategy;
import org.apache.flink.runtime.executiongraph.TestingExecutionGraphBuilder;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobmanager.scheduler.CoLocationConstraint;
import org.apache.flink.runtime.jobmanager.scheduler.SchedulerTestBase;
import org.apache.flink.runtime.jobmanager.scheduler.SlotSharingGroup;
import org.apache.flink.util.FlinkException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class ExecutionGraphCoLocationRestartTest
extends SchedulerTestBase {
    private static final int NUM_TASKS = 31;

    @Override
    protected ComponentMainThreadExecutor getComponentMainThreadExecutor() {
        return ComponentMainThreadExecutorServiceAdapter.forMainThread();
    }

    @Test
    public void testConstraintsAfterRestart() throws Exception {
        long timeout = 5000L;
        this.testingSlotProvider.addTaskManager(31);
        JobVertex groupVertex = ExecutionGraphTestUtils.createNoOpVertex(31);
        JobVertex groupVertex2 = ExecutionGraphTestUtils.createNoOpVertex(31);
        SlotSharingGroup sharingGroup = new SlotSharingGroup();
        groupVertex.setSlotSharingGroup(sharingGroup);
        groupVertex2.setSlotSharingGroup(sharingGroup);
        groupVertex.setStrictlyCoLocatedWith(groupVertex2);
        ExecutionGraph eg = TestingExecutionGraphBuilder.newBuilder().setJobGraph(new JobGraph(new JobVertex[]{groupVertex, groupVertex2})).setSlotProvider(this.testingSlotProvider).setRestartStrategy(new TestRestartStrategy(1, false)).build();
        eg.start(ComponentMainThreadExecutorServiceAdapter.forMainThread());
        Assert.assertEquals((Object)JobStatus.CREATED, (Object)eg.getState());
        eg.scheduleForExecution();
        Predicate<AccessExecution> isDeploying = ExecutionGraphTestUtils.isInExecutionState(ExecutionState.DEPLOYING);
        ExecutionGraphTestUtils.waitForAllExecutionsPredicate(eg, isDeploying, 5000L);
        Assert.assertEquals((Object)JobStatus.RUNNING, (Object)eg.getState());
        this.validateConstraints(eg);
        ((ExecutionVertex)eg.getAllExecutionVertices().iterator().next()).fail((Throwable)new FlinkException("Test exception"));
        Assert.assertEquals((Object)JobStatus.FAILING, (Object)eg.getState());
        for (ExecutionVertex vertex : eg.getAllExecutionVertices()) {
            vertex.getCurrentExecutionAttempt().completeCancelling();
        }
        ExecutionGraphTestUtils.waitUntilJobStatus(eg, JobStatus.RUNNING, 5000L);
        ExecutionGraphTestUtils.waitForAllExecutionsPredicate(eg, isDeploying, 5000L);
        this.validateConstraints(eg);
        ExecutionGraphTestUtils.finishAllVertices(eg);
        Assert.assertThat((Object)eg.getState(), (Matcher)Matchers.is((Object)JobStatus.FINISHED));
    }

    private void validateConstraints(ExecutionGraph eg) {
        ExecutionJobVertex[] tasks = eg.getAllVertices().values().toArray(new ExecutionJobVertex[2]);
        for (int i = 0; i < 31; ++i) {
            CoLocationConstraint constr1 = tasks[0].getTaskVertices()[i].getLocationConstraint();
            CoLocationConstraint constr2 = tasks[1].getTaskVertices()[i].getLocationConstraint();
            Assert.assertThat((Object)constr1.isAssigned(), (Matcher)Matchers.is((Object)true));
            Assert.assertThat((Object)constr1.getLocation(), (Matcher)Matchers.equalTo((Object)constr2.getLocation()));
        }
    }
}

