/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.entrypoint.component;

import java.io.File;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.UnmodifiableConfiguration;
import org.apache.flink.runtime.entrypoint.component.FileJobGraphRetriever;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.util.FileUtils;
import org.apache.flink.util.FlinkException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class FileJobGraphRetrieverTest {
    @Rule
    public final TemporaryFolder temporaryFolder = new TemporaryFolder();
    @ClassRule
    public static final TemporaryFolder TEMPORARY_FOLDER = new TemporaryFolder();
    private static Configuration configuration;
    private static Path jarFileInJobGraph;

    @BeforeClass
    public static void init() throws IOException {
        Path jobGraphPath = TEMPORARY_FOLDER.newFile((String)FileJobGraphRetriever.JOB_GRAPH_FILE_PATH.defaultValue()).toPath();
        jarFileInJobGraph = TEMPORARY_FOLDER.newFile("jar_file_in_job_graph.jar").toPath();
        JobVertex source = new JobVertex("source");
        JobVertex target = new JobVertex("target");
        JobGraph jobGraph = new JobGraph(new JobID(), "test", new JobVertex[]{source, target});
        jobGraph.setClasspaths(Collections.singletonList(jarFileInJobGraph.toUri().toURL()));
        try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(Files.newOutputStream(jobGraphPath, StandardOpenOption.CREATE));){
            objectOutputStream.writeObject(jobGraph);
        }
        Configuration cfg = new Configuration();
        cfg.setString(FileJobGraphRetriever.JOB_GRAPH_FILE_PATH.key(), jobGraphPath.toString());
        configuration = new UnmodifiableConfiguration(cfg);
    }

    @Test
    public void testRetrieveJobGraphWithJarInUsrLibDir() throws IOException, FlinkException {
        File usrLibDir = this.temporaryFolder.newFolder("job");
        File jarFileInUsrLibDir = Files.createFile(usrLibDir.toPath().resolve("jar_file_in_job_dir.jar"), new FileAttribute[0]).toFile();
        Path workingDirectory = FileUtils.getCurrentWorkingDirectory();
        Path relativeJarFileInUsrLibDirPath = FileUtils.relativizePath((Path)workingDirectory, (Path)jarFileInUsrLibDir.toPath());
        ArrayList<URL> expectedURLs = new ArrayList<URL>();
        expectedURLs.add(jarFileInJobGraph.toUri().toURL());
        expectedURLs.add(FileUtils.toURL((Path)relativeJarFileInUsrLibDirPath));
        FileJobGraphRetriever fileJobGraphRetriever = FileJobGraphRetriever.createFrom((Configuration)configuration, (File)usrLibDir);
        JobGraph jobGraphFromFile = fileJobGraphRetriever.retrieveJobGraph(configuration);
        Assert.assertThat((Object)jobGraphFromFile.getClasspaths(), (Matcher)Matchers.containsInAnyOrder((Object[])expectedURLs.toArray()));
    }

    @Test
    public void testRetrieveJobGraphWithoutUsrLibDir() throws IOException, FlinkException {
        FileJobGraphRetriever fileJobGraphRetriever = FileJobGraphRetriever.createFrom((Configuration)configuration, null);
        List<URL> expectedUrls = Collections.singletonList(jarFileInJobGraph.toUri().toURL());
        JobGraph jobGraph = fileJobGraphRetriever.retrieveJobGraph(configuration);
        Assert.assertThat((Object)jobGraph.getClasspaths(), (Matcher)Matchers.containsInAnyOrder((Object[])expectedUrls.toArray()));
    }
}

