/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.dispatcher;

import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.dispatcher.Dispatcher;
import org.apache.flink.runtime.dispatcher.DispatcherBootstrapFactory;
import org.apache.flink.runtime.dispatcher.DispatcherId;
import org.apache.flink.runtime.dispatcher.DispatcherServices;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionGraph;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.rpc.RpcService;

class TestingDispatcher
extends Dispatcher {
    private final CompletableFuture<Void> startFuture = new CompletableFuture();

    TestingDispatcher(RpcService rpcService, DispatcherId fencingToken, Collection<JobGraph> recoveredJobs, DispatcherBootstrapFactory dispatcherBootstrapFactory, DispatcherServices dispatcherServices) throws Exception {
        super(rpcService, fencingToken, recoveredJobs, dispatcherBootstrapFactory, dispatcherServices);
    }

    public void onStart() throws Exception {
        try {
            super.onStart();
        }
        catch (Exception e) {
            this.startFuture.completeExceptionally(e);
            throw e;
        }
        this.startFuture.complete(null);
    }

    void completeJobExecution(ArchivedExecutionGraph archivedExecutionGraph) {
        this.runAsync(() -> this.jobReachedGloballyTerminalState(archivedExecutionGraph));
    }

    CompletableFuture<Void> getJobTerminationFuture(@Nonnull JobID jobId, @Nonnull Time timeout) {
        return this.callAsyncWithoutFencing(() -> this.getJobTerminationFuture(jobId), timeout).thenCompose(Function.identity());
    }

    CompletableFuture<Integer> getNumberJobs(Time timeout) {
        return this.callAsyncWithoutFencing(() -> ((Collection)this.listJobs(timeout).get()).size(), timeout);
    }

    void waitUntilStarted() {
        this.startFuture.join();
    }
}

