/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.dispatcher;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.BlobServerOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.blob.BlobServer;
import org.apache.flink.runtime.blob.BlobStore;
import org.apache.flink.runtime.blob.VoidBlobStore;
import org.apache.flink.runtime.clusterframework.ApplicationStatus;
import org.apache.flink.runtime.dispatcher.ArchivedExecutionGraphStore;
import org.apache.flink.runtime.dispatcher.DispatcherGateway;
import org.apache.flink.runtime.dispatcher.DispatcherId;
import org.apache.flink.runtime.dispatcher.DispatcherServices;
import org.apache.flink.runtime.dispatcher.HistoryServerArchivist;
import org.apache.flink.runtime.dispatcher.JobManagerRunnerFactory;
import org.apache.flink.runtime.dispatcher.MemoryArchivedExecutionGraphStore;
import org.apache.flink.runtime.dispatcher.MiniDispatcher;
import org.apache.flink.runtime.dispatcher.NoOpDispatcherBootstrap;
import org.apache.flink.runtime.dispatcher.TestingJobManagerRunnerFactory;
import org.apache.flink.runtime.dispatcher.VoidHistoryServerArchivist;
import org.apache.flink.runtime.entrypoint.ClusterEntrypoint;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionGraph;
import org.apache.flink.runtime.heartbeat.HeartbeatServices;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.highavailability.TestingHighAvailabilityServices;
import org.apache.flink.runtime.highavailability.TestingHighAvailabilityServicesBuilder;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobmanager.JobGraphWriter;
import org.apache.flink.runtime.jobmaster.JobResult;
import org.apache.flink.runtime.jobmaster.TestingJobManagerRunner;
import org.apache.flink.runtime.metrics.groups.UnregisteredMetricGroups;
import org.apache.flink.runtime.resourcemanager.utils.TestingResourceManagerGateway;
import org.apache.flink.runtime.rest.handler.legacy.utils.ArchivedExecutionGraphBuilder;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.rpc.RpcEndpoint;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.rpc.RpcUtils;
import org.apache.flink.runtime.rpc.TestingRpcService;
import org.apache.flink.runtime.util.TestingFatalErrorHandlerResource;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class MiniDispatcherTest
extends TestLogger {
    private static final Time timeout = Time.seconds((long)10L);
    @ClassRule
    public static TemporaryFolder temporaryFolder = new TemporaryFolder();
    @Rule
    public final TestingFatalErrorHandlerResource testingFatalErrorHandlerResource = new TestingFatalErrorHandlerResource();
    private static JobGraph jobGraph;
    private static ArchivedExecutionGraph archivedExecutionGraph;
    private static TestingRpcService rpcService;
    private static Configuration configuration;
    private static BlobServer blobServer;
    private final TestingResourceManagerGateway resourceManagerGateway = new TestingResourceManagerGateway();
    private final HeartbeatServices heartbeatServices = new HeartbeatServices(1000L, 1000L);
    private final ArchivedExecutionGraphStore archivedExecutionGraphStore = new MemoryArchivedExecutionGraphStore();
    private TestingHighAvailabilityServices highAvailabilityServices;
    private TestingJobManagerRunnerFactory testingJobManagerRunnerFactory;

    @BeforeClass
    public static void setupClass() throws IOException {
        jobGraph = new JobGraph(new JobVertex[0]);
        archivedExecutionGraph = new ArchivedExecutionGraphBuilder().setJobID(jobGraph.getJobID()).setState(JobStatus.FINISHED).build();
        rpcService = new TestingRpcService();
        configuration = new Configuration();
        configuration.setString(BlobServerOptions.STORAGE_DIRECTORY, temporaryFolder.newFolder().getAbsolutePath());
        blobServer = new BlobServer(configuration, (BlobStore)new VoidBlobStore());
    }

    @Before
    public void setup() throws Exception {
        this.highAvailabilityServices = new TestingHighAvailabilityServicesBuilder().build();
        this.testingJobManagerRunnerFactory = new TestingJobManagerRunnerFactory();
    }

    @AfterClass
    public static void teardownClass() throws IOException, InterruptedException, ExecutionException, TimeoutException {
        if (blobServer != null) {
            blobServer.close();
        }
        if (rpcService != null) {
            RpcUtils.terminateRpcService((RpcService)rpcService, (Time)timeout);
        }
    }

    @Test
    public void testSingleJobRecovery() throws Exception {
        MiniDispatcher miniDispatcher = this.createMiniDispatcher(ClusterEntrypoint.ExecutionMode.DETACHED);
        miniDispatcher.start();
        try {
            TestingJobManagerRunner testingJobManagerRunner = this.testingJobManagerRunnerFactory.takeCreatedJobManagerRunner();
            Assert.assertThat((Object)testingJobManagerRunner.getJobID(), (Matcher)Matchers.is((Object)jobGraph.getJobID()));
        }
        finally {
            RpcUtils.terminateRpcEndpoint((RpcEndpoint)miniDispatcher, (Time)timeout);
        }
    }

    @Test
    public void testTerminationAfterJobCompletion() throws Exception {
        MiniDispatcher miniDispatcher = this.createMiniDispatcher(ClusterEntrypoint.ExecutionMode.DETACHED);
        miniDispatcher.start();
        try {
            TestingJobManagerRunner testingJobManagerRunner = this.testingJobManagerRunnerFactory.takeCreatedJobManagerRunner();
            testingJobManagerRunner.completeResultFuture(archivedExecutionGraph);
            miniDispatcher.getShutDownFuture().get();
        }
        finally {
            RpcUtils.terminateRpcEndpoint((RpcEndpoint)miniDispatcher, (Time)timeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJobResultRetrieval() throws Exception {
        MiniDispatcher miniDispatcher = this.createMiniDispatcher(ClusterEntrypoint.ExecutionMode.NORMAL);
        miniDispatcher.start();
        try {
            TestingJobManagerRunner testingJobManagerRunner = this.testingJobManagerRunnerFactory.takeCreatedJobManagerRunner();
            testingJobManagerRunner.completeResultFuture(archivedExecutionGraph);
            Assert.assertFalse((boolean)miniDispatcher.getTerminationFuture().isDone());
            DispatcherGateway dispatcherGateway = (DispatcherGateway)miniDispatcher.getSelfGateway(DispatcherGateway.class);
            CompletableFuture jobResultFuture = dispatcherGateway.requestJobResult(jobGraph.getJobID(), timeout);
            JobResult jobResult = (JobResult)jobResultFuture.get();
            Assert.assertThat((Object)jobResult.getJobId(), (Matcher)Matchers.is((Object)jobGraph.getJobID()));
        }
        finally {
            RpcUtils.terminateRpcEndpoint((RpcEndpoint)miniDispatcher, (Time)timeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testShutdownIfJobCancelledInNormalMode() throws Exception {
        MiniDispatcher miniDispatcher = this.createMiniDispatcher(ClusterEntrypoint.ExecutionMode.NORMAL);
        miniDispatcher.start();
        try {
            TestingJobManagerRunner testingJobManagerRunner = this.testingJobManagerRunnerFactory.takeCreatedJobManagerRunner();
            Assert.assertFalse((boolean)miniDispatcher.getTerminationFuture().isDone());
            DispatcherGateway dispatcherGateway = (DispatcherGateway)miniDispatcher.getSelfGateway(DispatcherGateway.class);
            dispatcherGateway.cancelJob(jobGraph.getJobID(), Time.seconds((long)10L));
            testingJobManagerRunner.completeResultFuture(new ArchivedExecutionGraphBuilder().setJobID(jobGraph.getJobID()).setState(JobStatus.CANCELED).build());
            ApplicationStatus applicationStatus = (ApplicationStatus)miniDispatcher.getShutDownFuture().get();
            Assert.assertThat((Object)applicationStatus, (Matcher)Matchers.is((Object)ApplicationStatus.CANCELED));
        }
        finally {
            RpcUtils.terminateRpcEndpoint((RpcEndpoint)miniDispatcher, (Time)timeout);
        }
    }

    @Nonnull
    private MiniDispatcher createMiniDispatcher(ClusterEntrypoint.ExecutionMode executionMode) throws Exception {
        return new MiniDispatcher((RpcService)rpcService, DispatcherId.generate(), new DispatcherServices(configuration, (HighAvailabilityServices)this.highAvailabilityServices, () -> CompletableFuture.completedFuture(this.resourceManagerGateway), blobServer, this.heartbeatServices, this.archivedExecutionGraphStore, (FatalErrorHandler)this.testingFatalErrorHandlerResource.getFatalErrorHandler(), (HistoryServerArchivist)VoidHistoryServerArchivist.INSTANCE, null, UnregisteredMetricGroups.createUnregisteredJobManagerMetricGroup(), (JobGraphWriter)this.highAvailabilityServices.getJobGraphStore(), (JobManagerRunnerFactory)this.testingJobManagerRunnerFactory), jobGraph, (dispatcher, scheduledExecutor, errorHandler) -> new NoOpDispatcherBootstrap(), executionMode);
    }
}

