/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.concurrent;

import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.flink.runtime.concurrent.ScheduledFutureAdapter;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ScheduledFutureAdapterTest
extends TestLogger {
    private ScheduledFutureAdapter<Integer> objectUnderTest;
    private TestFuture innerDelegate;

    @Before
    public void before() {
        this.innerDelegate = new TestFuture();
        this.objectUnderTest = new ScheduledFutureAdapter((Future)this.innerDelegate, 4200000321L, TimeUnit.NANOSECONDS);
    }

    @Test
    public void testForwardedMethods() throws Exception {
        Assert.assertEquals((Object)4711, (Object)this.objectUnderTest.get());
        Assert.assertEquals((long)1L, (long)this.innerDelegate.getGetInvocationCount());
        Assert.assertEquals((Object)4711, (Object)this.objectUnderTest.get(42L, TimeUnit.SECONDS));
        Assert.assertEquals((long)1L, (long)this.innerDelegate.getGetTimeoutInvocationCount());
        Assert.assertEquals((Object)this.innerDelegate.isCancelExpected(), (Object)this.objectUnderTest.cancel(true));
        Assert.assertEquals((long)1L, (long)this.innerDelegate.getCancelInvocationCount());
        this.innerDelegate.setCancelResult(!this.innerDelegate.isCancelExpected());
        Assert.assertEquals((Object)this.innerDelegate.isCancelExpected(), (Object)this.objectUnderTest.cancel(true));
        Assert.assertEquals((long)2L, (long)this.innerDelegate.getCancelInvocationCount());
        Assert.assertEquals((Object)this.innerDelegate.isCancelledExpected(), (Object)this.objectUnderTest.isCancelled());
        Assert.assertEquals((long)1L, (long)this.innerDelegate.getIsCancelledInvocationCount());
        this.innerDelegate.setIsCancelledResult(!this.innerDelegate.isCancelledExpected());
        Assert.assertEquals((Object)this.innerDelegate.isCancelledExpected(), (Object)this.objectUnderTest.isCancelled());
        Assert.assertEquals((long)2L, (long)this.innerDelegate.getIsCancelledInvocationCount());
        Assert.assertEquals((Object)this.innerDelegate.isDoneExpected(), (Object)this.objectUnderTest.isDone());
        Assert.assertEquals((long)1L, (long)this.innerDelegate.getIsDoneInvocationCount());
        this.innerDelegate.setIsDoneExpected(!this.innerDelegate.isDoneExpected());
        Assert.assertEquals((Object)this.innerDelegate.isDoneExpected(), (Object)this.objectUnderTest.isDone());
        Assert.assertEquals((long)2L, (long)this.innerDelegate.getIsDoneInvocationCount());
    }

    @Test
    public void testCompareToEqualsHashCode() {
        Assert.assertEquals((long)0L, (long)this.objectUnderTest.compareTo(this.objectUnderTest));
        Assert.assertEquals(this.objectUnderTest, this.objectUnderTest);
        ScheduledFutureAdapter<Integer> other = this.getDeepCopyWithAdjustedTime(0L, this.objectUnderTest.getTieBreakerUid());
        Assert.assertEquals((long)0L, (long)this.objectUnderTest.compareTo(other));
        Assert.assertEquals((long)0L, (long)other.compareTo(this.objectUnderTest));
        Assert.assertEquals(this.objectUnderTest, other);
        Assert.assertEquals((long)this.objectUnderTest.hashCode(), (long)other.hashCode());
        other = this.getDeepCopyWithAdjustedTime(0L, this.objectUnderTest.getTieBreakerUid() + 1L);
        Assert.assertEquals((long)-1L, (long)Integer.signum(this.objectUnderTest.compareTo(other)));
        Assert.assertEquals((long)1L, (long)Integer.signum(other.compareTo(this.objectUnderTest)));
        Assert.assertNotEquals(this.objectUnderTest, other);
        other = this.getDeepCopyWithAdjustedTime(1L, this.objectUnderTest.getTieBreakerUid());
        Assert.assertEquals((long)-1L, (long)Integer.signum(this.objectUnderTest.compareTo(other)));
        Assert.assertEquals((long)1L, (long)Integer.signum(other.compareTo(this.objectUnderTest)));
        Assert.assertNotEquals(this.objectUnderTest, other);
        other = this.getDeepCopyWithAdjustedTime(-1L, this.objectUnderTest.getTieBreakerUid());
        Assert.assertEquals((long)1L, (long)Integer.signum(this.objectUnderTest.compareTo(other)));
        Assert.assertEquals((long)-1L, (long)Integer.signum(other.compareTo(this.objectUnderTest)));
        Assert.assertNotEquals(this.objectUnderTest, other);
    }

    private ScheduledFutureAdapter<Integer> getDeepCopyWithAdjustedTime(long nanoAdjust, long uid) {
        return new ScheduledFutureAdapter((Future)this.innerDelegate, this.objectUnderTest.getScheduleTimeNanos() + nanoAdjust, uid);
    }

    static class TestFuture
    implements Future<Integer> {
        private boolean cancelExpected = false;
        private boolean isCancelledExpected = false;
        private boolean isDoneExpected = false;
        private int cancelInvocationCount = 0;
        private int isCancelledInvocationCount = 0;
        private int isDoneInvocationCount = 0;
        private int getInvocationCount = 0;
        private int getTimeoutInvocationCount = 0;

        TestFuture() {
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            ++this.cancelInvocationCount;
            return this.cancelExpected;
        }

        @Override
        public boolean isCancelled() {
            ++this.isCancelledInvocationCount;
            return this.isCancelledExpected;
        }

        @Override
        public boolean isDone() {
            ++this.isDoneInvocationCount;
            return this.isDoneExpected;
        }

        @Override
        public Integer get() {
            ++this.getInvocationCount;
            return 4711;
        }

        @Override
        public Integer get(long timeout, @Nonnull TimeUnit unit) {
            ++this.getTimeoutInvocationCount;
            return 4711;
        }

        boolean isCancelExpected() {
            return this.cancelExpected;
        }

        boolean isCancelledExpected() {
            return this.isCancelledExpected;
        }

        boolean isDoneExpected() {
            return this.isDoneExpected;
        }

        void setCancelResult(boolean resultCancel) {
            this.cancelExpected = resultCancel;
        }

        void setIsCancelledResult(boolean resultIsCancelled) {
            this.isCancelledExpected = resultIsCancelled;
        }

        void setIsDoneExpected(boolean resultIsDone) {
            this.isDoneExpected = resultIsDone;
        }

        int getCancelInvocationCount() {
            return this.cancelInvocationCount;
        }

        int getIsCancelledInvocationCount() {
            return this.isCancelledInvocationCount;
        }

        int getIsDoneInvocationCount() {
            return this.isDoneInvocationCount;
        }

        int getGetInvocationCount() {
            return this.getInvocationCount;
        }

        int getGetTimeoutInvocationCount() {
            return this.getTimeoutInvocationCount;
        }
    }
}

