/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.concurrent;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.flink.runtime.concurrent.ScheduledExecutor;
import org.apache.flink.util.Preconditions;

public class ManuallyTriggeredScheduledExecutor
implements ScheduledExecutor {
    private final ArrayDeque<Runnable> queuedRunnables = new ArrayDeque();
    private final ConcurrentLinkedQueue<ScheduledTask<?>> nonPeriodicScheduledTasks = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<ScheduledTask<?>> periodicScheduledTasks = new ConcurrentLinkedQueue();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(@Nonnull Runnable command) {
        ArrayDeque<Runnable> arrayDeque = this.queuedRunnables;
        synchronized (arrayDeque) {
            this.queuedRunnables.addLast(command);
        }
    }

    public void triggerAll() {
        while (this.numQueuedRunnables() > 0) {
            this.trigger();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trigger() {
        Runnable next;
        ArrayDeque<Runnable> arrayDeque = this.queuedRunnables;
        synchronized (arrayDeque) {
            next = this.queuedRunnables.removeFirst();
        }
        next.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int numQueuedRunnables() {
        ArrayDeque<Runnable> arrayDeque = this.queuedRunnables;
        synchronized (arrayDeque) {
            return this.queuedRunnables.size();
        }
    }

    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return this.insertNonPeriodicTask(command, delay, unit);
    }

    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        return this.insertNonPeriodicTask(callable, delay, unit);
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.insertPeriodicRunnable(command, initialDelay, period, unit);
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return this.insertPeriodicRunnable(command, initialDelay, delay, unit);
    }

    public Collection<ScheduledFuture<?>> getScheduledTasks() {
        ArrayList scheduledTasks = new ArrayList(this.nonPeriodicScheduledTasks.size() + this.periodicScheduledTasks.size());
        scheduledTasks.addAll(this.getNonPeriodicScheduledTask());
        scheduledTasks.addAll(this.getPeriodicScheduledTask());
        return scheduledTasks;
    }

    public Collection<ScheduledFuture<?>> getPeriodicScheduledTask() {
        return this.periodicScheduledTasks.stream().filter(scheduledTask -> !scheduledTask.isCancelled()).collect(Collectors.toList());
    }

    public Collection<ScheduledFuture<?>> getNonPeriodicScheduledTask() {
        return this.nonPeriodicScheduledTasks.stream().filter(scheduledTask -> !scheduledTask.isCancelled()).collect(Collectors.toList());
    }

    public void triggerScheduledTasks() {
        this.triggerPeriodicScheduledTasks();
        this.triggerNonPeriodicScheduledTasks();
    }

    public void triggerNonPeriodicScheduledTask() {
        ScheduledTask poll = (ScheduledTask)this.nonPeriodicScheduledTasks.remove();
        if (poll != null) {
            poll.execute();
        }
    }

    public void triggerNonPeriodicScheduledTasks() {
        Iterator<ScheduledTask<?>> iterator = this.nonPeriodicScheduledTasks.iterator();
        while (iterator.hasNext()) {
            ScheduledTask<?> scheduledTask = iterator.next();
            if (!scheduledTask.isCancelled()) {
                scheduledTask.execute();
            }
            iterator.remove();
        }
    }

    public void triggerPeriodicScheduledTasks() {
        for (ScheduledTask<?> scheduledTask : this.periodicScheduledTasks) {
            if (scheduledTask.isCancelled()) continue;
            scheduledTask.execute();
        }
    }

    private ScheduledFuture<?> insertPeriodicRunnable(Runnable command, long delay, long period, TimeUnit unit) {
        ScheduledTask scheduledTask = new ScheduledTask(() -> {
            command.run();
            return null;
        }, unit.convert(delay, TimeUnit.MILLISECONDS), unit.convert(period, TimeUnit.MILLISECONDS));
        this.periodicScheduledTasks.offer(scheduledTask);
        return scheduledTask;
    }

    private ScheduledFuture<?> insertNonPeriodicTask(Runnable command, long delay, TimeUnit unit) {
        return this.insertNonPeriodicTask(() -> {
            command.run();
            return null;
        }, delay, unit);
    }

    private <V> ScheduledFuture<V> insertNonPeriodicTask(Callable<V> callable, long delay, TimeUnit unit) {
        ScheduledTask scheduledTask = new ScheduledTask(callable, unit.convert(delay, TimeUnit.MILLISECONDS));
        this.nonPeriodicScheduledTasks.offer(scheduledTask);
        return scheduledTask;
    }

    private static final class ScheduledTask<T>
    implements ScheduledFuture<T> {
        private final Callable<T> callable;
        private final long delay;
        private final long period;
        private final CompletableFuture<T> result;

        private ScheduledTask(Callable<T> callable, long delay) {
            this(callable, delay, 0L);
        }

        private ScheduledTask(Callable<T> callable, long delay, long period) {
            this.callable = (Callable)Preconditions.checkNotNull(callable);
            this.result = new CompletableFuture();
            this.delay = delay;
            this.period = period;
        }

        private boolean isPeriodic() {
            return this.period > 0L;
        }

        public void execute() {
            if (!this.result.isDone()) {
                if (!this.isPeriodic()) {
                    try {
                        this.result.complete(this.callable.call());
                    }
                    catch (Exception e) {
                        this.result.completeExceptionally(e);
                    }
                } else {
                    try {
                        this.callable.call();
                    }
                    catch (Exception e) {
                        this.result.completeExceptionally(e);
                    }
                }
            }
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return unit.convert(this.delay, TimeUnit.MILLISECONDS);
        }

        @Override
        public int compareTo(Delayed o) {
            return Long.compare(this.getDelay(TimeUnit.MILLISECONDS), o.getDelay(TimeUnit.MILLISECONDS));
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.result.cancel(mayInterruptIfRunning);
        }

        @Override
        public boolean isCancelled() {
            return this.result.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.result.isDone();
        }

        @Override
        public T get() throws InterruptedException, ExecutionException {
            return this.result.get();
        }

        @Override
        public T get(long timeout, @Nonnull TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.result.get(timeout, unit);
        }
    }
}

