/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.clusterframework;

import java.util.Map;
import java.util.function.Consumer;
import org.apache.flink.api.common.resources.CPUResource;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ConfigurationUtils;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.NettyShuffleEnvironmentOptions;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.runtime.clusterframework.TaskExecutorProcessSpec;
import org.apache.flink.runtime.clusterframework.TaskExecutorProcessUtils;
import org.apache.flink.runtime.resourcemanager.WorkerResourceSpec;
import org.apache.flink.runtime.util.config.memory.ProcessMemoryUtilsTestBase;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class TaskExecutorProcessUtilsTest
extends ProcessMemoryUtilsTestBase<TaskExecutorProcessSpec> {
    private static final MemorySize TASK_HEAP_SIZE = MemorySize.parse((String)"100m");
    private static final MemorySize MANAGED_MEM_SIZE = MemorySize.parse((String)"200m");
    private static final MemorySize TOTAL_FLINK_MEM_SIZE = MemorySize.parse((String)"1280m");
    private static final MemorySize TOTAL_PROCESS_MEM_SIZE = MemorySize.parse((String)"1536m");
    private static final TaskExecutorProcessSpec TM_RESOURCE_SPEC = new TaskExecutorProcessSpec(new CPUResource(1.0), MemorySize.parse((String)"1m"), MemorySize.parse((String)"2m"), MemorySize.parse((String)"3m"), MemorySize.parse((String)"4m"), MemorySize.parse((String)"5m"), MemorySize.parse((String)"6m"), MemorySize.parse((String)"7m"), MemorySize.parse((String)"8m"));

    public TaskExecutorProcessUtilsTest() {
        super(TaskExecutorProcessUtils.TM_PROCESS_MEMORY_OPTIONS, TaskExecutorProcessUtils.TM_LEGACY_HEAP_OPTIONS, (ConfigOption<MemorySize>)TaskManagerOptions.TOTAL_PROCESS_MEMORY);
    }

    @Test
    public void testGenerateDynamicConfigurations() {
        String dynamicConfigsStr = TaskExecutorProcessUtils.generateDynamicConfigsStr((TaskExecutorProcessSpec)TM_RESOURCE_SPEC);
        Map configs = ConfigurationUtils.parseTmResourceDynamicConfigs((String)dynamicConfigsStr);
        Assert.assertThat((Object)new CPUResource(Double.valueOf((String)configs.get(TaskManagerOptions.CPU_CORES.key())).doubleValue()), (Matcher)Matchers.is((Object)TM_RESOURCE_SPEC.getCpuCores()));
        Assert.assertThat((Object)MemorySize.parse((String)((String)configs.get(TaskManagerOptions.FRAMEWORK_HEAP_MEMORY.key()))), (Matcher)Matchers.is((Object)TM_RESOURCE_SPEC.getFrameworkHeapSize()));
        Assert.assertThat((Object)MemorySize.parse((String)((String)configs.get(TaskManagerOptions.FRAMEWORK_OFF_HEAP_MEMORY.key()))), (Matcher)Matchers.is((Object)TM_RESOURCE_SPEC.getFrameworkOffHeapMemorySize()));
        Assert.assertThat((Object)MemorySize.parse((String)((String)configs.get(TaskManagerOptions.TASK_HEAP_MEMORY.key()))), (Matcher)Matchers.is((Object)TM_RESOURCE_SPEC.getTaskHeapSize()));
        Assert.assertThat((Object)MemorySize.parse((String)((String)configs.get(TaskManagerOptions.TASK_OFF_HEAP_MEMORY.key()))), (Matcher)Matchers.is((Object)TM_RESOURCE_SPEC.getTaskOffHeapSize()));
        Assert.assertThat((Object)MemorySize.parse((String)((String)configs.get(TaskManagerOptions.NETWORK_MEMORY_MAX.key()))), (Matcher)Matchers.is((Object)TM_RESOURCE_SPEC.getNetworkMemSize()));
        Assert.assertThat((Object)MemorySize.parse((String)((String)configs.get(TaskManagerOptions.NETWORK_MEMORY_MIN.key()))), (Matcher)Matchers.is((Object)TM_RESOURCE_SPEC.getNetworkMemSize()));
        Assert.assertThat((Object)MemorySize.parse((String)((String)configs.get(TaskManagerOptions.MANAGED_MEMORY_SIZE.key()))), (Matcher)Matchers.is((Object)TM_RESOURCE_SPEC.getManagedMemorySize()));
    }

    @Test
    public void testProcessSpecFromWorkerResourceSpec() {
        WorkerResourceSpec workerResourceSpec = new WorkerResourceSpec.Builder().setCpuCores(1.0).setTaskHeapMemoryMB(100).setTaskOffHeapMemoryMB(200).setNetworkMemoryMB(300).setManagedMemoryMB(400).build();
        TaskExecutorProcessSpec taskExecutorProcessSpec = TaskExecutorProcessUtils.processSpecFromWorkerResourceSpec((Configuration)new Configuration(), (WorkerResourceSpec)workerResourceSpec);
        Assert.assertEquals((Object)workerResourceSpec.getCpuCores(), (Object)taskExecutorProcessSpec.getCpuCores());
        Assert.assertEquals((Object)workerResourceSpec.getTaskHeapSize(), (Object)taskExecutorProcessSpec.getTaskHeapSize());
        Assert.assertEquals((Object)workerResourceSpec.getTaskOffHeapSize(), (Object)taskExecutorProcessSpec.getTaskOffHeapSize());
        Assert.assertEquals((Object)workerResourceSpec.getNetworkMemSize(), (Object)taskExecutorProcessSpec.getNetworkMemSize());
        Assert.assertEquals((Object)workerResourceSpec.getManagedMemSize(), (Object)taskExecutorProcessSpec.getManagedMemorySize());
    }

    @Test
    public void testConfigCpuCores() {
        double cpuCores = 1.0;
        Configuration conf = new Configuration();
        conf.setDouble(TaskManagerOptions.CPU_CORES, 1.0);
        this.validateInAllConfigurations(conf, (TaskExecutorProcessSpec taskExecutorProcessSpec) -> Assert.assertThat((Object)taskExecutorProcessSpec.getCpuCores(), (Matcher)Matchers.is((Object)new CPUResource(1.0))));
    }

    @Test
    public void testConfigNoCpuCores() {
        Configuration conf = new Configuration();
        conf.setInteger(TaskManagerOptions.NUM_TASK_SLOTS, 3);
        this.validateInAllConfigurations(conf, (TaskExecutorProcessSpec taskExecutorProcessSpec) -> Assert.assertThat((Object)taskExecutorProcessSpec.getCpuCores(), (Matcher)Matchers.is((Object)new CPUResource(3.0))));
    }

    @Test
    public void testConfigNegativeCpuCores() {
        Configuration conf = new Configuration();
        conf.setDouble(TaskManagerOptions.CPU_CORES, (double)-0.1f);
        this.validateFailInAllConfigurations(conf);
    }

    @Test
    public void testConfigFrameworkHeapMemory() {
        MemorySize frameworkHeapSize = MemorySize.parse((String)"100m");
        Configuration conf = new Configuration();
        conf.set(TaskManagerOptions.FRAMEWORK_HEAP_MEMORY, (Object)frameworkHeapSize);
        this.validateInAllConfigurations(conf, (TaskExecutorProcessSpec taskExecutorProcessSpec) -> Assert.assertThat((Object)taskExecutorProcessSpec.getFrameworkHeapSize(), (Matcher)Matchers.is((Object)frameworkHeapSize)));
    }

    @Test
    public void testConfigFrameworkOffHeapMemory() {
        MemorySize frameworkOffHeapSize = MemorySize.parse((String)"10m");
        Configuration conf = new Configuration();
        conf.set(TaskManagerOptions.FRAMEWORK_OFF_HEAP_MEMORY, (Object)frameworkOffHeapSize);
        this.validateInAllConfigurations(conf, (TaskExecutorProcessSpec taskExecutorProcessSpec) -> Assert.assertThat((Object)taskExecutorProcessSpec.getFrameworkOffHeapMemorySize(), (Matcher)Matchers.is((Object)frameworkOffHeapSize)));
    }

    @Test
    public void testConfigTaskHeapMemory() {
        MemorySize taskHeapSize = MemorySize.parse((String)"50m");
        Configuration conf = new Configuration();
        conf.set(TaskManagerOptions.TASK_HEAP_MEMORY, (Object)taskHeapSize);
        this.validateInConfigurationsWithoutExplicitTaskHeapMem(conf, taskExecutorProcessSpec -> Assert.assertThat((Object)taskExecutorProcessSpec.getTaskHeapSize(), (Matcher)Matchers.is((Object)taskHeapSize)));
    }

    @Test
    public void testConfigTaskOffheapMemory() {
        MemorySize taskOffHeapSize = MemorySize.parse((String)"50m");
        Configuration conf = new Configuration();
        conf.set(TaskManagerOptions.TASK_OFF_HEAP_MEMORY, (Object)taskOffHeapSize);
        this.validateInAllConfigurations(conf, (TaskExecutorProcessSpec taskExecutorProcessSpec) -> Assert.assertThat((Object)taskExecutorProcessSpec.getTaskOffHeapSize(), (Matcher)Matchers.is((Object)taskOffHeapSize)));
    }

    @Test
    public void testConfigNetworkMemoryRange() {
        MemorySize networkMin = MemorySize.parse((String)"200m");
        MemorySize networkMax = MemorySize.parse((String)"500m");
        Configuration conf = new Configuration();
        conf.set(TaskManagerOptions.NETWORK_MEMORY_MAX, (Object)networkMax);
        conf.set(TaskManagerOptions.NETWORK_MEMORY_MIN, (Object)networkMin);
        this.validateInAllConfigurations(conf, (TaskExecutorProcessSpec taskExecutorProcessSpec) -> {
            Assert.assertThat((Object)taskExecutorProcessSpec.getNetworkMemSize().getBytes(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(networkMin.getBytes())));
            Assert.assertThat((Object)taskExecutorProcessSpec.getNetworkMemSize().getBytes(), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(networkMax.getBytes())));
        });
    }

    @Test
    public void testConsistencyCheckOfDerivedNetworkMemoryWithinMinMaxRangeNotMatchingFractionPasses() {
        Configuration configuration = TaskExecutorProcessUtilsTest.setupConfigWithFlinkAndTaskHeapToDeriveGivenNetworkMem(400);
        configuration.setFloat(TaskManagerOptions.NETWORK_MEMORY_FRACTION, 0.001f);
        TaskExecutorProcessUtils.processSpecFromConfig((Configuration)configuration);
    }

    @Test(expected=IllegalConfigurationException.class)
    public void testConsistencyCheckOfDerivedNetworkMemoryLessThanMinFails() {
        Configuration configuration = TaskExecutorProcessUtilsTest.setupConfigWithFlinkAndTaskHeapToDeriveGivenNetworkMem(500);
        configuration.set(TaskManagerOptions.NETWORK_MEMORY_MIN, (Object)MemorySize.parse((String)"900m"));
        configuration.set(TaskManagerOptions.NETWORK_MEMORY_MAX, (Object)MemorySize.parse((String)"1000m"));
        TaskExecutorProcessUtils.processSpecFromConfig((Configuration)configuration);
    }

    @Test(expected=IllegalConfigurationException.class)
    public void testConsistencyCheckOfDerivedNetworkMemoryGreaterThanMaxFails() {
        Configuration configuration = TaskExecutorProcessUtilsTest.setupConfigWithFlinkAndTaskHeapToDeriveGivenNetworkMem(500);
        configuration.set(TaskManagerOptions.NETWORK_MEMORY_MIN, (Object)MemorySize.parse((String)"100m"));
        configuration.set(TaskManagerOptions.NETWORK_MEMORY_MAX, (Object)MemorySize.parse((String)"150m"));
        TaskExecutorProcessUtils.processSpecFromConfig((Configuration)configuration);
    }

    @Test(expected=IllegalConfigurationException.class)
    public void testConsistencyCheckOfDerivedNetworkMemoryDoesNotMatchLegacyConfigFails() {
        int numberOfNetworkBuffers = 10;
        int pageSizeMb = 16;
        int networkMemorySizeMbToDerive = 176;
        Configuration configuration = TaskExecutorProcessUtilsTest.setupConfigWithFlinkAndTaskHeapToDeriveGivenNetworkMem(176);
        configuration.set(TaskManagerOptions.MEMORY_SEGMENT_SIZE, (Object)MemorySize.ofMebiBytes((long)16L));
        configuration.setInteger(NettyShuffleEnvironmentOptions.NETWORK_NUM_BUFFERS, 10);
        TaskExecutorProcessUtils.processSpecFromConfig((Configuration)configuration);
    }

    private static Configuration setupConfigWithFlinkAndTaskHeapToDeriveGivenNetworkMem(int networkMemorySizeToDeriveMb) {
        Configuration conf = new Configuration();
        conf.set(TaskManagerOptions.TOTAL_FLINK_MEMORY, (Object)TOTAL_FLINK_MEM_SIZE);
        conf.set(TaskManagerOptions.TASK_HEAP_MEMORY, (Object)TASK_HEAP_SIZE);
        conf.set(TaskManagerOptions.MANAGED_MEMORY_SIZE, (Object)MANAGED_MEM_SIZE);
        TaskExecutorProcessSpec taskExecutorProcessSpec = TaskExecutorProcessUtils.processSpecFromConfig((Configuration)conf);
        int derivedNetworkMemorySizeMb = taskExecutorProcessSpec.getNetworkMemSize().getMebiBytes();
        if (derivedNetworkMemorySizeMb < networkMemorySizeToDeriveMb) {
            int adjustedTotalFlinkMemoryMb = taskExecutorProcessSpec.getTotalFlinkMemorySize().getMebiBytes() - derivedNetworkMemorySizeMb + networkMemorySizeToDeriveMb;
            conf.set(TaskManagerOptions.TOTAL_FLINK_MEMORY, (Object)MemorySize.ofMebiBytes((long)adjustedTotalFlinkMemoryMb));
        } else if (derivedNetworkMemorySizeMb > networkMemorySizeToDeriveMb) {
            int adjustedTaskHeapMemoryMb = taskExecutorProcessSpec.getTaskHeapSize().getMebiBytes() + derivedNetworkMemorySizeMb - networkMemorySizeToDeriveMb;
            conf.set(TaskManagerOptions.TASK_HEAP_MEMORY, (Object)MemorySize.ofMebiBytes((long)adjustedTaskHeapMemoryMb));
        }
        TaskExecutorProcessSpec adjusteedTaskExecutorProcessSpec = TaskExecutorProcessUtils.processSpecFromConfig((Configuration)conf);
        Assert.assertThat((Object)adjusteedTaskExecutorProcessSpec.getNetworkMemSize().getMebiBytes(), (Matcher)Matchers.is((Object)networkMemorySizeToDeriveMb));
        return conf;
    }

    @Test
    public void testConfigNetworkMemoryRangeFailure() {
        MemorySize networkMin = MemorySize.parse((String)"200m");
        MemorySize networkMax = MemorySize.parse((String)"50m");
        Configuration conf = new Configuration();
        conf.set(TaskManagerOptions.NETWORK_MEMORY_MAX, (Object)networkMax);
        conf.set(TaskManagerOptions.NETWORK_MEMORY_MIN, (Object)networkMin);
        this.validateFailInAllConfigurations(conf);
    }

    @Test
    public void testConfigNetworkMemoryFraction() {
        MemorySize networkMin = MemorySize.ZERO;
        MemorySize networkMax = MemorySize.parse((String)"1t");
        float fraction = 0.2f;
        Configuration conf = new Configuration();
        conf.set(TaskManagerOptions.NETWORK_MEMORY_MAX, (Object)networkMax);
        conf.set(TaskManagerOptions.NETWORK_MEMORY_MIN, (Object)networkMin);
        conf.setFloat(TaskManagerOptions.NETWORK_MEMORY_FRACTION, 0.2f);
        this.validateInConfigWithExplicitTaskHeapAndManagedMem(conf, taskExecutorProcessSpec -> Assert.assertThat((Object)taskExecutorProcessSpec.getNetworkMemSize(), (Matcher)Matchers.is((Object)taskExecutorProcessSpec.getTotalFlinkMemorySize().multiply((double)0.2f))));
    }

    @Test
    public void testConfigNetworkMemoryFractionFailure() {
        Configuration conf = new Configuration();
        conf.setFloat(TaskManagerOptions.NETWORK_MEMORY_FRACTION, -0.1f);
        this.validateFailInAllConfigurations(conf);
        conf.setFloat(TaskManagerOptions.NETWORK_MEMORY_FRACTION, 1.0f);
        this.validateFailInAllConfigurations(conf);
    }

    @Test
    public void testConfigNetworkMemoryLegacyRangeFraction() {
        MemorySize networkMin = MemorySize.parse((String)"200m");
        MemorySize networkMax = MemorySize.parse((String)"500m");
        float fraction = 0.2f;
        ConfigOption legacyOptionMin = NettyShuffleEnvironmentOptions.NETWORK_BUFFERS_MEMORY_MIN;
        ConfigOption legacyOptionMax = NettyShuffleEnvironmentOptions.NETWORK_BUFFERS_MEMORY_MAX;
        ConfigOption legacyOptionFraction = NettyShuffleEnvironmentOptions.NETWORK_BUFFERS_MEMORY_FRACTION;
        Configuration conf = new Configuration();
        conf.setString(legacyOptionMin, networkMin.getMebiBytes() + "m");
        conf.setString(legacyOptionMax, networkMax.getMebiBytes() + "m");
        this.validateInAllConfigurations(conf, (TaskExecutorProcessSpec taskExecutorProcessSpec) -> {
            Assert.assertThat((Object)taskExecutorProcessSpec.getNetworkMemSize().getBytes(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(networkMin.getBytes())));
            Assert.assertThat((Object)taskExecutorProcessSpec.getNetworkMemSize().getBytes(), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(networkMax.getBytes())));
        });
        conf.setString(legacyOptionMin, "0m");
        conf.setString(legacyOptionMax, "1t");
        conf.setFloat(legacyOptionFraction, 0.2f);
        this.validateInConfigWithExplicitTaskHeapAndManagedMem(conf, taskExecutorProcessSpec -> Assert.assertThat((Object)taskExecutorProcessSpec.getNetworkMemSize(), (Matcher)Matchers.is((Object)taskExecutorProcessSpec.getTotalFlinkMemorySize().multiply((double)0.2f))));
    }

    @Test
    public void testConfigNetworkMemoryLegacyNumOfBuffers() {
        MemorySize pageSize = MemorySize.parse((String)"32k");
        int numOfBuffers = 1024;
        MemorySize networkSize = pageSize.multiply(1024.0);
        ConfigOption legacyOption = NettyShuffleEnvironmentOptions.NETWORK_NUM_BUFFERS;
        Configuration conf = new Configuration();
        conf.set(TaskManagerOptions.MEMORY_SEGMENT_SIZE, (Object)pageSize);
        conf.setInteger(legacyOption, 1024);
        this.validateInConfigWithExplicitTaskHeapAndManagedMem(conf, taskExecutorProcessSpec -> Assert.assertThat((Object)taskExecutorProcessSpec.getNetworkMemSize(), (Matcher)Matchers.is((Object)networkSize)));
        this.validateInConfigurationsWithoutExplicitTaskHeapMem(conf, taskExecutorProcessSpec -> Assert.assertThat((Object)taskExecutorProcessSpec.getNetworkMemSize(), (Matcher)Matchers.is((Object)networkSize)));
    }

    @Test
    public void testConfigManagedMemorySize() {
        MemorySize managedMemSize = MemorySize.parse((String)"100m");
        Configuration conf = new Configuration();
        conf.set(TaskManagerOptions.MANAGED_MEMORY_SIZE, (Object)managedMemSize);
        this.validateInConfigurationsWithoutExplicitManagedMem(conf, taskExecutorProcessSpec -> Assert.assertThat((Object)taskExecutorProcessSpec.getManagedMemorySize(), (Matcher)Matchers.is((Object)managedMemSize)));
    }

    @Test
    public void testConfigManagedMemoryLegacySize() {
        MemorySize managedMemSize = MemorySize.parse((String)"100m");
        ConfigOption legacyOption = TaskManagerOptions.MANAGED_MEMORY_SIZE;
        Configuration conf = new Configuration();
        conf.set(legacyOption, (Object)managedMemSize);
        this.validateInConfigurationsWithoutExplicitManagedMem(conf, taskExecutorProcessSpec -> Assert.assertThat((Object)taskExecutorProcessSpec.getManagedMemorySize(), (Matcher)Matchers.is((Object)managedMemSize)));
    }

    @Test
    public void testConfigManagedMemoryFraction() {
        float fraction = 0.5f;
        Configuration conf = new Configuration();
        conf.setFloat(TaskManagerOptions.MANAGED_MEMORY_FRACTION, 0.5f);
        this.validateInConfigurationsWithoutExplicitManagedMem(conf, taskExecutorProcessSpec -> Assert.assertThat((Object)taskExecutorProcessSpec.getManagedMemorySize(), (Matcher)Matchers.is((Object)taskExecutorProcessSpec.getTotalFlinkMemorySize().multiply(0.5))));
    }

    @Test
    public void testConfigManagedMemoryFractionFailure() {
        Configuration conf = new Configuration();
        conf.setFloat(TaskManagerOptions.MANAGED_MEMORY_FRACTION, -0.1f);
        this.validateFailInConfigurationsWithoutExplicitManagedMem(conf);
        conf.setFloat(TaskManagerOptions.MANAGED_MEMORY_FRACTION, 1.0f);
        this.validateFailInConfigurationsWithoutExplicitManagedMem(conf);
    }

    @Test
    public void testFlinkInternalMemorySizeAddUpFailure() {
        MemorySize totalFlinkMemory = MemorySize.parse((String)"499m");
        MemorySize frameworkHeap = MemorySize.parse((String)"100m");
        MemorySize taskHeap = MemorySize.parse((String)"100m");
        MemorySize taskOffHeap = MemorySize.parse((String)"100m");
        MemorySize network = MemorySize.parse((String)"100m");
        MemorySize managed = MemorySize.parse((String)"100m");
        Configuration conf = new Configuration();
        conf.set(TaskManagerOptions.TOTAL_FLINK_MEMORY, (Object)totalFlinkMemory);
        conf.set(TaskManagerOptions.FRAMEWORK_HEAP_MEMORY, (Object)frameworkHeap);
        conf.set(TaskManagerOptions.TASK_HEAP_MEMORY, (Object)taskHeap);
        conf.set(TaskManagerOptions.TASK_OFF_HEAP_MEMORY, (Object)taskOffHeap);
        conf.set(TaskManagerOptions.NETWORK_MEMORY_MIN, (Object)network);
        conf.set(TaskManagerOptions.NETWORK_MEMORY_MAX, (Object)network);
        conf.set(TaskManagerOptions.MANAGED_MEMORY_SIZE, (Object)managed);
        this.validateFail(conf);
    }

    @Test
    public void testFlinkInternalMemoryFractionAddUpFailure() {
        float networkFraction = 0.6f;
        float managedFraction = 0.6f;
        Configuration conf = new Configuration();
        conf.setFloat(TaskManagerOptions.NETWORK_MEMORY_FRACTION, 0.6f);
        conf.setFloat(TaskManagerOptions.MANAGED_MEMORY_FRACTION, 0.6f);
        this.validateFailInConfigWithExplicitTotalFlinkMem(conf);
        this.validateFailInConfigWithExplicitTotalProcessMem(conf);
    }

    @Test
    public void testConfigTotalProcessMemoryLegacySize() {
        MemorySize totalProcessMemorySize = MemorySize.parse((String)"2g");
        ConfigOption legacyOption = TaskManagerOptions.TOTAL_PROCESS_MEMORY;
        Configuration conf = new Configuration();
        conf.set(legacyOption, (Object)totalProcessMemorySize);
        TaskExecutorProcessSpec taskExecutorProcessSpec = TaskExecutorProcessUtils.processSpecFromConfig((Configuration)conf);
        Assert.assertThat((Object)taskExecutorProcessSpec.getTotalProcessMemorySize(), (Matcher)Matchers.is((Object)totalProcessMemorySize));
    }

    @Override
    @Test
    public void testExceptionShouldContainRequiredConfigOptions() {
        try {
            TaskExecutorProcessUtils.processSpecFromConfig((Configuration)new Configuration());
        }
        catch (IllegalConfigurationException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)TaskManagerOptions.TASK_HEAP_MEMORY.key()));
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)TaskManagerOptions.MANAGED_MEMORY_SIZE.key()));
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)TaskManagerOptions.TOTAL_FLINK_MEMORY.key()));
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)TaskManagerOptions.TOTAL_PROCESS_MEMORY.key()));
        }
    }

    @Override
    protected void validateInAllConfigurations(Configuration customConfig, Consumer<TaskExecutorProcessSpec> validateFunc) {
        this.validateInConfigWithExplicitTaskHeapAndManagedMem(customConfig, validateFunc);
        this.validateInConfigWithExplicitTotalFlinkMem(customConfig, validateFunc);
        this.validateInConfigWithExplicitTotalFlinkAndTaskHeapMem(customConfig, validateFunc);
        this.validateInConfigWithExplicitTotalFlinkAndManagedMem(customConfig, validateFunc);
        this.validateInConfigWithExplicitTotalProcessMem(customConfig, validateFunc);
    }

    @Override
    protected void validateFailInAllConfigurations(Configuration customConfig) {
        this.validateFailInConfigWithExplicitTaskHeapAndManagedMem(customConfig);
        this.validateFailInConfigWithExplicitTotalFlinkMem(customConfig);
        this.validateFailInConfigWithExplicitTotalFlinkAndTaskHeapMem(customConfig);
        this.validateFailInConfigWithExplicitTotalFlinkAndManagedMem(customConfig);
        this.validateFailInConfigWithExplicitTotalProcessMem(customConfig);
    }

    private void validateInConfigurationsWithoutExplicitTaskHeapMem(Configuration customConfig, Consumer<TaskExecutorProcessSpec> validateFunc) {
        this.validateInConfigWithExplicitTotalFlinkMem(customConfig, validateFunc);
        this.validateInConfigWithExplicitTotalFlinkAndManagedMem(customConfig, validateFunc);
        this.validateInConfigWithExplicitTotalProcessMem(customConfig, validateFunc);
    }

    private void validateInConfigurationsWithoutExplicitManagedMem(Configuration customConfig, Consumer<TaskExecutorProcessSpec> validateFunc) {
        this.validateInConfigWithExplicitTotalFlinkMem(customConfig, validateFunc);
        this.validateInConfigWithExplicitTotalFlinkAndTaskHeapMem(customConfig, validateFunc);
        this.validateInConfigWithExplicitTotalProcessMem(customConfig, validateFunc);
    }

    private void validateFailInConfigurationsWithoutExplicitManagedMem(Configuration customConfig) {
        this.validateFailInConfigWithExplicitTotalFlinkMem(customConfig);
        this.validateFailInConfigWithExplicitTotalFlinkAndTaskHeapMem(customConfig);
        this.validateFailInConfigWithExplicitTotalProcessMem(customConfig);
    }

    private void validateInConfigWithExplicitTaskHeapAndManagedMem(Configuration customConfig, Consumer<TaskExecutorProcessSpec> validateFunc) {
        this.log.info("Validating in configuration with explicit task heap and managed memory size.");
        Configuration config = TaskExecutorProcessUtilsTest.configWithExplicitTaskHeapAndManageMem();
        config.addAll(customConfig);
        TaskExecutorProcessSpec taskExecutorProcessSpec = TaskExecutorProcessUtils.processSpecFromConfig((Configuration)config);
        Assert.assertThat((Object)taskExecutorProcessSpec.getTaskHeapSize(), (Matcher)Matchers.is((Object)TASK_HEAP_SIZE));
        Assert.assertThat((Object)taskExecutorProcessSpec.getManagedMemorySize(), (Matcher)Matchers.is((Object)MANAGED_MEM_SIZE));
        validateFunc.accept(taskExecutorProcessSpec);
    }

    private void validateFailInConfigWithExplicitTaskHeapAndManagedMem(Configuration customConfig) {
        this.log.info("Validating failing in configuration with explicit task heap and managed memory size.");
        Configuration config = TaskExecutorProcessUtilsTest.configWithExplicitTaskHeapAndManageMem();
        config.addAll(customConfig);
        this.validateFail(config);
    }

    private void validateInConfigWithExplicitTotalFlinkMem(Configuration customConfig, Consumer<TaskExecutorProcessSpec> validateFunc) {
        this.log.info("Validating in configuration with explicit total flink memory size.");
        Configuration config = TaskExecutorProcessUtilsTest.configWithExplicitTotalFlinkMem();
        config.addAll(customConfig);
        TaskExecutorProcessSpec taskExecutorProcessSpec = TaskExecutorProcessUtils.processSpecFromConfig((Configuration)config);
        Assert.assertThat((Object)taskExecutorProcessSpec.getTotalFlinkMemorySize(), (Matcher)Matchers.is((Object)TOTAL_FLINK_MEM_SIZE));
        validateFunc.accept(taskExecutorProcessSpec);
    }

    private void validateFailInConfigWithExplicitTotalFlinkMem(Configuration customConfig) {
        this.log.info("Validating failing in configuration with explicit total flink memory size.");
        Configuration config = TaskExecutorProcessUtilsTest.configWithExplicitTotalFlinkMem();
        config.addAll(customConfig);
        this.validateFail(config);
    }

    private void validateInConfigWithExplicitTotalFlinkAndTaskHeapMem(Configuration customConfig, Consumer<TaskExecutorProcessSpec> validateFunc) {
        this.log.info("Validating in configuration with explicit total flink and task heap memory size.");
        Configuration config = TaskExecutorProcessUtilsTest.configWithExplicitTotalFlinkAndTaskHeapMem();
        config.addAll(customConfig);
        TaskExecutorProcessSpec taskExecutorProcessSpec = TaskExecutorProcessUtils.processSpecFromConfig((Configuration)config);
        Assert.assertThat((Object)taskExecutorProcessSpec.getTotalFlinkMemorySize(), (Matcher)Matchers.is((Object)TOTAL_FLINK_MEM_SIZE));
        Assert.assertThat((Object)taskExecutorProcessSpec.getTaskHeapSize(), (Matcher)Matchers.is((Object)TASK_HEAP_SIZE));
        validateFunc.accept(taskExecutorProcessSpec);
    }

    private void validateFailInConfigWithExplicitTotalFlinkAndTaskHeapMem(Configuration customConfig) {
        this.log.info("Validating failing in configuration with explicit total flink and task heap memory size.");
        Configuration config = TaskExecutorProcessUtilsTest.configWithExplicitTotalFlinkAndTaskHeapMem();
        config.addAll(customConfig);
        this.validateFail(config);
    }

    private void validateInConfigWithExplicitTotalFlinkAndManagedMem(Configuration customConfig, Consumer<TaskExecutorProcessSpec> validateFunc) {
        this.log.info("Validating in configuration with explicit total flink and managed memory size.");
        Configuration config = TaskExecutorProcessUtilsTest.configWithExplicitTotalFlinkAndManagedMem();
        config.addAll(customConfig);
        TaskExecutorProcessSpec taskExecutorProcessSpec = TaskExecutorProcessUtils.processSpecFromConfig((Configuration)config);
        Assert.assertThat((Object)taskExecutorProcessSpec.getTotalFlinkMemorySize(), (Matcher)Matchers.is((Object)TOTAL_FLINK_MEM_SIZE));
        Assert.assertThat((Object)taskExecutorProcessSpec.getManagedMemorySize(), (Matcher)Matchers.is((Object)MANAGED_MEM_SIZE));
        validateFunc.accept(taskExecutorProcessSpec);
    }

    private void validateFailInConfigWithExplicitTotalFlinkAndManagedMem(Configuration customConfig) {
        this.log.info("Validating failing in configuration with explicit total flink and managed memory size.");
        Configuration config = TaskExecutorProcessUtilsTest.configWithExplicitTotalFlinkAndManagedMem();
        config.addAll(customConfig);
        this.validateFail(config);
    }

    private void validateInConfigWithExplicitTotalProcessMem(Configuration customConfig, Consumer<TaskExecutorProcessSpec> validateFunc) {
        this.log.info("Validating in configuration with explicit total process memory size.");
        Configuration config = TaskExecutorProcessUtilsTest.configWithExplicitTotalProcessMem();
        config.addAll(customConfig);
        TaskExecutorProcessSpec taskExecutorProcessSpec = TaskExecutorProcessUtils.processSpecFromConfig((Configuration)config);
        Assert.assertThat((Object)taskExecutorProcessSpec.getTotalProcessMemorySize(), (Matcher)Matchers.is((Object)TOTAL_PROCESS_MEM_SIZE));
        validateFunc.accept(taskExecutorProcessSpec);
    }

    private void validateFailInConfigWithExplicitTotalProcessMem(Configuration customConfig) {
        this.log.info("Validating failing in configuration with explicit total process memory size.");
        Configuration config = TaskExecutorProcessUtilsTest.configWithExplicitTotalProcessMem();
        config.addAll(customConfig);
        this.validateFail(config);
    }

    @Override
    protected void validateFail(Configuration config) {
        try {
            TaskExecutorProcessUtils.processSpecFromConfig((Configuration)config);
            Assert.fail((String)"Configuration did not fail as expected.");
        }
        catch (IllegalConfigurationException illegalConfigurationException) {
            // empty catch block
        }
    }

    @Override
    protected void configWithFineGrainedOptions(Configuration configuration, MemorySize totalFlinkMemorySize) {
        MemorySize componentSize = new MemorySize(totalFlinkMemorySize.getBytes() / 6L);
        configuration.set(TaskManagerOptions.TASK_HEAP_MEMORY, (Object)componentSize);
        configuration.set(TaskManagerOptions.TASK_OFF_HEAP_MEMORY, (Object)componentSize);
        configuration.set(TaskManagerOptions.FRAMEWORK_HEAP_MEMORY, (Object)componentSize);
        configuration.set(TaskManagerOptions.FRAMEWORK_OFF_HEAP_MEMORY, (Object)componentSize);
        configuration.set(TaskManagerOptions.MANAGED_MEMORY_SIZE, (Object)componentSize);
    }

    private static Configuration configWithExplicitTaskHeapAndManageMem() {
        Configuration conf = new Configuration();
        conf.set(TaskManagerOptions.TASK_HEAP_MEMORY, (Object)TASK_HEAP_SIZE);
        conf.set(TaskManagerOptions.MANAGED_MEMORY_SIZE, (Object)MANAGED_MEM_SIZE);
        return conf;
    }

    private static Configuration configWithExplicitTotalFlinkMem() {
        Configuration conf = new Configuration();
        conf.set(TaskManagerOptions.TOTAL_FLINK_MEMORY, (Object)TOTAL_FLINK_MEM_SIZE);
        return conf;
    }

    private static Configuration configWithExplicitTotalFlinkAndTaskHeapMem() {
        Configuration conf = new Configuration();
        conf.set(TaskManagerOptions.TOTAL_FLINK_MEMORY, (Object)TOTAL_FLINK_MEM_SIZE);
        conf.set(TaskManagerOptions.TASK_HEAP_MEMORY, (Object)TASK_HEAP_SIZE);
        return conf;
    }

    private static Configuration configWithExplicitTotalFlinkAndManagedMem() {
        Configuration conf = new Configuration();
        conf.set(TaskManagerOptions.TOTAL_FLINK_MEMORY, (Object)TOTAL_FLINK_MEM_SIZE);
        conf.set(TaskManagerOptions.MANAGED_MEMORY_SIZE, (Object)MANAGED_MEM_SIZE);
        return conf;
    }

    private static Configuration configWithExplicitTotalProcessMem() {
        Configuration conf = new Configuration();
        conf.set(TaskManagerOptions.TOTAL_PROCESS_MEMORY, (Object)TOTAL_PROCESS_MEM_SIZE);
        return conf;
    }

    @Override
    protected TaskExecutorProcessSpec processSpecFromConfig(Configuration config) {
        return TaskExecutorProcessUtils.processSpecFromConfig((Configuration)config);
    }

    @Override
    protected Configuration getConfigurationWithLegacyHeapSizeMappedToNewConfigOption(Configuration config) {
        return TaskExecutorProcessUtils.getConfigurationMapLegacyTaskManagerHeapSizeToConfigOption((Configuration)config, this.getNewOptionForLegacyHeapOption());
    }
}

