/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.clusterframework;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.flink.api.common.resources.CPUResource;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ConfigurationUtils;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.configuration.GlobalConfiguration;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.runtime.akka.AkkaUtils;
import org.apache.flink.runtime.clusterframework.BootstrapTools;
import org.apache.flink.runtime.clusterframework.ContaineredTaskManagerParameters;
import org.apache.flink.runtime.clusterframework.TaskExecutorProcessSpec;
import org.apache.flink.runtime.clusterframework.TaskExecutorProcessUtils;
import org.apache.flink.runtime.concurrent.FutureUtils;
import org.apache.flink.util.ExecutorUtils;
import org.apache.flink.util.OperatingSystem;
import org.apache.flink.util.TestLogger;
import org.apache.flink.util.function.CheckedSupplier;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BootstrapToolsTest
extends TestLogger {
    private static final Logger LOG = LoggerFactory.getLogger(BootstrapToolsTest.class);
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Test
    public void testSubstituteConfigKey() {
        String deprecatedKey1 = "deprecated-key";
        String deprecatedKey2 = "another-out_of-date_key";
        String deprecatedKey3 = "yet-one-more";
        String designatedKey1 = "newkey1";
        String designatedKey2 = "newKey2";
        String designatedKey3 = "newKey3";
        String value1 = "value1";
        String value2Designated = "designated-value2";
        String value2Deprecated = "deprecated-value2";
        Configuration cfg = new Configuration();
        cfg.setString(deprecatedKey1, value1);
        cfg.setString(deprecatedKey2, value2Deprecated);
        cfg.setString(designatedKey2, value2Designated);
        BootstrapTools.substituteDeprecatedConfigKey((Configuration)cfg, (String)deprecatedKey1, (String)designatedKey1);
        BootstrapTools.substituteDeprecatedConfigKey((Configuration)cfg, (String)deprecatedKey2, (String)designatedKey2);
        BootstrapTools.substituteDeprecatedConfigKey((Configuration)cfg, (String)deprecatedKey3, (String)designatedKey3);
        Assert.assertEquals((Object)value1, (Object)cfg.getString(designatedKey1, null));
        Assert.assertEquals((Object)value2Designated, (Object)cfg.getString(designatedKey2, null));
        Assert.assertNull((Object)cfg.getString(designatedKey3, null));
        Assert.assertNull((Object)cfg.getString(deprecatedKey3, null));
    }

    @Test
    public void testSubstituteConfigKeyPrefix() {
        String deprecatedPrefix1 = "deprecated-prefix";
        String deprecatedPrefix2 = "-prefix-2";
        String deprecatedPrefix3 = "prefix-3";
        String designatedPrefix1 = "p1";
        String designatedPrefix2 = "ppp";
        String designatedPrefix3 = "zzz";
        String depr1 = deprecatedPrefix1 + "var";
        String depr2 = deprecatedPrefix2 + "env";
        String depr3 = deprecatedPrefix2 + "x";
        String desig1 = designatedPrefix1 + "var";
        String desig2 = designatedPrefix2 + "env";
        String desig3 = designatedPrefix2 + "x";
        String val1 = "1";
        String val2 = "2";
        String val3Depr = "3-";
        String val3Desig = "3+";
        Configuration cfg = new Configuration();
        cfg.setString(depr1, val1);
        cfg.setString(depr2, val2);
        cfg.setString(depr3, val3Depr);
        cfg.setString(desig3, val3Desig);
        BootstrapTools.substituteDeprecatedConfigPrefix((Configuration)cfg, (String)deprecatedPrefix1, (String)designatedPrefix1);
        BootstrapTools.substituteDeprecatedConfigPrefix((Configuration)cfg, (String)deprecatedPrefix2, (String)designatedPrefix2);
        BootstrapTools.substituteDeprecatedConfigPrefix((Configuration)cfg, (String)deprecatedPrefix3, (String)designatedPrefix3);
        Assert.assertEquals((Object)val1, (Object)cfg.getString(desig1, null));
        Assert.assertEquals((Object)val2, (Object)cfg.getString(desig2, null));
        Assert.assertEquals((Object)val3Desig, (Object)cfg.getString(desig3, null));
        for (String key : cfg.keySet()) {
            Assert.assertFalse((boolean)key.startsWith(designatedPrefix3));
            Assert.assertFalse((boolean)key.startsWith(deprecatedPrefix3));
        }
    }

    @Test
    public void testGetTaskManagerShellCommand() {
        Configuration cfg = new Configuration();
        TaskExecutorProcessSpec taskExecutorProcessSpec = new TaskExecutorProcessSpec(new CPUResource(1.0), new MemorySize(0L), new MemorySize(0L), new MemorySize(111L), new MemorySize(0L), new MemorySize(222L), new MemorySize(0L), new MemorySize(333L), new MemorySize(0L));
        ContaineredTaskManagerParameters containeredParams = new ContaineredTaskManagerParameters(taskExecutorProcessSpec, new HashMap());
        String java = "$JAVA_HOME/bin/java";
        String jvmmem = "-Xmx111 -Xms111 -XX:MaxDirectMemorySize=222 -XX:MaxMetaspaceSize=333";
        String jvmOpts = "-Djvm";
        String tmJvmOpts = "-DtmJvm";
        String logfile = "-Dlog.file=./logs/taskmanager.log";
        String logback = "-Dlogback.configurationFile=file:./conf/logback.xml";
        String log4j = "-Dlog4j.configuration=file:./conf/log4j.properties -Dlog4j.configurationFile=file:./conf/log4j.properties";
        String mainClass = "org.apache.flink.runtime.clusterframework.BootstrapToolsTest";
        String dynamicConfigs = TaskExecutorProcessUtils.generateDynamicConfigsStr((TaskExecutorProcessSpec)taskExecutorProcessSpec).trim();
        String basicArgs = "--configDir ./conf";
        String mainArgs = "-Djobmanager.rpc.address=host1 -Dkey.a=v1";
        String args = dynamicConfigs + " " + "--configDir ./conf" + " " + "-Djobmanager.rpc.address=host1 -Dkey.a=v1";
        String redirects = "1> ./logs/taskmanager.out 2> ./logs/taskmanager.err";
        Assert.assertEquals((Object)("$JAVA_HOME/bin/java -Xmx111 -Xms111 -XX:MaxDirectMemorySize=222 -XX:MaxMetaspaceSize=333 org.apache.flink.runtime.clusterframework.BootstrapToolsTest " + dynamicConfigs + " " + "--configDir ./conf" + " " + "1> ./logs/taskmanager.out 2> ./logs/taskmanager.err"), (Object)BootstrapTools.getTaskManagerShellCommand((Configuration)cfg, (ContaineredTaskManagerParameters)containeredParams, (String)"./conf", (String)"./logs", (boolean)false, (boolean)false, (boolean)false, ((Object)((Object)this)).getClass(), (String)""));
        Assert.assertEquals((Object)("$JAVA_HOME/bin/java -Xmx111 -Xms111 -XX:MaxDirectMemorySize=222 -XX:MaxMetaspaceSize=333 org.apache.flink.runtime.clusterframework.BootstrapToolsTest " + args + " " + "1> ./logs/taskmanager.out 2> ./logs/taskmanager.err"), (Object)BootstrapTools.getTaskManagerShellCommand((Configuration)cfg, (ContaineredTaskManagerParameters)containeredParams, (String)"./conf", (String)"./logs", (boolean)false, (boolean)false, (boolean)false, ((Object)((Object)this)).getClass(), (String)"-Djobmanager.rpc.address=host1 -Dkey.a=v1"));
        String krb5 = "-Djava.security.krb5.conf=krb5.conf";
        Assert.assertEquals((Object)("$JAVA_HOME/bin/java -Xmx111 -Xms111 -XX:MaxDirectMemorySize=222 -XX:MaxMetaspaceSize=333 -Djava.security.krb5.conf=krb5.conf org.apache.flink.runtime.clusterframework.BootstrapToolsTest " + args + " " + "1> ./logs/taskmanager.out 2> ./logs/taskmanager.err"), (Object)BootstrapTools.getTaskManagerShellCommand((Configuration)cfg, (ContaineredTaskManagerParameters)containeredParams, (String)"./conf", (String)"./logs", (boolean)false, (boolean)false, (boolean)true, ((Object)((Object)this)).getClass(), (String)"-Djobmanager.rpc.address=host1 -Dkey.a=v1"));
        Assert.assertEquals((Object)("$JAVA_HOME/bin/java -Xmx111 -Xms111 -XX:MaxDirectMemorySize=222 -XX:MaxMetaspaceSize=333 -Dlog.file=./logs/taskmanager.log -Dlogback.configurationFile=file:./conf/logback.xml org.apache.flink.runtime.clusterframework.BootstrapToolsTest " + args + " " + "1> ./logs/taskmanager.out 2> ./logs/taskmanager.err"), (Object)BootstrapTools.getTaskManagerShellCommand((Configuration)cfg, (ContaineredTaskManagerParameters)containeredParams, (String)"./conf", (String)"./logs", (boolean)true, (boolean)false, (boolean)false, ((Object)((Object)this)).getClass(), (String)"-Djobmanager.rpc.address=host1 -Dkey.a=v1"));
        Assert.assertEquals((Object)("$JAVA_HOME/bin/java -Xmx111 -Xms111 -XX:MaxDirectMemorySize=222 -XX:MaxMetaspaceSize=333 -Djava.security.krb5.conf=krb5.conf -Dlog.file=./logs/taskmanager.log -Dlogback.configurationFile=file:./conf/logback.xml org.apache.flink.runtime.clusterframework.BootstrapToolsTest " + args + " " + "1> ./logs/taskmanager.out 2> ./logs/taskmanager.err"), (Object)BootstrapTools.getTaskManagerShellCommand((Configuration)cfg, (ContaineredTaskManagerParameters)containeredParams, (String)"./conf", (String)"./logs", (boolean)true, (boolean)false, (boolean)true, ((Object)((Object)this)).getClass(), (String)"-Djobmanager.rpc.address=host1 -Dkey.a=v1"));
        Assert.assertEquals((Object)("$JAVA_HOME/bin/java -Xmx111 -Xms111 -XX:MaxDirectMemorySize=222 -XX:MaxMetaspaceSize=333 -Dlog.file=./logs/taskmanager.log -Dlog4j.configuration=file:./conf/log4j.properties -Dlog4j.configurationFile=file:./conf/log4j.properties org.apache.flink.runtime.clusterframework.BootstrapToolsTest " + args + " " + "1> ./logs/taskmanager.out 2> ./logs/taskmanager.err"), (Object)BootstrapTools.getTaskManagerShellCommand((Configuration)cfg, (ContaineredTaskManagerParameters)containeredParams, (String)"./conf", (String)"./logs", (boolean)false, (boolean)true, (boolean)false, ((Object)((Object)this)).getClass(), (String)"-Djobmanager.rpc.address=host1 -Dkey.a=v1"));
        Assert.assertEquals((Object)("$JAVA_HOME/bin/java -Xmx111 -Xms111 -XX:MaxDirectMemorySize=222 -XX:MaxMetaspaceSize=333 -Djava.security.krb5.conf=krb5.conf -Dlog.file=./logs/taskmanager.log -Dlog4j.configuration=file:./conf/log4j.properties -Dlog4j.configurationFile=file:./conf/log4j.properties org.apache.flink.runtime.clusterframework.BootstrapToolsTest " + args + " " + "1> ./logs/taskmanager.out 2> ./logs/taskmanager.err"), (Object)BootstrapTools.getTaskManagerShellCommand((Configuration)cfg, (ContaineredTaskManagerParameters)containeredParams, (String)"./conf", (String)"./logs", (boolean)false, (boolean)true, (boolean)true, ((Object)((Object)this)).getClass(), (String)"-Djobmanager.rpc.address=host1 -Dkey.a=v1"));
        Assert.assertEquals((Object)("$JAVA_HOME/bin/java -Xmx111 -Xms111 -XX:MaxDirectMemorySize=222 -XX:MaxMetaspaceSize=333 -Dlog.file=./logs/taskmanager.log -Dlogback.configurationFile=file:./conf/logback.xml -Dlog4j.configuration=file:./conf/log4j.properties -Dlog4j.configurationFile=file:./conf/log4j.properties org.apache.flink.runtime.clusterframework.BootstrapToolsTest " + args + " " + "1> ./logs/taskmanager.out 2> ./logs/taskmanager.err"), (Object)BootstrapTools.getTaskManagerShellCommand((Configuration)cfg, (ContaineredTaskManagerParameters)containeredParams, (String)"./conf", (String)"./logs", (boolean)true, (boolean)true, (boolean)false, ((Object)((Object)this)).getClass(), (String)"-Djobmanager.rpc.address=host1 -Dkey.a=v1"));
        Assert.assertEquals((Object)("$JAVA_HOME/bin/java -Xmx111 -Xms111 -XX:MaxDirectMemorySize=222 -XX:MaxMetaspaceSize=333 -Djava.security.krb5.conf=krb5.conf -Dlog.file=./logs/taskmanager.log -Dlogback.configurationFile=file:./conf/logback.xml -Dlog4j.configuration=file:./conf/log4j.properties -Dlog4j.configurationFile=file:./conf/log4j.properties org.apache.flink.runtime.clusterframework.BootstrapToolsTest " + args + " " + "1> ./logs/taskmanager.out 2> ./logs/taskmanager.err"), (Object)BootstrapTools.getTaskManagerShellCommand((Configuration)cfg, (ContaineredTaskManagerParameters)containeredParams, (String)"./conf", (String)"./logs", (boolean)true, (boolean)true, (boolean)true, ((Object)((Object)this)).getClass(), (String)"-Djobmanager.rpc.address=host1 -Dkey.a=v1"));
        cfg.setString(CoreOptions.FLINK_JVM_OPTIONS, "-Djvm");
        Assert.assertEquals((Object)("$JAVA_HOME/bin/java -Xmx111 -Xms111 -XX:MaxDirectMemorySize=222 -XX:MaxMetaspaceSize=333 -Djvm -Dlog.file=./logs/taskmanager.log -Dlogback.configurationFile=file:./conf/logback.xml -Dlog4j.configuration=file:./conf/log4j.properties -Dlog4j.configurationFile=file:./conf/log4j.properties org.apache.flink.runtime.clusterframework.BootstrapToolsTest " + args + " " + "1> ./logs/taskmanager.out 2> ./logs/taskmanager.err"), (Object)BootstrapTools.getTaskManagerShellCommand((Configuration)cfg, (ContaineredTaskManagerParameters)containeredParams, (String)"./conf", (String)"./logs", (boolean)true, (boolean)true, (boolean)false, ((Object)((Object)this)).getClass(), (String)"-Djobmanager.rpc.address=host1 -Dkey.a=v1"));
        Assert.assertEquals((Object)("$JAVA_HOME/bin/java -Xmx111 -Xms111 -XX:MaxDirectMemorySize=222 -XX:MaxMetaspaceSize=333 -Djvm -Djava.security.krb5.conf=krb5.conf -Dlog.file=./logs/taskmanager.log -Dlogback.configurationFile=file:./conf/logback.xml -Dlog4j.configuration=file:./conf/log4j.properties -Dlog4j.configurationFile=file:./conf/log4j.properties org.apache.flink.runtime.clusterframework.BootstrapToolsTest " + args + " " + "1> ./logs/taskmanager.out 2> ./logs/taskmanager.err"), (Object)BootstrapTools.getTaskManagerShellCommand((Configuration)cfg, (ContaineredTaskManagerParameters)containeredParams, (String)"./conf", (String)"./logs", (boolean)true, (boolean)true, (boolean)true, ((Object)((Object)this)).getClass(), (String)"-Djobmanager.rpc.address=host1 -Dkey.a=v1"));
        cfg.setString(CoreOptions.FLINK_TM_JVM_OPTIONS, "-DtmJvm");
        Assert.assertEquals((Object)("$JAVA_HOME/bin/java -Xmx111 -Xms111 -XX:MaxDirectMemorySize=222 -XX:MaxMetaspaceSize=333 -Djvm -DtmJvm -Dlog.file=./logs/taskmanager.log -Dlogback.configurationFile=file:./conf/logback.xml -Dlog4j.configuration=file:./conf/log4j.properties -Dlog4j.configurationFile=file:./conf/log4j.properties org.apache.flink.runtime.clusterframework.BootstrapToolsTest " + args + " " + "1> ./logs/taskmanager.out 2> ./logs/taskmanager.err"), (Object)BootstrapTools.getTaskManagerShellCommand((Configuration)cfg, (ContaineredTaskManagerParameters)containeredParams, (String)"./conf", (String)"./logs", (boolean)true, (boolean)true, (boolean)false, ((Object)((Object)this)).getClass(), (String)"-Djobmanager.rpc.address=host1 -Dkey.a=v1"));
        Assert.assertEquals((Object)("$JAVA_HOME/bin/java -Xmx111 -Xms111 -XX:MaxDirectMemorySize=222 -XX:MaxMetaspaceSize=333 -Djvm -DtmJvm -Djava.security.krb5.conf=krb5.conf -Dlog.file=./logs/taskmanager.log -Dlogback.configurationFile=file:./conf/logback.xml -Dlog4j.configuration=file:./conf/log4j.properties -Dlog4j.configurationFile=file:./conf/log4j.properties org.apache.flink.runtime.clusterframework.BootstrapToolsTest " + args + " " + "1> ./logs/taskmanager.out 2> ./logs/taskmanager.err"), (Object)BootstrapTools.getTaskManagerShellCommand((Configuration)cfg, (ContaineredTaskManagerParameters)containeredParams, (String)"./conf", (String)"./logs", (boolean)true, (boolean)true, (boolean)true, ((Object)((Object)this)).getClass(), (String)"-Djobmanager.rpc.address=host1 -Dkey.a=v1"));
        cfg.setString("yarn.container-start-command-template", "%java% 1 %jvmmem% 2 %jvmopts% 3 %logging% 4 %class% 5 %args% 6 %redirects%");
        Assert.assertEquals((Object)("$JAVA_HOME/bin/java 1 -Xmx111 -Xms111 -XX:MaxDirectMemorySize=222 -XX:MaxMetaspaceSize=333 2 -Djvm -DtmJvm -Djava.security.krb5.conf=krb5.conf 3 -Dlog.file=./logs/taskmanager.log -Dlogback.configurationFile=file:./conf/logback.xml -Dlog4j.configuration=file:./conf/log4j.properties -Dlog4j.configurationFile=file:./conf/log4j.properties 4 org.apache.flink.runtime.clusterframework.BootstrapToolsTest 5 " + args + " 6 " + "1> ./logs/taskmanager.out 2> ./logs/taskmanager.err"), (Object)BootstrapTools.getTaskManagerShellCommand((Configuration)cfg, (ContaineredTaskManagerParameters)containeredParams, (String)"./conf", (String)"./logs", (boolean)true, (boolean)true, (boolean)true, ((Object)((Object)this)).getClass(), (String)"-Djobmanager.rpc.address=host1 -Dkey.a=v1"));
        cfg.setString("yarn.container-start-command-template", "%java% %logging% %jvmopts% %jvmmem% %class% %args% %redirects%");
        Assert.assertEquals((Object)("$JAVA_HOME/bin/java -Dlog.file=./logs/taskmanager.log -Dlogback.configurationFile=file:./conf/logback.xml -Dlog4j.configuration=file:./conf/log4j.properties -Dlog4j.configurationFile=file:./conf/log4j.properties -Djvm -DtmJvm -Djava.security.krb5.conf=krb5.conf -Xmx111 -Xms111 -XX:MaxDirectMemorySize=222 -XX:MaxMetaspaceSize=333 org.apache.flink.runtime.clusterframework.BootstrapToolsTest " + args + " " + "1> ./logs/taskmanager.out 2> ./logs/taskmanager.err"), (Object)BootstrapTools.getTaskManagerShellCommand((Configuration)cfg, (ContaineredTaskManagerParameters)containeredParams, (String)"./conf", (String)"./logs", (boolean)true, (boolean)true, (boolean)true, ((Object)((Object)this)).getClass(), (String)"-Djobmanager.rpc.address=host1 -Dkey.a=v1"));
    }

    @Test
    public void testUpdateTmpDirectoriesInConfiguration() {
        Configuration config = new Configuration();
        BootstrapTools.updateTmpDirectoriesInConfiguration((Configuration)config, (String)"default/directory/path");
        Assert.assertEquals((Object)config.getString(CoreOptions.TMP_DIRS), (Object)"default/directory/path");
        BootstrapTools.updateTmpDirectoriesInConfiguration((Configuration)config, (String)"not/default/directory/path");
        Assert.assertEquals((Object)config.getString(CoreOptions.TMP_DIRS), (Object)"default/directory/path");
        config.setString(CoreOptions.TMP_DIRS, "");
        BootstrapTools.updateTmpDirectoriesInConfiguration((Configuration)config, (String)"some/new/path");
        Assert.assertEquals((Object)config.getString(CoreOptions.TMP_DIRS), (Object)"");
    }

    @Test
    public void testShouldNotUpdateTmpDirectoriesInConfigurationIfNoValueConfigured() {
        Configuration config = new Configuration();
        BootstrapTools.updateTmpDirectoriesInConfiguration((Configuration)config, null);
        Assert.assertEquals((Object)config.getString(CoreOptions.TMP_DIRS), (Object)CoreOptions.TMP_DIRS.defaultValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConcurrentActorSystemCreation() throws Exception {
        int concurrentCreations = 10;
        ExecutorService executorService = Executors.newFixedThreadPool(10);
        CyclicBarrier cyclicBarrier = new CyclicBarrier(10);
        try {
            List actorSystemFutures = IntStream.range(0, 10).mapToObj(ignored -> CompletableFuture.supplyAsync(CheckedSupplier.unchecked(() -> {
                cyclicBarrier.await();
                return BootstrapTools.startRemoteActorSystem((Configuration)new Configuration(), (String)"localhost", (String)"0", (Logger)LOG);
            }), executorService)).map(actorSystemFuture -> actorSystemFuture.thenCompose(AkkaUtils::terminateActorSystem)).collect(Collectors.toList());
            FutureUtils.completeAll(actorSystemFutures).get();
        }
        catch (Throwable throwable) {
            ExecutorUtils.gracefulShutdown((long)10000L, (TimeUnit)TimeUnit.MILLISECONDS, (ExecutorService[])new ExecutorService[]{executorService});
            throw throwable;
        }
        ExecutorUtils.gracefulShutdown((long)10000L, (TimeUnit)TimeUnit.MILLISECONDS, (ExecutorService[])new ExecutorService[]{executorService});
    }

    @Test
    public void testActorSystemInstantiationFailureWhenPortOccupied() throws Exception {
        try (ServerSocket portOccupier = new ServerSocket(0, 10, InetAddress.getByName("0.0.0.0"));){
            int port = portOccupier.getLocalPort();
            BootstrapTools.startRemoteActorSystem((Configuration)new Configuration(), (String)"0.0.0.0", (String)String.valueOf(port), (Logger)LOG);
            Assert.fail((String)"Expected to fail with a BindException");
        }
    }

    @Test
    public void testGetDynamicPropertiesAsString() {
        Configuration baseConfig = new Configuration();
        baseConfig.setString("key.a", "a");
        baseConfig.setString("key.b", "b1");
        Configuration targetConfig = new Configuration();
        targetConfig.setString("key.b", "b2");
        targetConfig.setString("key.c", "c");
        String dynamicProperties = BootstrapTools.getDynamicPropertiesAsString((Configuration)baseConfig, (Configuration)targetConfig);
        if (OperatingSystem.isWindows()) {
            Assert.assertEquals((Object)"-Dkey.b=\"b2\" -Dkey.c=\"c\"", (Object)dynamicProperties);
        } else {
            Assert.assertEquals((Object)"-Dkey.b='b2' -Dkey.c='c'", (Object)dynamicProperties);
        }
    }

    @Test
    public void testEscapeDynamicPropertyValueWithSingleQuote() {
        String value1 = "#a,b&c^d*e@f(g!h";
        Assert.assertEquals((Object)"'#a,b&c^d*e@f(g!h'", (Object)BootstrapTools.escapeWithSingleQuote((String)"#a,b&c^d*e@f(g!h"));
        String value2 = "'foobar";
        Assert.assertEquals((Object)"''\\''foobar'", (Object)BootstrapTools.escapeWithSingleQuote((String)"'foobar"));
        String value3 = "foo''bar";
        Assert.assertEquals((Object)"'foo'\\'''\\''bar'", (Object)BootstrapTools.escapeWithSingleQuote((String)"foo''bar"));
        String value4 = "'foo' 'bar'";
        Assert.assertEquals((Object)"''\\''foo'\\'' '\\''bar'\\'''", (Object)BootstrapTools.escapeWithSingleQuote((String)"'foo' 'bar'"));
    }

    @Test
    public void testEscapeDynamicPropertyValueWithDoubleQuote() {
        String value1 = "#a,b&c^d*e@f(g!h";
        Assert.assertEquals((Object)"\"#a,b&c\"^^\"d*e@f(g!h\"", (Object)BootstrapTools.escapeWithDoubleQuote((String)"#a,b&c^d*e@f(g!h"));
        String value2 = "foo\"bar'";
        Assert.assertEquals((Object)"\"foo\\\"bar'\"", (Object)BootstrapTools.escapeWithDoubleQuote((String)"foo\"bar'"));
        String value3 = "\"foo\" \"bar\"";
        Assert.assertEquals((Object)"\"\\\"foo\\\" \\\"bar\\\"\"", (Object)BootstrapTools.escapeWithDoubleQuote((String)"\"foo\" \"bar\""));
    }

    @Test
    public void testGetEnvironmentVariables() {
        Configuration testConf = new Configuration();
        testConf.setString("containerized.master.env.LD_LIBRARY_PATH", "/usr/lib/native");
        Map res = ConfigurationUtils.getPrefixedKeyValuePairs((String)"containerized.master.env.", (Configuration)testConf);
        Assert.assertEquals((long)1L, (long)res.size());
        Map.Entry entry = res.entrySet().iterator().next();
        Assert.assertEquals((Object)"LD_LIBRARY_PATH", entry.getKey());
        Assert.assertEquals((Object)"/usr/lib/native", entry.getValue());
    }

    @Test
    public void testGetEnvironmentVariablesErroneous() {
        Configuration testConf = new Configuration();
        testConf.setString("containerized.master.env.", "/usr/lib/native");
        Map res = ConfigurationUtils.getPrefixedKeyValuePairs((String)"containerized.master.env.", (Configuration)testConf);
        Assert.assertEquals((long)0L, (long)res.size());
    }

    @Test
    public void testWriteConfigurationAndReload() throws IOException {
        File flinkConfDir = this.temporaryFolder.newFolder().getAbsoluteFile();
        Configuration flinkConfig = new Configuration();
        ConfigOption listStringConfigOption = ConfigOptions.key((String)"test-list-string-key").stringType().asList().noDefaultValue();
        List<String> list = Arrays.asList("A,B,C,D", "A'B'C'D", "A;BCD", "AB\"C\"D", "AB'\"D:B");
        flinkConfig.set(listStringConfigOption, list);
        Assert.assertThat((Object)flinkConfig.get(listStringConfigOption), (Matcher)Matchers.containsInAnyOrder((Object[])list.toArray()));
        ConfigOption listDurationConfigOption = ConfigOptions.key((String)"test-list-duration-key").durationType().asList().noDefaultValue();
        List<Duration> durationList = Arrays.asList(Duration.ofSeconds(3L), Duration.ofMinutes(1L));
        flinkConfig.set(listDurationConfigOption, durationList);
        Assert.assertThat((Object)flinkConfig.get(listDurationConfigOption), (Matcher)Matchers.containsInAnyOrder((Object[])durationList.toArray()));
        ConfigOption mapConfigOption = ConfigOptions.key((String)"test-map-key").mapType().noDefaultValue();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("key1", "A,B,C,D");
        map.put("key2", "A;BCD");
        map.put("key3", "A'B'C'D");
        map.put("key4", "AB\"C\"D");
        map.put("key5", "AB'\"D:B");
        flinkConfig.set(mapConfigOption, map);
        Assert.assertThat(((Map)flinkConfig.get(mapConfigOption)).entrySet(), (Matcher)Matchers.containsInAnyOrder((Object[])map.entrySet().toArray()));
        ConfigOption durationConfigOption = ConfigOptions.key((String)"test-duration-key").durationType().noDefaultValue();
        Duration duration = Duration.ofMillis(3000L);
        flinkConfig.set(durationConfigOption, (Object)duration);
        Assert.assertEquals((Object)duration, (Object)flinkConfig.get(durationConfigOption));
        BootstrapTools.writeConfiguration((Configuration)flinkConfig, (File)new File(flinkConfDir, "flink-conf.yaml"));
        Configuration loadedFlinkConfig = GlobalConfiguration.loadConfiguration((String)flinkConfDir.getAbsolutePath());
        Assert.assertThat((Object)loadedFlinkConfig.get(listStringConfigOption), (Matcher)Matchers.containsInAnyOrder((Object[])list.toArray()));
        Assert.assertThat((Object)loadedFlinkConfig.get(listDurationConfigOption), (Matcher)Matchers.containsInAnyOrder((Object[])durationList.toArray()));
        Assert.assertThat(((Map)loadedFlinkConfig.get(mapConfigOption)).entrySet(), (Matcher)Matchers.containsInAnyOrder((Object[])map.entrySet().toArray()));
        Assert.assertEquals((Object)duration, (Object)loadedFlinkConfig.get(durationConfigOption));
    }
}

