/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import org.apache.flink.configuration.ConfigConstants;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.checkpoint.MasterState;
import org.apache.flink.runtime.checkpoint.OperatorState;
import org.apache.flink.runtime.checkpoint.OperatorSubtaskState;
import org.apache.flink.runtime.checkpoint.StateHandleDummyUtil;
import org.apache.flink.runtime.checkpoint.StateObjectCollection;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.state.IncrementalRemoteKeyedStateHandle;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.KeyGroupRangeOffsets;
import org.apache.flink.runtime.state.KeyGroupsStateHandle;
import org.apache.flink.runtime.state.KeyedStateHandle;
import org.apache.flink.runtime.state.OperatorStateHandle;
import org.apache.flink.runtime.state.OperatorStreamStateHandle;
import org.apache.flink.runtime.state.StateHandleID;
import org.apache.flink.runtime.state.StateObject;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.runtime.state.filesystem.RelativeFileStateHandle;
import org.apache.flink.runtime.state.memory.ByteStreamStateHandle;
import org.apache.flink.util.StringUtils;
import org.junit.Assert;

public class CheckpointTestUtils {
    public static Collection<OperatorState> createOperatorStates(Random random, @Nullable String basePath, int numTaskStates, int numSubtasksPerTask) {
        ArrayList<OperatorState> taskStates = new ArrayList<OperatorState>(numTaskStates);
        for (int stateIdx = 0; stateIdx < numTaskStates; ++stateIdx) {
            OperatorState taskState = new OperatorState(new OperatorID(), numSubtasksPerTask, 128);
            boolean hasCoordinatorState = random.nextBoolean();
            if (hasCoordinatorState) {
                ByteStreamStateHandle stateHandle = CheckpointTestUtils.createDummyByteStreamStreamStateHandle(random);
                taskState.setCoordinatorState(stateHandle);
            }
            boolean hasOperatorStateBackend = random.nextBoolean();
            boolean hasOperatorStateStream = random.nextBoolean();
            boolean hasKeyedBackend = random.nextInt(4) != 0;
            boolean hasKeyedStream = random.nextInt(4) != 0;
            boolean isIncremental = random.nextInt(3) == 0;
            for (int subtaskIdx = 0; subtaskIdx < numSubtasksPerTask; ++subtaskIdx) {
                ByteStreamStateHandle operatorStateBackend = new ByteStreamStateHandle("b", "Beautiful".getBytes(ConfigConstants.DEFAULT_CHARSET));
                ByteStreamStateHandle operatorStateStream = new ByteStreamStateHandle("b", "Beautiful".getBytes(ConfigConstants.DEFAULT_CHARSET));
                OperatorStreamStateHandle operatorStateHandleBackend = null;
                OperatorStreamStateHandle operatorStateHandleStream = null;
                HashMap<String, OperatorStateHandle.StateMetaInfo> offsetsMap = new HashMap<String, OperatorStateHandle.StateMetaInfo>();
                offsetsMap.put("A", new OperatorStateHandle.StateMetaInfo(new long[]{0L, 10L, 20L}, OperatorStateHandle.Mode.SPLIT_DISTRIBUTE));
                offsetsMap.put("B", new OperatorStateHandle.StateMetaInfo(new long[]{30L, 40L, 50L}, OperatorStateHandle.Mode.SPLIT_DISTRIBUTE));
                offsetsMap.put("C", new OperatorStateHandle.StateMetaInfo(new long[]{60L, 70L, 80L}, OperatorStateHandle.Mode.UNION));
                if (hasOperatorStateBackend) {
                    operatorStateHandleBackend = new OperatorStreamStateHandle(offsetsMap, (StreamStateHandle)operatorStateBackend);
                }
                if (hasOperatorStateStream) {
                    operatorStateHandleStream = new OperatorStreamStateHandle(offsetsMap, (StreamStateHandle)operatorStateStream);
                }
                Object keyedStateBackend = null;
                KeyGroupsStateHandle keyedStateStream = null;
                if (hasKeyedBackend) {
                    keyedStateBackend = isIncremental && !CheckpointTestUtils.isSavepoint(basePath) ? CheckpointTestUtils.createDummyIncrementalKeyedStateHandle(random) : CheckpointTestUtils.createDummyKeyGroupStateHandle(random, basePath);
                }
                if (hasKeyedStream) {
                    keyedStateStream = CheckpointTestUtils.createDummyKeyGroupStateHandle(random, basePath);
                }
                StateObjectCollection inputChannelStateHandles = random.nextBoolean() && !CheckpointTestUtils.isSavepoint(basePath) ? StateObjectCollection.singleton((StateObject)StateHandleDummyUtil.createNewInputChannelStateHandle(random.nextInt(5), random)) : StateObjectCollection.empty();
                StateObjectCollection resultSubpartitionStateHandles = random.nextBoolean() && !CheckpointTestUtils.isSavepoint(basePath) ? StateObjectCollection.singleton((StateObject)StateHandleDummyUtil.createNewResultSubpartitionStateHandle(random.nextInt(5), random)) : StateObjectCollection.empty();
                taskState.putState(subtaskIdx, new OperatorSubtaskState((OperatorStateHandle)operatorStateHandleBackend, (OperatorStateHandle)operatorStateHandleStream, (KeyedStateHandle)keyedStateStream, (KeyedStateHandle)keyedStateBackend, inputChannelStateHandles, resultSubpartitionStateHandles));
            }
            taskStates.add(taskState);
        }
        return taskStates;
    }

    private static boolean isSavepoint(String basePath) {
        return basePath != null;
    }

    public static Collection<MasterState> createRandomMasterStates(Random random, int num) {
        ArrayList<MasterState> states = new ArrayList<MasterState>(num);
        for (int i = 0; i < num; ++i) {
            int version = random.nextInt(10);
            String name = StringUtils.getRandomString((Random)random, (int)5, (int)500);
            byte[] bytes = new byte[random.nextInt(5000) + 1];
            random.nextBytes(bytes);
            states.add(new MasterState(name, bytes, version));
        }
        return states;
    }

    public static void assertMasterStateEquality(MasterState a, MasterState b) {
        Assert.assertEquals((long)a.version(), (long)b.version());
        Assert.assertEquals((Object)a.name(), (Object)b.name());
        Assert.assertArrayEquals((byte[])a.bytes(), (byte[])b.bytes());
    }

    private CheckpointTestUtils() {
    }

    public static IncrementalRemoteKeyedStateHandle createDummyIncrementalKeyedStateHandle(Random rnd) {
        return new IncrementalRemoteKeyedStateHandle(CheckpointTestUtils.createRandomUUID(rnd), new KeyGroupRange(1, 1), 42L, CheckpointTestUtils.createRandomStateHandleMap(rnd), CheckpointTestUtils.createRandomStateHandleMap(rnd), CheckpointTestUtils.createDummyStreamStateHandle(rnd, null));
    }

    public static Map<StateHandleID, StreamStateHandle> createRandomStateHandleMap(Random rnd) {
        int size = rnd.nextInt(4);
        HashMap<StateHandleID, StreamStateHandle> result = new HashMap<StateHandleID, StreamStateHandle>(size);
        for (int i = 0; i < size; ++i) {
            StateHandleID randomId = new StateHandleID(CheckpointTestUtils.createRandomUUID(rnd).toString());
            StreamStateHandle stateHandle = CheckpointTestUtils.createDummyStreamStateHandle(rnd, null);
            result.put(randomId, stateHandle);
        }
        return result;
    }

    public static KeyGroupsStateHandle createDummyKeyGroupStateHandle(Random rnd, String basePath) {
        return new KeyGroupsStateHandle(new KeyGroupRangeOffsets(1, 1, new long[]{rnd.nextInt(1024)}), CheckpointTestUtils.createDummyStreamStateHandle(rnd, basePath));
    }

    public static ByteStreamStateHandle createDummyByteStreamStreamStateHandle(Random rnd) {
        return (ByteStreamStateHandle)CheckpointTestUtils.createDummyStreamStateHandle(rnd, null);
    }

    public static StreamStateHandle createDummyStreamStateHandle(Random rnd, @Nullable String basePath) {
        if (!CheckpointTestUtils.isSavepoint(basePath)) {
            return new ByteStreamStateHandle(String.valueOf(CheckpointTestUtils.createRandomUUID(rnd)), String.valueOf(CheckpointTestUtils.createRandomUUID(rnd)).getBytes(ConfigConstants.DEFAULT_CHARSET));
        }
        long stateSize = rnd.nextLong();
        if (stateSize <= 0L) {
            stateSize = -stateSize;
        }
        String relativePath = String.valueOf(CheckpointTestUtils.createRandomUUID(rnd));
        Path statePath = new Path(basePath, relativePath);
        return new RelativeFileStateHandle(statePath, relativePath, stateSize);
    }

    private static UUID createRandomUUID(Random rnd) {
        return new UUID(rnd.nextLong(), rnd.nextLong());
    }
}

