/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint.channel;

import java.util.ArrayDeque;
import java.util.Deque;
import org.apache.flink.runtime.checkpoint.channel.ChannelStateSerializer;
import org.apache.flink.runtime.checkpoint.channel.ChannelStateSerializerImpl;
import org.apache.flink.runtime.checkpoint.channel.ChannelStateWriteRequest;
import org.apache.flink.runtime.checkpoint.channel.ChannelStateWriteRequestDispatcher;
import org.apache.flink.runtime.checkpoint.channel.ChannelStateWriteRequestDispatcherImpl;
import org.apache.flink.runtime.checkpoint.channel.ChannelStateWriteRequestExecutor;
import org.apache.flink.runtime.state.ChannelPersistenceITCase;

class SyncChannelStateWriteRequestExecutor
implements ChannelStateWriteRequestExecutor {
    private final ChannelStateWriteRequestDispatcher requestProcessor;
    private final Deque<ChannelStateWriteRequest> deque = new ArrayDeque<ChannelStateWriteRequest>();
    private Exception thrown;

    SyncChannelStateWriteRequestExecutor() {
        this.requestProcessor = new ChannelStateWriteRequestDispatcherImpl(ChannelPersistenceITCase.getStreamFactoryFactory(), (ChannelStateSerializer)new ChannelStateSerializerImpl());
    }

    public void submit(ChannelStateWriteRequest e) throws Exception {
        this.deque.offer(e);
        if (this.thrown != null) {
            throw this.thrown;
        }
    }

    public void submitPriority(ChannelStateWriteRequest e) throws Exception {
        this.deque.offerFirst(e);
        if (this.thrown != null) {
            throw this.thrown;
        }
    }

    public void start() throws IllegalStateException {
    }

    public void close() {
    }

    void processAllRequests() throws Exception {
        while (!this.deque.isEmpty()) {
            this.requestProcessor.dispatch(this.deque.poll());
        }
    }

    public void setThrown(Exception thrown) {
        this.thrown = thrown;
    }
}

