/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Executor;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.checkpoint.CheckpointProperties;
import org.apache.flink.runtime.checkpoint.CheckpointRetentionPolicy;
import org.apache.flink.runtime.checkpoint.CompletedCheckpoint;
import org.apache.flink.runtime.checkpoint.ZooKeeperCompletedCheckpointStore;
import org.apache.flink.runtime.concurrent.Executors;
import org.apache.flink.runtime.state.CompletedCheckpointStorageLocation;
import org.apache.flink.runtime.state.RetrievableStateHandle;
import org.apache.flink.runtime.state.testutils.TestCompletedCheckpointStorageLocation;
import org.apache.flink.runtime.zookeeper.RetrievableStateStorageHelper;
import org.apache.flink.runtime.zookeeper.ZooKeeperStateHandleStore;
import org.apache.flink.shaded.curator4.org.apache.curator.framework.CuratorFramework;
import org.apache.flink.shaded.curator4.org.apache.curator.framework.api.BackgroundCallback;
import org.apache.flink.shaded.curator4.org.apache.curator.framework.api.CuratorEvent;
import org.apache.flink.shaded.curator4.org.apache.curator.framework.api.CuratorEventType;
import org.apache.flink.shaded.curator4.org.apache.curator.framework.api.ErrorListenerPathable;
import org.apache.flink.shaded.curator4.org.apache.curator.utils.EnsurePath;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class ZooKeeperCompletedCheckpointStoreMockitoTest
extends TestLogger {
    @Test(timeout=50000L)
    public void testCheckpointRecovery() throws Exception {
        JobID jobID = new JobID();
        long checkpoint1Id = 1L;
        long checkpoint2Id = 2L;
        ArrayList<Tuple2> checkpointsInZooKeeper = new ArrayList<Tuple2>(4);
        HashSet<Long> expectedCheckpointIds = new HashSet<Long>(2);
        expectedCheckpointIds.add(1L);
        expectedCheckpointIds.add(2L);
        RetrievableStateHandle failingRetrievableStateHandle = (RetrievableStateHandle)Mockito.mock(RetrievableStateHandle.class);
        Mockito.when((Object)failingRetrievableStateHandle.retrieveState()).thenThrow(new Throwable[]{new IOException("Test exception")});
        RetrievableStateHandle retrievableStateHandle1 = (RetrievableStateHandle)Mockito.mock(RetrievableStateHandle.class);
        Mockito.when((Object)retrievableStateHandle1.retrieveState()).then(invocation -> new CompletedCheckpoint(jobID, 1L, 1L, 1L, new HashMap(), null, CheckpointProperties.forCheckpoint((CheckpointRetentionPolicy)CheckpointRetentionPolicy.NEVER_RETAIN_AFTER_TERMINATION), (CompletedCheckpointStorageLocation)new TestCompletedCheckpointStorageLocation()));
        RetrievableStateHandle retrievableStateHandle2 = (RetrievableStateHandle)Mockito.mock(RetrievableStateHandle.class);
        Mockito.when((Object)retrievableStateHandle2.retrieveState()).then(invocation -> new CompletedCheckpoint(jobID, 2L, 2L, 2L, new HashMap(), null, CheckpointProperties.forCheckpoint((CheckpointRetentionPolicy)CheckpointRetentionPolicy.NEVER_RETAIN_AFTER_TERMINATION), (CompletedCheckpointStorageLocation)new TestCompletedCheckpointStorageLocation()));
        checkpointsInZooKeeper.add(Tuple2.of((Object)retrievableStateHandle1, (Object)"/foobar1"));
        checkpointsInZooKeeper.add(Tuple2.of((Object)failingRetrievableStateHandle, (Object)"/failing1"));
        checkpointsInZooKeeper.add(Tuple2.of((Object)retrievableStateHandle2, (Object)"/foobar2"));
        checkpointsInZooKeeper.add(Tuple2.of((Object)failingRetrievableStateHandle, (Object)"/failing2"));
        final CuratorFramework client = (CuratorFramework)Mockito.mock(CuratorFramework.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        RetrievableStateStorageHelper storageHelperMock = (RetrievableStateStorageHelper)Mockito.mock(RetrievableStateStorageHelper.class);
        ZooKeeperStateHandleStore zooKeeperStateHandleStoreMock = (ZooKeeperStateHandleStore)Mockito.spy((Object)new ZooKeeperStateHandleStore(client, storageHelperMock));
        ((ZooKeeperStateHandleStore)Mockito.doReturn(checkpointsInZooKeeper).when((Object)zooKeeperStateHandleStoreMock)).getAllAndLock();
        boolean numCheckpointsToRetain = true;
        EnsurePath ensurePathMock = (EnsurePath)Mockito.mock(EnsurePath.class);
        final CuratorEvent curatorEventMock = (CuratorEvent)Mockito.mock(CuratorEvent.class);
        Mockito.when((Object)curatorEventMock.getType()).thenReturn((Object)CuratorEventType.DELETE);
        Mockito.when((Object)curatorEventMock.getResultCode()).thenReturn((Object)0);
        Mockito.when((Object)client.newNamespaceAwareEnsurePath(Matchers.anyString())).thenReturn((Object)ensurePathMock);
        Mockito.when((Object)client.delete().inBackground((BackgroundCallback)Matchers.any(BackgroundCallback.class), (Executor)Matchers.any(Executor.class))).thenAnswer((Answer)new Answer<ErrorListenerPathable<Void>>(){

            public ErrorListenerPathable<Void> answer(InvocationOnMock invocation) throws Throwable {
                final BackgroundCallback callback = (BackgroundCallback)invocation.getArguments()[0];
                ErrorListenerPathable result = (ErrorListenerPathable)Mockito.mock(ErrorListenerPathable.class);
                Mockito.when((Object)result.forPath(Matchers.anyString())).thenAnswer((Answer)new Answer<Void>(){

                    public Void answer(InvocationOnMock invocation) throws Throwable {
                        callback.processResult(client, curatorEventMock);
                        return null;
                    }
                });
                return result;
            }
        });
        ZooKeeperCompletedCheckpointStore zooKeeperCompletedCheckpointStore = new ZooKeeperCompletedCheckpointStore(1, zooKeeperStateHandleStoreMock, Executors.directExecutor());
        zooKeeperCompletedCheckpointStore.recover();
        CompletedCheckpoint latestCompletedCheckpoint = zooKeeperCompletedCheckpointStore.getLatestCheckpoint(false);
        Assert.assertEquals((long)2L, (long)latestCompletedCheckpoint.getCheckpointID());
        List completedCheckpoints = zooKeeperCompletedCheckpointStore.getAllCheckpoints();
        HashSet<Long> actualCheckpointIds = new HashSet<Long>(completedCheckpoints.size());
        for (CompletedCheckpoint completedCheckpoint : completedCheckpoints) {
            actualCheckpointIds.add(completedCheckpoint.getCheckpointID());
        }
        Assert.assertEquals(expectedCheckpointIds, actualCheckpointIds);
        ((RetrievableStateHandle)Mockito.verify((Object)retrievableStateHandle1, (VerificationMode)Mockito.never())).discardState();
        ((RetrievableStateHandle)Mockito.verify((Object)retrievableStateHandle2, (VerificationMode)Mockito.never())).discardState();
        ((RetrievableStateHandle)Mockito.verify((Object)failingRetrievableStateHandle, (VerificationMode)Mockito.never())).discardState();
    }

    @Test(timeout=50000L)
    public void testCheckpointRecoveryPreferCheckpoint() throws Exception {
        JobID jobID = new JobID();
        long checkpoint1Id = 1L;
        long checkpoint2Id = 2L;
        ArrayList<Tuple2> checkpointsInZooKeeper = new ArrayList<Tuple2>(4);
        HashSet<Long> expectedCheckpointIds = new HashSet<Long>(2);
        expectedCheckpointIds.add(1L);
        expectedCheckpointIds.add(2L);
        RetrievableStateHandle failingRetrievableStateHandle = (RetrievableStateHandle)Mockito.mock(RetrievableStateHandle.class);
        Mockito.when((Object)failingRetrievableStateHandle.retrieveState()).thenThrow(new Throwable[]{new IOException("Test exception")});
        RetrievableStateHandle retrievableStateHandle1 = (RetrievableStateHandle)Mockito.mock(RetrievableStateHandle.class);
        Mockito.when((Object)retrievableStateHandle1.retrieveState()).then(invocation -> new CompletedCheckpoint(jobID, 1L, 1L, 1L, new HashMap(), null, CheckpointProperties.forCheckpoint((CheckpointRetentionPolicy)CheckpointRetentionPolicy.NEVER_RETAIN_AFTER_TERMINATION), (CompletedCheckpointStorageLocation)new TestCompletedCheckpointStorageLocation()));
        RetrievableStateHandle retrievableStateHandle2 = (RetrievableStateHandle)Mockito.mock(RetrievableStateHandle.class);
        Mockito.when((Object)retrievableStateHandle2.retrieveState()).then(invocation -> new CompletedCheckpoint(jobID, 2L, 2L, 2L, new HashMap(), null, CheckpointProperties.forSavepoint((boolean)true), (CompletedCheckpointStorageLocation)new TestCompletedCheckpointStorageLocation()));
        checkpointsInZooKeeper.add(Tuple2.of((Object)retrievableStateHandle1, (Object)"/foobar1"));
        checkpointsInZooKeeper.add(Tuple2.of((Object)failingRetrievableStateHandle, (Object)"/failing1"));
        checkpointsInZooKeeper.add(Tuple2.of((Object)retrievableStateHandle2, (Object)"/foobar2"));
        checkpointsInZooKeeper.add(Tuple2.of((Object)failingRetrievableStateHandle, (Object)"/failing2"));
        final CuratorFramework client = (CuratorFramework)Mockito.mock(CuratorFramework.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        RetrievableStateStorageHelper storageHelperMock = (RetrievableStateStorageHelper)Mockito.mock(RetrievableStateStorageHelper.class);
        ZooKeeperStateHandleStore zooKeeperStateHandleStoreMock = (ZooKeeperStateHandleStore)Mockito.spy((Object)new ZooKeeperStateHandleStore(client, storageHelperMock));
        ((ZooKeeperStateHandleStore)Mockito.doReturn(checkpointsInZooKeeper).when((Object)zooKeeperStateHandleStoreMock)).getAllAndLock();
        boolean numCheckpointsToRetain = true;
        EnsurePath ensurePathMock = (EnsurePath)Mockito.mock(EnsurePath.class);
        final CuratorEvent curatorEventMock = (CuratorEvent)Mockito.mock(CuratorEvent.class);
        Mockito.when((Object)curatorEventMock.getType()).thenReturn((Object)CuratorEventType.DELETE);
        Mockito.when((Object)curatorEventMock.getResultCode()).thenReturn((Object)0);
        Mockito.when((Object)client.newNamespaceAwareEnsurePath(Matchers.anyString())).thenReturn((Object)ensurePathMock);
        Mockito.when((Object)client.delete().inBackground((BackgroundCallback)Matchers.any(BackgroundCallback.class), (Executor)Matchers.any(Executor.class))).thenAnswer((Answer)new Answer<ErrorListenerPathable<Void>>(){

            public ErrorListenerPathable<Void> answer(InvocationOnMock invocation) throws Throwable {
                final BackgroundCallback callback = (BackgroundCallback)invocation.getArguments()[0];
                ErrorListenerPathable result = (ErrorListenerPathable)Mockito.mock(ErrorListenerPathable.class);
                Mockito.when((Object)result.forPath(Matchers.anyString())).thenAnswer((Answer)new Answer<Void>(){

                    public Void answer(InvocationOnMock invocation) throws Throwable {
                        callback.processResult(client, curatorEventMock);
                        return null;
                    }
                });
                return result;
            }
        });
        ZooKeeperCompletedCheckpointStore zooKeeperCompletedCheckpointStore = new ZooKeeperCompletedCheckpointStore(1, zooKeeperStateHandleStoreMock, Executors.directExecutor());
        zooKeeperCompletedCheckpointStore.recover();
        CompletedCheckpoint latestCompletedCheckpoint = zooKeeperCompletedCheckpointStore.getLatestCheckpoint(true);
        Assert.assertEquals((long)1L, (long)latestCompletedCheckpoint.getCheckpointID());
        List completedCheckpoints = zooKeeperCompletedCheckpointStore.getAllCheckpoints();
        HashSet<Long> actualCheckpointIds = new HashSet<Long>(completedCheckpoints.size());
        for (CompletedCheckpoint completedCheckpoint : completedCheckpoints) {
            actualCheckpointIds.add(completedCheckpoint.getCheckpointID());
        }
        Assert.assertEquals(expectedCheckpointIds, actualCheckpointIds);
        ((RetrievableStateHandle)Mockito.verify((Object)retrievableStateHandle1, (VerificationMode)Mockito.never())).discardState();
        ((RetrievableStateHandle)Mockito.verify((Object)retrievableStateHandle2, (VerificationMode)Mockito.never())).discardState();
        ((RetrievableStateHandle)Mockito.verify((Object)failingRetrievableStateHandle, (VerificationMode)Mockito.never())).discardState();
    }

    @Test
    public void testAddCheckpointWithFailedRemove() throws Exception {
        CuratorFramework client = (CuratorFramework)Mockito.mock(CuratorFramework.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        RetrievableStateStorageHelper storageHelperMock = (RetrievableStateStorageHelper)Mockito.mock(RetrievableStateStorageHelper.class);
        ZooKeeperStateHandleStore zookeeperStateHandleStoreMock = (ZooKeeperStateHandleStore)Mockito.spy((Object)new ZooKeeperStateHandleStore(client, storageHelperMock));
        ((ZooKeeperStateHandleStore)Mockito.doAnswer((Answer)new Answer<RetrievableStateHandle<CompletedCheckpoint>>(){

            public RetrievableStateHandle<CompletedCheckpoint> answer(InvocationOnMock invocationOnMock) throws Throwable {
                CompletedCheckpoint checkpoint = (CompletedCheckpoint)invocationOnMock.getArguments()[1];
                RetrievableStateHandle retrievableStateHandle = (RetrievableStateHandle)Mockito.mock(RetrievableStateHandle.class);
                Mockito.when((Object)retrievableStateHandle.retrieveState()).thenReturn((Object)checkpoint);
                return retrievableStateHandle;
            }
        }).when((Object)zookeeperStateHandleStoreMock)).addAndLock(Matchers.anyString(), (Serializable)Matchers.any(CompletedCheckpoint.class));
        ((ZooKeeperStateHandleStore)Mockito.doThrow((Throwable[])new Throwable[]{new Exception()}).when((Object)zookeeperStateHandleStoreMock)).releaseAndTryRemove(Matchers.anyString());
        boolean numCheckpointsToRetain = true;
        ZooKeeperCompletedCheckpointStore zooKeeperCompletedCheckpointStore = new ZooKeeperCompletedCheckpointStore(1, zookeeperStateHandleStoreMock, Executors.directExecutor());
        for (long i = 0L; i <= 1L; ++i) {
            CompletedCheckpoint checkpointToAdd = (CompletedCheckpoint)Mockito.mock(CompletedCheckpoint.class);
            ((CompletedCheckpoint)Mockito.doReturn((Object)i).when((Object)checkpointToAdd)).getCheckpointID();
            ((CompletedCheckpoint)Mockito.doReturn(Collections.emptyMap()).when((Object)checkpointToAdd)).getOperatorStates();
            try {
                zooKeeperCompletedCheckpointStore.addCheckpoint(checkpointToAdd);
                List addedCheckpoints = zooKeeperCompletedCheckpointStore.getAllCheckpoints();
                Assert.assertTrue((boolean)addedCheckpoints.contains(checkpointToAdd));
                continue;
            }
            catch (Exception e) {
                List addedCheckpoints = zooKeeperCompletedCheckpointStore.getAllCheckpoints();
                Assert.assertFalse((boolean)addedCheckpoints.contains(checkpointToAdd));
            }
        }
    }
}

