/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.io.Serializable;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.runtime.checkpoint.SubtaskStateStats;
import org.apache.flink.runtime.checkpoint.TaskStateStats;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.junit.Assert;
import org.junit.Test;

public class TaskStateStatsTest {
    private final ThreadLocalRandom rand = ThreadLocalRandom.current();

    @Test
    public void testHandInSubtasks() throws Exception {
        JobVertexID jobVertexId = new JobVertexID();
        Object[] subtasks = new SubtaskStateStats[7];
        TaskStateStats taskStats = new TaskStateStats(jobVertexId, subtasks.length);
        Assert.assertEquals((Object)jobVertexId, (Object)taskStats.getJobVertexId());
        Assert.assertEquals((long)subtasks.length, (long)taskStats.getNumberOfSubtasks());
        Assert.assertEquals((long)0L, (long)taskStats.getNumberOfAcknowledgedSubtasks());
        Assert.assertNull((Object)taskStats.getLatestAcknowledgedSubtaskStats());
        Assert.assertEquals((long)-1L, (long)taskStats.getLatestAckTimestamp());
        Assert.assertArrayEquals((Object[])subtasks, (Object[])taskStats.getSubtaskStats());
        long stateSize = 0L;
        for (int i = 0; i < subtasks.length; ++i) {
            subtasks[i] = new SubtaskStateStats(i, (long)this.rand.nextInt(128), (long)this.rand.nextInt(128), (long)this.rand.nextInt(128), (long)this.rand.nextInt(128), (long)this.rand.nextInt(128), (long)this.rand.nextInt(128));
            stateSize += subtasks[i].getStateSize();
            Assert.assertTrue((boolean)taskStats.reportSubtaskStats((SubtaskStateStats)subtasks[i]));
            Assert.assertEquals((long)(i + 1), (long)taskStats.getNumberOfAcknowledgedSubtasks());
            Assert.assertEquals((Object)subtasks[i], (Object)taskStats.getLatestAcknowledgedSubtaskStats());
            Assert.assertEquals((long)subtasks[i].getAckTimestamp(), (long)taskStats.getLatestAckTimestamp());
            int duration = this.rand.nextInt(128);
            Assert.assertEquals((long)duration, (long)taskStats.getEndToEndDuration(subtasks[i].getAckTimestamp() - (long)duration));
            Assert.assertEquals((long)stateSize, (long)taskStats.getStateSize());
        }
        Assert.assertFalse((boolean)taskStats.reportSubtaskStats(new SubtaskStateStats(0, 0L, 0L, 0L, 0L, 0L, 0L)));
        TaskStateStats.TaskStateStatsSummary summary = taskStats.getSummaryStats();
        Assert.assertEquals((long)subtasks.length, (long)summary.getStateSizeStats().getCount());
        Assert.assertEquals((long)subtasks.length, (long)summary.getAckTimestampStats().getCount());
        Assert.assertEquals((long)subtasks.length, (long)summary.getSyncCheckpointDurationStats().getCount());
        Assert.assertEquals((long)subtasks.length, (long)summary.getAsyncCheckpointDurationStats().getCount());
        Assert.assertEquals((long)subtasks.length, (long)summary.getAlignmentDurationStats().getCount());
    }

    @Test
    public void testIsJavaSerializable() throws Exception {
        JobVertexID jobVertexId = new JobVertexID();
        SubtaskStateStats[] subtasks = new SubtaskStateStats[7];
        TaskStateStats taskStats = new TaskStateStats(jobVertexId, subtasks.length);
        long stateSize = 0L;
        for (int i = 0; i < subtasks.length; ++i) {
            subtasks[i] = new SubtaskStateStats(i, (long)this.rand.nextInt(128), (long)this.rand.nextInt(128), (long)this.rand.nextInt(128), (long)this.rand.nextInt(128), (long)this.rand.nextInt(128), (long)this.rand.nextInt(128));
            stateSize += subtasks[i].getStateSize();
            taskStats.reportSubtaskStats(subtasks[i]);
        }
        TaskStateStats copy = (TaskStateStats)CommonTestUtils.createCopySerializable((Serializable)taskStats);
        Assert.assertEquals((long)stateSize, (long)copy.getStateSize());
        TaskStateStats.TaskStateStatsSummary summary = copy.getSummaryStats();
        Assert.assertEquals((long)subtasks.length, (long)summary.getStateSizeStats().getCount());
        Assert.assertEquals((long)subtasks.length, (long)summary.getAckTimestampStats().getCount());
        Assert.assertEquals((long)subtasks.length, (long)summary.getSyncCheckpointDurationStats().getCount());
        Assert.assertEquals((long)subtasks.length, (long)summary.getAsyncCheckpointDurationStats().getCount());
        Assert.assertEquals((long)subtasks.length, (long)summary.getAlignmentDurationStats().getCount());
    }
}

