/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.Arrays;
import java.util.Collections;
import org.apache.flink.runtime.checkpoint.OperatorSubtaskState;
import org.apache.flink.runtime.checkpoint.StateObjectCollection;
import org.apache.flink.runtime.checkpoint.channel.InputChannelInfo;
import org.apache.flink.runtime.checkpoint.channel.ResultSubpartitionInfo;
import org.apache.flink.runtime.state.InputChannelStateHandle;
import org.apache.flink.runtime.state.ResultSubpartitionStateHandle;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.runtime.state.memory.ByteStreamStateHandle;
import org.junit.Assert;
import org.junit.Test;

public class OperatorSubtaskStateTest {
    @Test
    public void testDiscardDuplicatedDelegatesOnce() {
        DiscardOnceStreamStateHandle delegate = new DiscardOnceStreamStateHandle();
        new OperatorSubtaskState(StateObjectCollection.empty(), StateObjectCollection.empty(), StateObjectCollection.empty(), StateObjectCollection.empty(), new StateObjectCollection(Arrays.asList(this.buildInputChannelHandle((StreamStateHandle)delegate, 1), this.buildInputChannelHandle((StreamStateHandle)delegate, 2))), new StateObjectCollection(Arrays.asList(this.buildSubpartitionHandle((StreamStateHandle)delegate, 4), this.buildSubpartitionHandle((StreamStateHandle)delegate, 3)))).discardState();
    }

    private ResultSubpartitionStateHandle buildSubpartitionHandle(StreamStateHandle delegate, int subPartitionIdx1) {
        return new ResultSubpartitionStateHandle(new ResultSubpartitionInfo(0, subPartitionIdx1), delegate, Collections.singletonList(0L));
    }

    private InputChannelStateHandle buildInputChannelHandle(StreamStateHandle delegate, int inputChannelIdx) {
        return new InputChannelStateHandle(new InputChannelInfo(0, inputChannelIdx), delegate, Collections.singletonList(0L));
    }

    private static class DiscardOnceStreamStateHandle
    extends ByteStreamStateHandle {
        private static final long serialVersionUID = 1L;
        private boolean discarded = false;

        DiscardOnceStreamStateHandle() {
            super("test", new byte[0]);
        }

        public void discardState() {
            super.discardState();
            Assert.assertFalse((String)"state was discarded twice", (boolean)this.discarded);
            this.discarded = true;
        }
    }
}

