/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.Collections;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.checkpoint.CheckpointCoordinator;
import org.apache.flink.runtime.checkpoint.CheckpointException;
import org.apache.flink.runtime.checkpoint.CheckpointFailureManager;
import org.apache.flink.runtime.checkpoint.CheckpointFailureReason;
import org.apache.flink.runtime.checkpoint.CheckpointIDCounter;
import org.apache.flink.runtime.checkpoint.CheckpointRetentionPolicy;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStore;
import org.apache.flink.runtime.checkpoint.StandaloneCheckpointIDCounter;
import org.apache.flink.runtime.checkpoint.StandaloneCompletedCheckpointStore;
import org.apache.flink.runtime.concurrent.Executors;
import org.apache.flink.runtime.concurrent.ManuallyTriggeredScheduledExecutor;
import org.apache.flink.runtime.concurrent.ScheduledExecutor;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.Execution;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.jobgraph.tasks.CheckpointCoordinatorConfiguration;
import org.apache.flink.runtime.state.SharedStateRegistry;
import org.apache.flink.runtime.state.StateBackend;
import org.apache.flink.runtime.state.memory.MemoryStateBackend;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.powermock.api.mockito.PowerMockito;

public class FailoverStrategyCheckpointCoordinatorTest
extends TestLogger {
    private ManuallyTriggeredScheduledExecutor manualThreadExecutor;

    @Before
    public void setUp() {
        this.manualThreadExecutor = new ManuallyTriggeredScheduledExecutor();
    }

    @Test
    public void testAbortPendingCheckpointsWithTriggerValidation() {
        int maxConcurrentCheckpoints = ThreadLocalRandom.current().nextInt(10) + 1;
        ExecutionVertex executionVertex = this.mockExecutionVertex();
        CheckpointCoordinatorConfiguration checkpointCoordinatorConfiguration = new CheckpointCoordinatorConfiguration(Integer.MAX_VALUE, Integer.MAX_VALUE, 0L, maxConcurrentCheckpoints, CheckpointRetentionPolicy.NEVER_RETAIN_AFTER_TERMINATION, true, false, false, 0);
        CheckpointCoordinator checkpointCoordinator = new CheckpointCoordinator(new JobID(), checkpointCoordinatorConfiguration, new ExecutionVertex[]{executionVertex}, new ExecutionVertex[]{executionVertex}, new ExecutionVertex[]{executionVertex}, Collections.emptyList(), (CheckpointIDCounter)new StandaloneCheckpointIDCounter(), (CompletedCheckpointStore)new StandaloneCompletedCheckpointStore(1), (StateBackend)new MemoryStateBackend(), Executors.directExecutor(), (ScheduledExecutor)this.manualThreadExecutor, SharedStateRegistry.DEFAULT_FACTORY, (CheckpointFailureManager)Mockito.mock(CheckpointFailureManager.class));
        this.mockExecutionRunning(executionVertex);
        checkpointCoordinator.startCheckpointScheduler();
        Assert.assertTrue((boolean)checkpointCoordinator.isCurrentPeriodicTriggerAvailable());
        this.manualThreadExecutor.triggerPeriodicScheduledTasks();
        this.manualThreadExecutor.triggerAll();
        Assert.assertEquals((long)1L, (long)checkpointCoordinator.getNumberOfPendingCheckpoints());
        for (int i = 1; i < maxConcurrentCheckpoints; ++i) {
            checkpointCoordinator.triggerCheckpoint(false);
            this.manualThreadExecutor.triggerAll();
            Assert.assertEquals((long)(i + 1), (long)checkpointCoordinator.getNumberOfPendingCheckpoints());
            Assert.assertTrue((boolean)checkpointCoordinator.isCurrentPeriodicTriggerAvailable());
        }
        checkpointCoordinator.triggerCheckpoint(false);
        this.manualThreadExecutor.triggerAll();
        Assert.assertEquals((long)maxConcurrentCheckpoints, (long)checkpointCoordinator.getNumberOfPendingCheckpoints());
        checkpointCoordinator.abortPendingCheckpoints(new CheckpointException(CheckpointFailureReason.JOB_FAILOVER_REGION));
        Assert.assertTrue((boolean)checkpointCoordinator.isCurrentPeriodicTriggerAvailable());
        Assert.assertEquals((long)0L, (long)checkpointCoordinator.getNumberOfPendingCheckpoints());
    }

    private ExecutionVertex mockExecutionVertex() {
        ExecutionAttemptID executionAttemptID = new ExecutionAttemptID();
        ExecutionVertex executionVertex = (ExecutionVertex)Mockito.mock(ExecutionVertex.class);
        Execution execution = (Execution)Mockito.mock(Execution.class);
        PowerMockito.when((Object)execution.getAttemptId()).thenReturn((Object)executionAttemptID);
        PowerMockito.when((Object)executionVertex.getCurrentExecutionAttempt()).thenReturn((Object)execution);
        return executionVertex;
    }

    private void mockExecutionRunning(ExecutionVertex executionVertex) {
        PowerMockito.when((Object)executionVertex.getCurrentExecutionAttempt().getState()).thenReturn((Object)ExecutionState.RUNNING);
    }
}

