/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.CloseableRegistry;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.groups.UnregisteredMetricsGroup;
import org.apache.flink.runtime.blob.BlobWriter;
import org.apache.flink.runtime.blob.VoidBlobWriter;
import org.apache.flink.runtime.checkpoint.CheckpointRecoveryFactory;
import org.apache.flink.runtime.checkpoint.CheckpointRetentionPolicy;
import org.apache.flink.runtime.checkpoint.MasterTriggerRestoreHook;
import org.apache.flink.runtime.checkpoint.StandaloneCheckpointRecoveryFactory;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionGraphBuilder;
import org.apache.flink.runtime.executiongraph.restart.NoRestartStrategy;
import org.apache.flink.runtime.executiongraph.restart.RestartStrategy;
import org.apache.flink.runtime.io.network.partition.JobMasterPartitionTracker;
import org.apache.flink.runtime.io.network.partition.NoOpJobMasterPartitionTracker;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.tasks.CheckpointCoordinatorConfiguration;
import org.apache.flink.runtime.jobgraph.tasks.JobCheckpointingSettings;
import org.apache.flink.runtime.jobmaster.slotpool.SlotProvider;
import org.apache.flink.runtime.query.TaskKvStateRegistry;
import org.apache.flink.runtime.shuffle.NettyShuffleMaster;
import org.apache.flink.runtime.shuffle.ShuffleMaster;
import org.apache.flink.runtime.state.AbstractKeyedStateBackend;
import org.apache.flink.runtime.state.CheckpointStorage;
import org.apache.flink.runtime.state.CompletedCheckpointStorageLocation;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.KeyedStateHandle;
import org.apache.flink.runtime.state.OperatorStateBackend;
import org.apache.flink.runtime.state.OperatorStateHandle;
import org.apache.flink.runtime.state.StateBackend;
import org.apache.flink.runtime.state.ttl.TtlTimeProvider;
import org.apache.flink.runtime.testingUtils.TestingUtils;
import org.apache.flink.testutils.ClassLoaderUtils;
import org.apache.flink.util.SerializedValue;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;

public class CheckpointSettingsSerializableTest
extends TestLogger {
    @Test
    public void testDeserializationOfUserCodeWithUserClassLoader() throws Exception {
        ClassLoaderUtils.ObjectAndClassLoader outsideClassLoading = ClassLoaderUtils.createSerializableObjectFromNewClassLoader();
        ClassLoader classLoader = outsideClassLoading.getClassLoader();
        Serializable outOfClassPath = (Serializable)outsideClassLoading.getObject();
        MasterTriggerRestoreHook.Factory[] hooks = new MasterTriggerRestoreHook.Factory[]{new TestFactory(outOfClassPath)};
        SerializedValue serHooks = new SerializedValue((Object)hooks);
        JobCheckpointingSettings checkpointingSettings = new JobCheckpointingSettings(Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), new CheckpointCoordinatorConfiguration(1000L, 10000L, 0L, 1, CheckpointRetentionPolicy.NEVER_RETAIN_AFTER_TERMINATION, true, false, false, 0), new SerializedValue((Object)new CustomStateBackend(outOfClassPath)), serHooks);
        JobGraph jobGraph = new JobGraph(new JobID(), "test job");
        jobGraph.setSnapshotSettings(checkpointingSettings);
        JobGraph copy = (JobGraph)CommonTestUtils.createCopySerializable((Serializable)jobGraph);
        Time timeout = Time.seconds((long)10L);
        ExecutionGraph eg = ExecutionGraphBuilder.buildGraph(null, (JobGraph)copy, (Configuration)new Configuration(), (ScheduledExecutorService)TestingUtils.defaultExecutor(), (Executor)TestingUtils.defaultExecutor(), (SlotProvider)((SlotProvider)Mockito.mock(SlotProvider.class)), (ClassLoader)classLoader, (CheckpointRecoveryFactory)new StandaloneCheckpointRecoveryFactory(), (Time)timeout, (RestartStrategy)new NoRestartStrategy(), (MetricGroup)new UnregisteredMetricsGroup(), (BlobWriter)VoidBlobWriter.getInstance(), (Time)timeout, (Logger)this.log, (ShuffleMaster)NettyShuffleMaster.INSTANCE, (JobMasterPartitionTracker)NoOpJobMasterPartitionTracker.INSTANCE);
        Assert.assertEquals((long)1L, (long)eg.getCheckpointCoordinator().getNumberOfRegisteredMasterHooks());
        Assert.assertTrue((boolean)(jobGraph.getCheckpointingSettings().getDefaultStateBackend().deserializeValue(classLoader) instanceof CustomStateBackend));
    }

    private static final class CustomStateBackend
    implements StateBackend {
        private static final long serialVersionUID = -6107964383429395816L;
        private Serializable customOption;

        public CustomStateBackend(Serializable customOption) {
            this.customOption = customOption;
        }

        public CompletedCheckpointStorageLocation resolveCheckpoint(String pointer) throws IOException {
            throw new UnsupportedOperationException();
        }

        public CheckpointStorage createCheckpointStorage(JobID jobId) throws IOException {
            return (CheckpointStorage)Mockito.mock(CheckpointStorage.class);
        }

        public <K> AbstractKeyedStateBackend<K> createKeyedStateBackend(Environment env, JobID jobID, String operatorIdentifier, TypeSerializer<K> keySerializer, int numberOfKeyGroups, KeyGroupRange keyGroupRange, TaskKvStateRegistry kvStateRegistry, TtlTimeProvider ttlTimeProvider, MetricGroup metricGroup, @Nonnull Collection<KeyedStateHandle> stateHandles, CloseableRegistry cancelStreamRegistry) throws Exception {
            throw new UnsupportedOperationException();
        }

        public OperatorStateBackend createOperatorStateBackend(Environment env, String operatorIdentifier, @Nonnull Collection<OperatorStateHandle> stateHandles, CloseableRegistry cancelStreamRegistry) throws Exception {
            throw new UnsupportedOperationException();
        }
    }

    private static final class TestFactory
    implements MasterTriggerRestoreHook.Factory {
        private static final long serialVersionUID = -612969579110202607L;
        private final Serializable payload;

        TestFactory(Serializable payload) {
            this.payload = payload;
        }

        public <V> MasterTriggerRestoreHook<V> create() {
            MasterTriggerRestoreHook hook = (MasterTriggerRestoreHook)Mockito.mock(MasterTriggerRestoreHook.class);
            Mockito.when((Object)hook.getIdentifier()).thenReturn((Object)"id");
            return hook;
        }
    }
}

