/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.io.Serializable;
import java.util.Random;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.runtime.checkpoint.CheckpointOptions;
import org.apache.flink.runtime.checkpoint.CheckpointType;
import org.apache.flink.runtime.state.CheckpointStorageLocationReference;
import org.junit.Assert;
import org.junit.Test;

public class CheckpointOptionsTest {
    @Test
    public void testDefaultCheckpoint() throws Exception {
        CheckpointOptions options = CheckpointOptions.forCheckpointWithDefaultLocation();
        Assert.assertEquals((Object)CheckpointType.CHECKPOINT, (Object)options.getCheckpointType());
        Assert.assertTrue((boolean)options.getTargetLocation().isDefaultReference());
        CheckpointOptions copy = (CheckpointOptions)CommonTestUtils.createCopySerializable((Serializable)options);
        Assert.assertEquals((Object)CheckpointType.CHECKPOINT, (Object)copy.getCheckpointType());
        Assert.assertTrue((boolean)copy.getTargetLocation().isDefaultReference());
    }

    @Test
    public void testSavepoint() throws Exception {
        Random rnd = new Random();
        byte[] locationBytes = new byte[rnd.nextInt(41) + 1];
        rnd.nextBytes(locationBytes);
        CheckpointOptions options = new CheckpointOptions(CheckpointType.values()[rnd.nextInt(CheckpointType.values().length)], new CheckpointStorageLocationReference(locationBytes));
        CheckpointOptions copy = (CheckpointOptions)CommonTestUtils.createCopySerializable((Serializable)options);
        Assert.assertEquals((Object)options.getCheckpointType(), (Object)copy.getCheckpointType());
        Assert.assertArrayEquals((byte[])locationBytes, (byte[])copy.getTargetLocation().getReferenceBytes());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSavepointNeedsAlignment() {
        new CheckpointOptions(CheckpointType.SAVEPOINT, CheckpointStorageLocationReference.getDefault(), CheckpointOptions.AlignmentType.UNALIGNED);
    }

    @Test
    public void testCheckpointNeedsAlignment() {
        CheckpointStorageLocationReference location = CheckpointStorageLocationReference.getDefault();
        Assert.assertFalse((boolean)new CheckpointOptions(CheckpointType.CHECKPOINT, location, CheckpointOptions.AlignmentType.UNALIGNED).needsAlignment());
        Assert.assertTrue((boolean)new CheckpointOptions(CheckpointType.CHECKPOINT, location, CheckpointOptions.AlignmentType.ALIGNED).needsAlignment());
        Assert.assertTrue((boolean)new CheckpointOptions(CheckpointType.CHECKPOINT, location, CheckpointOptions.AlignmentType.FORCED_ALIGNED).needsAlignment());
        Assert.assertFalse((boolean)new CheckpointOptions(CheckpointType.CHECKPOINT, location, CheckpointOptions.AlignmentType.AT_LEAST_ONCE).needsAlignment());
    }

    @Test
    public void testForceAlignmentIsReversable() {
        CheckpointStorageLocationReference location = CheckpointStorageLocationReference.getDefault();
        this.assertReversable(CheckpointOptions.unaligned((CheckpointStorageLocationReference)location), true);
        this.assertReversable(CheckpointOptions.aligned((CheckpointType)CheckpointType.CHECKPOINT, (CheckpointStorageLocationReference)location), false);
        this.assertReversable(CheckpointOptions.aligned((CheckpointType)CheckpointType.SAVEPOINT, (CheckpointStorageLocationReference)location), false);
        this.assertReversable(CheckpointOptions.notExactlyOnce((CheckpointType)CheckpointType.CHECKPOINT, (CheckpointStorageLocationReference)location), false);
        this.assertReversable(CheckpointOptions.notExactlyOnce((CheckpointType)CheckpointType.SAVEPOINT, (CheckpointStorageLocationReference)location), false);
    }

    private void assertReversable(CheckpointOptions options, boolean forceHasEffect) {
        Assert.assertEquals((String)"all non-forced options support unaligned mode", (Object)options, (Object)options.withUnalignedSupported());
        CheckpointOptions unalignedUnsupported = options.withUnalignedUnsupported();
        if (forceHasEffect) {
            Assert.assertNotEquals((String)"expected changes in the options", (Object)options, (Object)unalignedUnsupported);
        } else {
            Assert.assertEquals((String)"not expected changes to the options", (Object)options, (Object)unalignedUnsupported);
        }
        Assert.assertEquals((String)"expected fully reversable options", (Object)options, (Object)unalignedUnsupported.withUnalignedSupported());
    }
}

