/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.blob;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.BlobServerOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.blob.BlobKey;
import org.apache.flink.runtime.blob.BlobKeyTest;
import org.apache.flink.runtime.blob.BlobServer;
import org.apache.flink.runtime.blob.BlobServerCleanupTest;
import org.apache.flink.runtime.blob.BlobServerGetTest;
import org.apache.flink.runtime.blob.BlobServerPutTest;
import org.apache.flink.runtime.blob.BlobService;
import org.apache.flink.runtime.blob.BlobStore;
import org.apache.flink.runtime.blob.PermanentBlobService;
import org.apache.flink.runtime.blob.TransientBlobKey;
import org.apache.flink.runtime.blob.VoidBlobStore;
import org.apache.flink.runtime.concurrent.FutureUtils;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.OperatingSystem;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class BlobServerDeleteTest
extends TestLogger {
    private final Random rnd = new Random();
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Test
    public void testDeleteTransient1() throws IOException {
        this.testDeleteTransient(null, new JobID());
    }

    @Test
    public void testDeleteTransient2() throws IOException {
        this.testDeleteTransient(new JobID(), null);
    }

    @Test
    public void testDeleteTransient3() throws IOException {
        this.testDeleteTransient(null, null);
    }

    @Test
    public void testDeleteTransient4() throws IOException {
        this.testDeleteTransient(new JobID(), new JobID());
    }

    @Test
    public void testDeleteTransient5() throws IOException {
        JobID jobId = new JobID();
        this.testDeleteTransient(jobId, jobId);
    }

    private void testDeleteTransient(@Nullable JobID jobId1, @Nullable JobID jobId2) throws IOException {
        Configuration config = new Configuration();
        config.setString(BlobServerOptions.STORAGE_DIRECTORY, this.temporaryFolder.newFolder().getAbsolutePath());
        try (BlobServer server = new BlobServer(config, (BlobStore)new VoidBlobStore());){
            server.start();
            byte[] data = new byte[2000000];
            this.rnd.nextBytes(data);
            byte[] data2 = Arrays.copyOf(data, data.length);
            data2[0] = (byte)(data2[0] ^ 1);
            TransientBlobKey key1 = (TransientBlobKey)BlobServerPutTest.put((BlobService)server, jobId1, data, BlobKey.BlobType.TRANSIENT_BLOB);
            Assert.assertNotNull((Object)key1);
            TransientBlobKey key2a = (TransientBlobKey)BlobServerPutTest.put((BlobService)server, jobId2, data, BlobKey.BlobType.TRANSIENT_BLOB);
            Assert.assertNotNull((Object)key2a);
            BlobKeyTest.verifyKeyDifferentHashEquals((BlobKey)key1, (BlobKey)key2a);
            TransientBlobKey key2b = (TransientBlobKey)BlobServerPutTest.put((BlobService)server, jobId2, data2, BlobKey.BlobType.TRANSIENT_BLOB);
            Assert.assertNotNull((Object)key2b);
            Assert.assertTrue((boolean)BlobServerDeleteTest.delete((BlobService)server, jobId1, key1));
            BlobServerGetTest.verifyDeleted((BlobService)server, jobId1, (BlobKey)key1);
            BlobServerPutTest.verifyContents((BlobService)server, jobId2, (BlobKey)key2a, data);
            BlobServerPutTest.verifyContents((BlobService)server, jobId2, (BlobKey)key2b, data2);
            Assert.assertTrue((boolean)BlobServerDeleteTest.delete((BlobService)server, jobId2, key2a));
            BlobServerGetTest.verifyDeleted((BlobService)server, jobId2, (BlobKey)key2a);
            BlobServerPutTest.verifyContents((BlobService)server, jobId2, (BlobKey)key2b, data2);
            Assert.assertTrue((boolean)BlobServerDeleteTest.delete((BlobService)server, jobId2, key2b));
            BlobServerGetTest.verifyDeleted((BlobService)server, jobId2, (BlobKey)key2b);
        }
    }

    @Test
    public void testDeleteTransientAlreadyDeletedNoJob() throws IOException {
        this.testDeleteTransientAlreadyDeleted(null);
    }

    @Test
    public void testDeleteTransientAlreadyDeletedForJob() throws IOException {
        this.testDeleteTransientAlreadyDeleted(new JobID());
    }

    private void testDeleteTransientAlreadyDeleted(@Nullable JobID jobId) throws IOException {
        Configuration config = new Configuration();
        config.setString(BlobServerOptions.STORAGE_DIRECTORY, this.temporaryFolder.newFolder().getAbsolutePath());
        try (BlobServer server = new BlobServer(config, (BlobStore)new VoidBlobStore());){
            server.start();
            byte[] data = new byte[2000000];
            this.rnd.nextBytes(data);
            TransientBlobKey key = (TransientBlobKey)BlobServerPutTest.put((BlobService)server, jobId, data, BlobKey.BlobType.TRANSIENT_BLOB);
            Assert.assertNotNull((Object)key);
            File blobFile = server.getStorageLocation(jobId, (BlobKey)key);
            Assert.assertTrue((boolean)blobFile.delete());
            Assert.assertTrue((boolean)BlobServerDeleteTest.delete((BlobService)server, jobId, key));
            BlobServerGetTest.verifyDeleted((BlobService)server, jobId, (BlobKey)key);
            Assert.assertTrue((boolean)BlobServerDeleteTest.delete((BlobService)server, jobId, key));
            BlobServerGetTest.verifyDeleted((BlobService)server, jobId, (BlobKey)key);
        }
    }

    @Test
    public void testDeleteTransientFailsNoJob() throws IOException {
        this.testDeleteTransientFails(null);
    }

    @Test
    public void testDeleteTransientFailsForJob() throws IOException {
        this.testDeleteTransientFails(new JobID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testDeleteTransientFails(@Nullable JobID jobId) throws IOException {
        Assume.assumeTrue((!OperatingSystem.isWindows() ? 1 : 0) != 0);
        Configuration config = new Configuration();
        config.setString(BlobServerOptions.STORAGE_DIRECTORY, this.temporaryFolder.newFolder().getAbsolutePath());
        File blobFile = null;
        File directory = null;
        try (BlobServer server = new BlobServer(config, (BlobStore)new VoidBlobStore());){
            server.start();
            try {
                byte[] data = new byte[2000000];
                this.rnd.nextBytes(data);
                TransientBlobKey key = (TransientBlobKey)BlobServerPutTest.put((BlobService)server, jobId, data, BlobKey.BlobType.TRANSIENT_BLOB);
                Assert.assertNotNull((Object)key);
                blobFile = server.getStorageLocation(jobId, (BlobKey)key);
                directory = blobFile.getParentFile();
                Assert.assertTrue((boolean)blobFile.setWritable(false, false));
                Assert.assertTrue((boolean)directory.setWritable(false, false));
                Assert.assertFalse((boolean)BlobServerDeleteTest.delete((BlobService)server, jobId, key));
                BlobServerPutTest.verifyContents((BlobService)server, jobId, (BlobKey)key, data);
            }
            finally {
                if (blobFile != null && directory != null) {
                    blobFile.setWritable(true, false);
                    directory.setWritable(true, false);
                }
            }
        }
    }

    @Test
    public void testJobCleanup() throws IOException, InterruptedException {
        this.testJobCleanup(BlobKey.BlobType.TRANSIENT_BLOB);
    }

    @Test
    public void testJobCleanupHa() throws IOException, InterruptedException {
        this.testJobCleanup(BlobKey.BlobType.PERMANENT_BLOB);
    }

    private void testJobCleanup(BlobKey.BlobType blobType) throws IOException {
        JobID jobId1 = new JobID();
        JobID jobId2 = new JobID();
        Configuration config = new Configuration();
        config.setString(BlobServerOptions.STORAGE_DIRECTORY, this.temporaryFolder.newFolder().getAbsolutePath());
        try (BlobServer server = new BlobServer(config, (BlobStore)new VoidBlobStore());){
            server.start();
            byte[] data = new byte[128];
            byte[] data2 = Arrays.copyOf(data, data.length);
            data2[0] = (byte)(data2[0] ^ 1);
            BlobKey key1a = BlobServerPutTest.put((BlobService)server, jobId1, data, blobType);
            BlobKey key2 = BlobServerPutTest.put((BlobService)server, jobId2, data, blobType);
            Assert.assertArrayEquals((byte[])key1a.getHash(), (byte[])key2.getHash());
            BlobKey key1b = BlobServerPutTest.put((BlobService)server, jobId1, data2, blobType);
            BlobServerPutTest.verifyContents((BlobService)server, jobId1, key1a, data);
            BlobServerPutTest.verifyContents((BlobService)server, jobId1, key1b, data2);
            BlobServerCleanupTest.checkFileCountForJob(2, jobId1, (PermanentBlobService)server);
            BlobServerPutTest.verifyContents((BlobService)server, jobId2, key2, data);
            BlobServerCleanupTest.checkFileCountForJob(1, jobId2, (PermanentBlobService)server);
            server.cleanupJob(jobId1, true);
            BlobServerGetTest.verifyDeleted((BlobService)server, jobId1, key1a);
            BlobServerGetTest.verifyDeleted((BlobService)server, jobId1, key1b);
            BlobServerCleanupTest.checkFileCountForJob(0, jobId1, (PermanentBlobService)server);
            BlobServerPutTest.verifyContents((BlobService)server, jobId2, key2, data);
            BlobServerCleanupTest.checkFileCountForJob(1, jobId2, (PermanentBlobService)server);
            server.cleanupJob(jobId2, true);
            BlobServerCleanupTest.checkFileCountForJob(0, jobId1, (PermanentBlobService)server);
            BlobServerGetTest.verifyDeleted((BlobService)server, jobId2, key2);
            BlobServerCleanupTest.checkFileCountForJob(0, jobId2, (PermanentBlobService)server);
            server.cleanupJob(jobId2, true);
        }
    }

    @Test
    public void testConcurrentDeleteOperationsNoJobTransient() throws IOException, ExecutionException, InterruptedException {
        this.testConcurrentDeleteOperations(null);
    }

    @Test
    public void testConcurrentDeleteOperationsForJobTransient() throws IOException, ExecutionException, InterruptedException {
        this.testConcurrentDeleteOperations(new JobID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testConcurrentDeleteOperations(@Nullable JobID jobId) throws IOException, InterruptedException, ExecutionException {
        Configuration config = new Configuration();
        config.setString(BlobServerOptions.STORAGE_DIRECTORY, this.temporaryFolder.newFolder().getAbsolutePath());
        int concurrentDeleteOperations = 3;
        ExecutorService executor = Executors.newFixedThreadPool(3);
        ArrayList<CompletableFuture<Void>> deleteFutures = new ArrayList<CompletableFuture<Void>>(3);
        byte[] data = new byte[]{1, 2, 3};
        try (BlobServer server = new BlobServer(config, (BlobStore)new VoidBlobStore());){
            server.start();
            TransientBlobKey blobKey = (TransientBlobKey)BlobServerPutTest.put((BlobService)server, jobId, data, BlobKey.BlobType.TRANSIENT_BLOB);
            Assert.assertTrue((boolean)server.getStorageLocation(jobId, (BlobKey)blobKey).exists());
            for (int i = 0; i < 3; ++i) {
                CompletableFuture<Void> deleteFuture = CompletableFuture.supplyAsync(() -> {
                    try {
                        Assert.assertTrue((boolean)BlobServerDeleteTest.delete((BlobService)server, jobId, blobKey));
                        Assert.assertFalse((boolean)server.getStorageLocation(jobId, (BlobKey)blobKey).exists());
                        return null;
                    }
                    catch (IOException e) {
                        throw new CompletionException((Throwable)new FlinkException("Could not delete the given blob key " + blobKey + '.'));
                    }
                }, executor);
                deleteFutures.add(deleteFuture);
            }
            FutureUtils.ConjunctFuture waitFuture = FutureUtils.waitForAll(deleteFutures);
            waitFuture.get();
            Assert.assertFalse((boolean)server.getStorageLocation(jobId, (BlobKey)blobKey).exists());
        }
        finally {
            executor.shutdownNow();
        }
    }

    static boolean delete(BlobService service, @Nullable JobID jobId, TransientBlobKey key) {
        if (jobId == null) {
            return service.getTransientBlobService().deleteFromCache(key);
        }
        return service.getTransientBlobService().deleteFromCache(jobId, key);
    }
}

