/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RunnableFuture;
import org.apache.flink.runtime.state.StateObject;
import org.apache.flink.util.LambdaUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateUtil {
    private static final Logger LOG = LoggerFactory.getLogger(StateUtil.class);

    private StateUtil() {
        throw new AssertionError();
    }

    public static long getStateSize(StateObject handle) {
        return handle == null ? 0L : handle.getStateSize();
    }

    public static void bestEffortDiscardAllStateObjects(Iterable<? extends StateObject> handlesToDiscard) throws Exception {
        LambdaUtil.applyToAllWhileSuppressingExceptions(handlesToDiscard, StateObject::discardState);
    }

    public static void discardStateFuture(Future<? extends StateObject> stateFuture) throws Exception {
        if (null != stateFuture && !stateFuture.cancel(true)) {
            try {
                StateObject stateObject;
                if (stateFuture instanceof RunnableFuture && !stateFuture.isDone()) {
                    ((RunnableFuture)stateFuture).run();
                }
                if (null != (stateObject = stateFuture.get())) {
                    stateObject.discardState();
                }
            }
            catch (CancellationException | ExecutionException ex) {
                LOG.debug("Cancelled execution of snapshot future runnable. Cancellation produced the following exception, which is expected an can be ignored.", (Throwable)ex);
            }
        }
    }
}

