/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.util.Collection;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.fs.CloseableRegistry;
import org.apache.flink.runtime.query.TaskKvStateRegistry;
import org.apache.flink.runtime.state.AbstractKeyedStateBackend;
import org.apache.flink.runtime.state.BackendBuildingException;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.KeyedStateHandle;
import org.apache.flink.runtime.state.StateBackendBuilder;
import org.apache.flink.runtime.state.StateSerializerProvider;
import org.apache.flink.runtime.state.StreamCompressionDecorator;
import org.apache.flink.runtime.state.ttl.TtlTimeProvider;

public abstract class AbstractKeyedStateBackendBuilder<K>
implements StateBackendBuilder<AbstractKeyedStateBackend, BackendBuildingException> {
    protected final TaskKvStateRegistry kvStateRegistry;
    protected final StateSerializerProvider<K> keySerializerProvider;
    protected final ClassLoader userCodeClassLoader;
    protected final int numberOfKeyGroups;
    protected final KeyGroupRange keyGroupRange;
    protected final ExecutionConfig executionConfig;
    protected final TtlTimeProvider ttlTimeProvider;
    protected final StreamCompressionDecorator keyGroupCompressionDecorator;
    protected final Collection<KeyedStateHandle> restoreStateHandles;
    protected final CloseableRegistry cancelStreamRegistry;

    public AbstractKeyedStateBackendBuilder(TaskKvStateRegistry kvStateRegistry, TypeSerializer<K> keySerializer, ClassLoader userCodeClassLoader, int numberOfKeyGroups, KeyGroupRange keyGroupRange, ExecutionConfig executionConfig, TtlTimeProvider ttlTimeProvider, @Nonnull Collection<KeyedStateHandle> stateHandles, StreamCompressionDecorator keyGroupCompressionDecorator, CloseableRegistry cancelStreamRegistry) {
        this.kvStateRegistry = kvStateRegistry;
        this.keySerializerProvider = StateSerializerProvider.fromNewRegisteredSerializer(keySerializer);
        this.userCodeClassLoader = userCodeClassLoader;
        this.numberOfKeyGroups = numberOfKeyGroups;
        this.keyGroupRange = keyGroupRange;
        this.executionConfig = executionConfig;
        this.ttlTimeProvider = ttlTimeProvider;
        this.keyGroupCompressionDecorator = keyGroupCompressionDecorator;
        this.restoreStateHandles = stateHandles;
        this.cancelStreamRegistry = cancelStreamRegistry;
    }
}

