/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobgraph;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import org.apache.flink.api.common.cache.DistributedCache;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.util.FileUtils;
import org.apache.flink.util.FlinkRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum JobGraphUtils {

    private static final Logger LOG = LoggerFactory.getLogger(JobGraphUtils.class);

    public static void addUserArtifactEntries(Collection<Tuple2<String, DistributedCache.DistributedCacheEntry>> userArtifacts, JobGraph jobGraph) {
        if (userArtifacts != null && !userArtifacts.isEmpty()) {
            try {
                java.nio.file.Path tmpDir = Files.createTempDirectory("flink-distributed-cache-" + jobGraph.getJobID(), new FileAttribute[0]);
                for (Tuple2<String, DistributedCache.DistributedCacheEntry> originalEntry : userArtifacts) {
                    DistributedCache.DistributedCacheEntry entry;
                    Path filePath = new Path(((DistributedCache.DistributedCacheEntry)originalEntry.f1).filePath);
                    boolean isLocalDir = false;
                    try {
                        FileSystem sourceFs = filePath.getFileSystem();
                        isLocalDir = !sourceFs.isDistributedFS() && sourceFs.getFileStatus(filePath).isDir();
                    }
                    catch (IOException ioe) {
                        LOG.warn("Could not determine whether {} denotes a local path.", (Object)filePath, (Object)ioe);
                    }
                    if (isLocalDir) {
                        Path zip = FileUtils.compressDirectory((Path)filePath, (Path)new Path(tmpDir.toString(), filePath.getName() + ".zip"));
                        entry = new DistributedCache.DistributedCacheEntry(zip.toString(), ((DistributedCache.DistributedCacheEntry)originalEntry.f1).isExecutable.booleanValue(), true);
                    } else {
                        entry = new DistributedCache.DistributedCacheEntry(filePath.toString(), ((DistributedCache.DistributedCacheEntry)originalEntry.f1).isExecutable.booleanValue(), false);
                    }
                    jobGraph.addUserArtifact((String)originalEntry.f0, entry);
                }
            }
            catch (IOException ioe) {
                throw new FlinkRuntimeException("Could not compress distributed-cache artifacts.", (Throwable)ioe);
            }
        }
    }
}

