/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.consumer;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.metrics.Counter;
import org.apache.flink.runtime.checkpoint.channel.ChannelStateReader;
import org.apache.flink.runtime.event.AbstractEvent;
import org.apache.flink.runtime.event.TaskEvent;
import org.apache.flink.runtime.io.network.api.serialization.EventSerializer;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.consumer.BufferManager;
import org.apache.flink.runtime.io.network.partition.consumer.EndOfChannelStateEvent;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannel;
import org.apache.flink.runtime.io.network.partition.consumer.SingleInputGate;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RecoveredInputChannel
extends InputChannel {
    private static final Logger LOG = LoggerFactory.getLogger(RecoveredInputChannel.class);
    private final ArrayDeque<Buffer> receivedBuffers = new ArrayDeque();
    private final CompletableFuture<?> stateConsumedFuture = new CompletableFuture();
    protected final BufferManager bufferManager;
    @GuardedBy(value="receivedBuffers")
    private boolean isReleased;

    RecoveredInputChannel(SingleInputGate inputGate, int channelIndex, ResultPartitionID partitionId, int initialBackoff, int maxBackoff, Counter numBytesIn, Counter numBuffersIn) {
        super(inputGate, channelIndex, partitionId, initialBackoff, maxBackoff, numBytesIn, numBuffersIn);
        this.bufferManager = new BufferManager(inputGate.getMemorySegmentProvider(), this, 0);
    }

    public abstract InputChannel toInputChannel() throws IOException;

    CompletableFuture<?> getStateConsumedFuture() {
        return this.stateConsumedFuture;
    }

    protected void readRecoveredState(ChannelStateReader reader) throws IOException, InterruptedException {
        ChannelStateReader.ReadResult result = ChannelStateReader.ReadResult.HAS_MORE_DATA;
        while (result == ChannelStateReader.ReadResult.HAS_MORE_DATA) {
            Buffer buffer = this.bufferManager.requestBufferBlocking();
            result = this.internalReaderRecoveredState(reader, buffer);
        }
        this.finishReadRecoveredState();
    }

    private ChannelStateReader.ReadResult internalReaderRecoveredState(ChannelStateReader reader, Buffer buffer) throws IOException {
        ChannelStateReader.ReadResult result;
        try {
            result = reader.readInputData(this.channelInfo, buffer);
        }
        catch (Throwable t) {
            buffer.recycleBuffer();
            throw t;
        }
        if (buffer.readableBytes() > 0) {
            this.onRecoveredStateBuffer(buffer);
        } else {
            buffer.recycleBuffer();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onRecoveredStateBuffer(Buffer buffer) {
        boolean recycleBuffer = true;
        try {
            boolean wasEmpty;
            ArrayDeque<Buffer> arrayDeque = this.receivedBuffers;
            synchronized (arrayDeque) {
                block10: {
                    if (!this.isReleased) break block10;
                    return;
                }
                wasEmpty = this.receivedBuffers.isEmpty();
                this.receivedBuffers.add(buffer);
                recycleBuffer = false;
            }
            if (wasEmpty) {
                this.notifyChannelNonEmpty();
            }
        }
        finally {
            if (recycleBuffer) {
                buffer.recycleBuffer();
            }
        }
    }

    private void finishReadRecoveredState() throws IOException {
        this.onRecoveredStateBuffer(EventSerializer.toBuffer(EndOfChannelStateEvent.INSTANCE));
        this.bufferManager.releaseFloatingBuffers();
        LOG.debug("{}/{} finished recovering input.", (Object)this.inputGate.getOwningTaskName(), (Object)this.channelInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private InputChannel.BufferAndAvailability getNextRecoveredStateBuffer() throws IOException {
        boolean moreAvailable;
        Buffer next;
        ArrayDeque<Buffer> arrayDeque = this.receivedBuffers;
        synchronized (arrayDeque) {
            Preconditions.checkState((!this.isReleased ? 1 : 0) != 0, (Object)"Trying to read from released RecoveredInputChannel");
            next = this.receivedBuffers.poll();
            moreAvailable = !this.receivedBuffers.isEmpty();
        }
        if (next == null) {
            return null;
        }
        if (this.isEndOfChannelStateEvent(next)) {
            this.stateConsumedFuture.complete(null);
            return null;
        }
        return new InputChannel.BufferAndAvailability(next, moreAvailable, 0);
    }

    private boolean isEndOfChannelStateEvent(Buffer buffer) throws IOException {
        if (buffer.isBuffer()) {
            return false;
        }
        AbstractEvent event = EventSerializer.fromBuffer(buffer, this.getClass().getClassLoader());
        buffer.setReaderIndex(0);
        return event.getClass() == EndOfChannelStateEvent.class;
    }

    @Override
    Optional<InputChannel.BufferAndAvailability> getNextBuffer() throws IOException {
        this.checkError();
        return Optional.ofNullable(this.getNextRecoveredStateBuffer());
    }

    @Override
    public void resumeConsumption() {
        throw new UnsupportedOperationException("RecoveredInputChannel should never be blocked.");
    }

    @Override
    void requestSubpartition(int subpartitionIndex) {
        throw new UnsupportedOperationException("RecoveredInputChannel should never request partition.");
    }

    @Override
    void sendTaskEvent(TaskEvent event) {
        throw new UnsupportedOperationException("RecoveredInputChannel should never send any task events.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean isReleased() {
        ArrayDeque<Buffer> arrayDeque = this.receivedBuffers;
        synchronized (arrayDeque) {
            return this.isReleased;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void releaseAllResources() throws IOException {
        ArrayDeque<Buffer> releasedBuffers = new ArrayDeque<Buffer>();
        boolean shouldRelease = false;
        ArrayDeque<Buffer> arrayDeque = this.receivedBuffers;
        synchronized (arrayDeque) {
            if (!this.isReleased) {
                this.isReleased = true;
                shouldRelease = true;
                releasedBuffers.addAll(this.receivedBuffers);
                this.receivedBuffers.clear();
            }
        }
        if (shouldRelease) {
            this.bufferManager.releaseAllBuffers(releasedBuffers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    protected int getNumberOfQueuedBuffers() {
        ArrayDeque<Buffer> arrayDeque = this.receivedBuffers;
        synchronized (arrayDeque) {
            return this.receivedBuffers.size();
        }
    }
}

