/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.io.IOException;
import java.util.List;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.checkpoint.channel.ChannelStateReader;
import org.apache.flink.runtime.checkpoint.channel.ResultSubpartitionInfo;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferConsumer;
import org.apache.flink.runtime.io.network.partition.BufferAvailabilityListener;
import org.apache.flink.runtime.io.network.partition.ResultPartition;
import org.apache.flink.runtime.io.network.partition.ResultSubpartitionView;
import org.apache.flink.util.Preconditions;

public abstract class ResultSubpartition {
    protected final ResultSubpartitionInfo subpartitionInfo;
    protected final ResultPartition parent;

    public ResultSubpartition(int index, ResultPartition parent) {
        this.parent = parent;
        this.subpartitionInfo = new ResultSubpartitionInfo(parent.getPartitionIndex(), index);
    }

    protected boolean canBeCompressed(Buffer buffer) {
        return this.parent.bufferCompressor != null && buffer.isBuffer() && buffer.readableBytes() > 0;
    }

    public ResultSubpartitionInfo getSubpartitionInfo() {
        return this.subpartitionInfo;
    }

    protected abstract long getTotalNumberOfBuffers();

    protected abstract long getTotalNumberOfBytes();

    public int getSubPartitionIndex() {
        return this.subpartitionInfo.getSubPartitionIdx();
    }

    protected void onConsumedSubpartition() {
        this.parent.onConsumedSubpartition(this.getSubPartitionIndex());
    }

    public void readRecoveredState(ChannelStateReader stateReader) throws IOException, InterruptedException {
    }

    public abstract boolean add(BufferConsumer var1, boolean var2) throws IOException;

    public boolean add(BufferConsumer bufferConsumer) throws IOException {
        return this.add(bufferConsumer, false);
    }

    public abstract List<Buffer> requestInflightBufferSnapshot();

    public abstract void flush();

    public abstract void finish() throws IOException;

    public abstract void release() throws IOException;

    public abstract ResultSubpartitionView createReadView(BufferAvailabilityListener var1) throws IOException;

    abstract int releaseMemory() throws IOException;

    public abstract boolean isReleased();

    @VisibleForTesting
    abstract int getBuffersInBacklog();

    public abstract int unsynchronizedGetNumberOfQueuedBuffers();

    public static final class BufferAndBacklog {
        private final Buffer buffer;
        private final boolean isDataAvailable;
        private final int buffersInBacklog;
        private final boolean isEventAvailable;

        public BufferAndBacklog(Buffer buffer, boolean isDataAvailable, int buffersInBacklog, boolean isEventAvailable) {
            this.buffer = (Buffer)Preconditions.checkNotNull((Object)buffer);
            this.buffersInBacklog = buffersInBacklog;
            this.isDataAvailable = isDataAvailable;
            this.isEventAvailable = isEventAvailable;
        }

        public Buffer buffer() {
            return this.buffer;
        }

        public boolean isDataAvailable() {
            return this.isDataAvailable;
        }

        public int buffersInBacklog() {
            return this.buffersInBacklog;
        }

        public boolean isEventAvailable() {
            return this.isEventAvailable;
        }

        public static BufferAndBacklog fromBufferAndLookahead(Buffer current, Buffer lookahead, int backlog) {
            return new BufferAndBacklog(current, lookahead != null, backlog, lookahead != null && !lookahead.isBuffer());
        }
    }
}

