/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.flink.runtime.io.network.buffer.BufferCompressor;
import org.apache.flink.runtime.io.network.buffer.BufferPool;
import org.apache.flink.runtime.io.network.buffer.BufferPoolOwner;
import org.apache.flink.runtime.io.network.partition.BufferAvailabilityListener;
import org.apache.flink.runtime.io.network.partition.ResultPartition;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.ResultPartitionManager;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.io.network.partition.ResultSubpartition;
import org.apache.flink.runtime.io.network.partition.ResultSubpartitionView;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.FunctionWithException;

public class ReleaseOnConsumptionResultPartition
extends ResultPartition {
    private static final Object lock = new Object();
    private final boolean[] consumedSubpartitions;
    private int numUnconsumedSubpartitions;

    ReleaseOnConsumptionResultPartition(String owningTaskName, int partitionIndex, ResultPartitionID partitionId, ResultPartitionType partitionType, ResultSubpartition[] subpartitions, int numTargetKeyGroups, ResultPartitionManager partitionManager, @Nullable BufferCompressor bufferCompressor, FunctionWithException<BufferPoolOwner, BufferPool, IOException> bufferPoolFactory) {
        super(owningTaskName, partitionIndex, partitionId, partitionType, subpartitions, numTargetKeyGroups, partitionManager, bufferCompressor, bufferPoolFactory);
        this.consumedSubpartitions = new boolean[subpartitions.length];
        this.numUnconsumedSubpartitions = subpartitions.length;
    }

    @Override
    public ResultSubpartitionView createSubpartitionView(int index, BufferAvailabilityListener availabilityListener) throws IOException {
        Preconditions.checkState((this.numUnconsumedSubpartitions > 0 ? 1 : 0) != 0, (Object)"Partition not pinned.");
        return super.createSubpartitionView(index, availabilityListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void onConsumedSubpartition(int subpartitionIndex) {
        int remainingUnconsumed;
        if (this.isReleased()) {
            return;
        }
        Object object = lock;
        synchronized (object) {
            if (this.consumedSubpartitions[subpartitionIndex]) {
                return;
            }
            this.consumedSubpartitions[subpartitionIndex] = true;
            remainingUnconsumed = --this.numUnconsumedSubpartitions;
        }
        LOG.debug("{}: Received consumed notification for subpartition {}.", (Object)this, (Object)subpartitionIndex);
        if (remainingUnconsumed == 0) {
            this.partitionManager.onConsumedPartition(this);
        } else if (remainingUnconsumed < 0) {
            throw new IllegalStateException("Received consume notification even though all subpartitions are already consumed.");
        }
    }

    @Override
    public String toString() {
        return "ReleaseOnConsumptionResultPartition " + this.partitionId.toString() + " [" + (Object)((Object)this.partitionType) + ", " + this.subpartitions.length + " subpartitions, " + this.numUnconsumedSubpartitions + " pending consumptions]";
    }
}

