/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.List;
import java.util.ListIterator;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.runtime.checkpoint.CompletedCheckpoint;
import org.apache.flink.runtime.checkpoint.StandaloneCompletedCheckpointStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface CompletedCheckpointStore {
    public static final Logger LOG = LoggerFactory.getLogger(CompletedCheckpointStore.class);

    public void recover() throws Exception;

    public void addCheckpoint(CompletedCheckpoint var1) throws Exception;

    default public CompletedCheckpoint getLatestCheckpoint(boolean isPreferCheckpointForRecovery) throws Exception {
        List<CompletedCheckpoint> allCheckpoints = this.getAllCheckpoints();
        if (allCheckpoints.isEmpty()) {
            return null;
        }
        CompletedCheckpoint lastCompleted = allCheckpoints.get(allCheckpoints.size() - 1);
        if (isPreferCheckpointForRecovery && allCheckpoints.size() > 1 && lastCompleted.getProperties().isSavepoint()) {
            ListIterator<CompletedCheckpoint> listIterator = allCheckpoints.listIterator(allCheckpoints.size() - 1);
            while (listIterator.hasPrevious()) {
                CompletedCheckpoint prev = listIterator.previous();
                if (prev.getProperties().isSavepoint()) continue;
                LOG.info("Found a completed checkpoint ({}) before the latest savepoint, will use it to recover!", (Object)prev);
                return prev;
            }
            LOG.info("Did not find earlier checkpoint, using latest savepoint to recover.");
        }
        return lastCompleted;
    }

    public void shutdown(JobStatus var1) throws Exception;

    public List<CompletedCheckpoint> getAllCheckpoints() throws Exception;

    public int getNumberOfRetainedCheckpoints();

    public int getMaxNumberOfRetainedCheckpoints();

    public boolean requiresExternalizedCheckpoints();

    public static CompletedCheckpointStore storeFor(CompletedCheckpoint ... checkpoints) throws Exception {
        StandaloneCompletedCheckpointStore store = new StandaloneCompletedCheckpointStore(checkpoints.length);
        for (CompletedCheckpoint checkpoint : checkpoints) {
            store.addCheckpoint(checkpoint);
        }
        return store;
    }
}

