/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.shaded.akka.org.jboss.netty.channel.socket.nio;

import java.net.Socket;
import java.util.Map;
import org.apache.flink.shaded.akka.org.jboss.netty.channel.AdaptiveReceiveBufferSizePredictorFactory;
import org.apache.flink.shaded.akka.org.jboss.netty.channel.ChannelException;
import org.apache.flink.shaded.akka.org.jboss.netty.channel.ReceiveBufferSizePredictor;
import org.apache.flink.shaded.akka.org.jboss.netty.channel.ReceiveBufferSizePredictorFactory;
import org.apache.flink.shaded.akka.org.jboss.netty.channel.socket.DefaultSocketChannelConfig;
import org.apache.flink.shaded.akka.org.jboss.netty.channel.socket.nio.NioSocketChannelConfig;
import org.apache.flink.shaded.akka.org.jboss.netty.logging.InternalLogger;
import org.apache.flink.shaded.akka.org.jboss.netty.logging.InternalLoggerFactory;
import org.apache.flink.shaded.akka.org.jboss.netty.util.internal.ConversionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultNioSocketChannelConfig
extends DefaultSocketChannelConfig
implements NioSocketChannelConfig {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(DefaultNioSocketChannelConfig.class);
    private static final ReceiveBufferSizePredictorFactory DEFAULT_PREDICTOR_FACTORY = new AdaptiveReceiveBufferSizePredictorFactory();
    private volatile int writeBufferHighWaterMark = 65536;
    private volatile int writeBufferLowWaterMark = 32768;
    private volatile ReceiveBufferSizePredictor predictor;
    private volatile ReceiveBufferSizePredictorFactory predictorFactory = DEFAULT_PREDICTOR_FACTORY;
    private volatile int writeSpinCount = 16;

    DefaultNioSocketChannelConfig(Socket socket) {
        super(socket);
    }

    @Override
    public void setOptions(Map<String, Object> options) {
        super.setOptions(options);
        if (this.getWriteBufferHighWaterMark() < this.getWriteBufferLowWaterMark()) {
            this.setWriteBufferLowWaterMark0(this.getWriteBufferHighWaterMark() >>> 1);
            if (logger.isWarnEnabled()) {
                logger.warn("writeBufferLowWaterMark cannot be greater than writeBufferHighWaterMark; setting to the half of the writeBufferHighWaterMark.");
            }
        }
    }

    @Override
    public boolean setOption(String key, Object value) {
        if (super.setOption(key, value)) {
            return true;
        }
        if ("writeBufferHighWaterMark".equals(key)) {
            this.setWriteBufferHighWaterMark0(ConversionUtil.toInt(value));
        } else if ("writeBufferLowWaterMark".equals(key)) {
            this.setWriteBufferLowWaterMark0(ConversionUtil.toInt(value));
        } else if ("writeSpinCount".equals(key)) {
            this.setWriteSpinCount(ConversionUtil.toInt(value));
        } else if ("receiveBufferSizePredictorFactory".equals(key)) {
            this.setReceiveBufferSizePredictorFactory((ReceiveBufferSizePredictorFactory)value);
        } else if ("receiveBufferSizePredictor".equals(key)) {
            this.setReceiveBufferSizePredictor((ReceiveBufferSizePredictor)value);
        } else {
            return false;
        }
        return true;
    }

    @Override
    public int getWriteBufferHighWaterMark() {
        return this.writeBufferHighWaterMark;
    }

    @Override
    public void setWriteBufferHighWaterMark(int writeBufferHighWaterMark) {
        if (writeBufferHighWaterMark < this.getWriteBufferLowWaterMark()) {
            throw new IllegalArgumentException("writeBufferHighWaterMark cannot be less than writeBufferLowWaterMark (" + this.getWriteBufferLowWaterMark() + "): " + writeBufferHighWaterMark);
        }
        this.setWriteBufferHighWaterMark0(writeBufferHighWaterMark);
    }

    private void setWriteBufferHighWaterMark0(int writeBufferHighWaterMark) {
        if (writeBufferHighWaterMark < 0) {
            throw new IllegalArgumentException("writeBufferHighWaterMark: " + writeBufferHighWaterMark);
        }
        this.writeBufferHighWaterMark = writeBufferHighWaterMark;
    }

    @Override
    public int getWriteBufferLowWaterMark() {
        return this.writeBufferLowWaterMark;
    }

    @Override
    public void setWriteBufferLowWaterMark(int writeBufferLowWaterMark) {
        if (writeBufferLowWaterMark > this.getWriteBufferHighWaterMark()) {
            throw new IllegalArgumentException("writeBufferLowWaterMark cannot be greater than writeBufferHighWaterMark (" + this.getWriteBufferHighWaterMark() + "): " + writeBufferLowWaterMark);
        }
        this.setWriteBufferLowWaterMark0(writeBufferLowWaterMark);
    }

    private void setWriteBufferLowWaterMark0(int writeBufferLowWaterMark) {
        if (writeBufferLowWaterMark < 0) {
            throw new IllegalArgumentException("writeBufferLowWaterMark: " + writeBufferLowWaterMark);
        }
        this.writeBufferLowWaterMark = writeBufferLowWaterMark;
    }

    @Override
    public int getWriteSpinCount() {
        return this.writeSpinCount;
    }

    @Override
    public void setWriteSpinCount(int writeSpinCount) {
        if (writeSpinCount <= 0) {
            throw new IllegalArgumentException("writeSpinCount must be a positive integer.");
        }
        this.writeSpinCount = writeSpinCount;
    }

    @Override
    public ReceiveBufferSizePredictor getReceiveBufferSizePredictor() {
        ReceiveBufferSizePredictor predictor = this.predictor;
        if (predictor == null) {
            try {
                this.predictor = predictor = this.getReceiveBufferSizePredictorFactory().getPredictor();
            }
            catch (Exception e) {
                throw new ChannelException("Failed to create a new " + ReceiveBufferSizePredictor.class.getSimpleName() + '.', e);
            }
        }
        return predictor;
    }

    @Override
    public void setReceiveBufferSizePredictor(ReceiveBufferSizePredictor predictor) {
        if (predictor == null) {
            throw new NullPointerException("predictor");
        }
        this.predictor = predictor;
    }

    @Override
    public ReceiveBufferSizePredictorFactory getReceiveBufferSizePredictorFactory() {
        return this.predictorFactory;
    }

    @Override
    public void setReceiveBufferSizePredictorFactory(ReceiveBufferSizePredictorFactory predictorFactory) {
        if (predictorFactory == null) {
            throw new NullPointerException("predictorFactory");
        }
        this.predictorFactory = predictorFactory;
    }
}

