/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adaptive;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.configuration.CheckpointingOptions;
import org.apache.flink.queryablestate.KvStateID;
import org.apache.flink.runtime.accumulators.AccumulatorSnapshot;
import org.apache.flink.runtime.checkpoint.CheckpointCoordinator;
import org.apache.flink.runtime.checkpoint.CheckpointMetrics;
import org.apache.flink.runtime.checkpoint.CompletedCheckpoint;
import org.apache.flink.runtime.checkpoint.TaskStateSnapshot;
import org.apache.flink.runtime.concurrent.FutureUtils;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.TaskExecutionStateTransition;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.jobmanager.PartitionProducerDisposedException;
import org.apache.flink.runtime.jobmaster.SerializedInputSplit;
import org.apache.flink.runtime.messages.FlinkJobNotFoundException;
import org.apache.flink.runtime.messages.checkpoint.DeclineCheckpoint;
import org.apache.flink.runtime.operators.coordination.CoordinationRequest;
import org.apache.flink.runtime.operators.coordination.CoordinationResponse;
import org.apache.flink.runtime.operators.coordination.OperatorEvent;
import org.apache.flink.runtime.query.KvStateLocation;
import org.apache.flink.runtime.query.UnknownKvStateLocation;
import org.apache.flink.runtime.scheduler.ExecutionGraphHandler;
import org.apache.flink.runtime.scheduler.KvStateHandler;
import org.apache.flink.runtime.scheduler.OperatorCoordinatorHandler;
import org.apache.flink.runtime.scheduler.adaptive.State;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;

abstract class StateWithExecutionGraph
implements State {
    private final Context context;
    private final ExecutionGraph executionGraph;
    private final ExecutionGraphHandler executionGraphHandler;
    private final OperatorCoordinatorHandler operatorCoordinatorHandler;
    private final KvStateHandler kvStateHandler;
    private final Logger logger;

    StateWithExecutionGraph(Context context, ExecutionGraph executionGraph, ExecutionGraphHandler executionGraphHandler, OperatorCoordinatorHandler operatorCoordinatorHandler, Logger logger) {
        this.context = context;
        this.executionGraph = executionGraph;
        this.executionGraphHandler = executionGraphHandler;
        this.operatorCoordinatorHandler = operatorCoordinatorHandler;
        this.kvStateHandler = new KvStateHandler(executionGraph);
        this.logger = logger;
        Preconditions.checkState((executionGraph.getState() == JobStatus.RUNNING ? 1 : 0) != 0, (Object)"Assuming running execution graph");
        FutureUtils.assertNoException(executionGraph.getTerminationFuture().thenAcceptAsync(jobStatus -> {
            if (jobStatus.isGloballyTerminalState()) {
                context.runIfState(this, () -> this.onGloballyTerminalState((JobStatus)jobStatus));
            }
        }, context.getMainThreadExecutor()));
    }

    @VisibleForTesting
    ExecutionGraph getExecutionGraph() {
        return this.executionGraph;
    }

    protected OperatorCoordinatorHandler getOperatorCoordinatorHandler() {
        return this.operatorCoordinatorHandler;
    }

    protected ExecutionGraphHandler getExecutionGraphHandler() {
        return this.executionGraphHandler;
    }

    @Override
    public void onLeave(Class<? extends State> newState) {
        if (!StateWithExecutionGraph.class.isAssignableFrom(newState)) {
            this.operatorCoordinatorHandler.disposeAllOperatorCoordinators();
        }
    }

    @Override
    public ArchivedExecutionGraph getJob() {
        return ArchivedExecutionGraph.createFrom(this.executionGraph, this.getJobStatus());
    }

    @Override
    public void suspend(Throwable cause) {
        this.executionGraph.suspend(cause);
        Preconditions.checkState((boolean)this.executionGraph.getState().isTerminalState());
        this.context.goToFinished(ArchivedExecutionGraph.createFrom(this.executionGraph));
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    void notifyPartitionDataAvailable(ResultPartitionID partitionID) {
        this.executionGraph.notifyPartitionDataAvailable(partitionID);
    }

    SerializedInputSplit requestNextInputSplit(JobVertexID vertexID, ExecutionAttemptID executionAttempt) throws IOException {
        return this.executionGraphHandler.requestNextInputSplit(vertexID, executionAttempt);
    }

    ExecutionState requestPartitionState(IntermediateDataSetID intermediateResultId, ResultPartitionID resultPartitionId) throws PartitionProducerDisposedException {
        return this.executionGraphHandler.requestPartitionState(intermediateResultId, resultPartitionId);
    }

    void acknowledgeCheckpoint(JobID jobID, ExecutionAttemptID executionAttemptID, long checkpointId, CheckpointMetrics checkpointMetrics, TaskStateSnapshot checkpointState) {
        this.executionGraphHandler.acknowledgeCheckpoint(jobID, executionAttemptID, checkpointId, checkpointMetrics, checkpointState);
    }

    void declineCheckpoint(DeclineCheckpoint decline) {
        this.executionGraphHandler.declineCheckpoint(decline);
    }

    void reportCheckpointMetrics(ExecutionAttemptID executionAttemptID, long checkpointId, CheckpointMetrics checkpointMetrics) {
        this.executionGraphHandler.reportCheckpointMetrics(executionAttemptID, checkpointId, checkpointMetrics);
    }

    void updateAccumulators(AccumulatorSnapshot accumulatorSnapshot) {
        this.executionGraph.updateAccumulators(accumulatorSnapshot);
    }

    KvStateLocation requestKvStateLocation(JobID jobId, String registrationName) throws FlinkJobNotFoundException, UnknownKvStateLocation {
        return this.kvStateHandler.requestKvStateLocation(jobId, registrationName);
    }

    void notifyKvStateRegistered(JobID jobId, JobVertexID jobVertexId, KeyGroupRange keyGroupRange, String registrationName, KvStateID kvStateId, InetSocketAddress kvStateServerAddress) throws FlinkJobNotFoundException {
        this.kvStateHandler.notifyKvStateRegistered(jobId, jobVertexId, keyGroupRange, registrationName, kvStateId, kvStateServerAddress);
    }

    void notifyKvStateUnregistered(JobID jobId, JobVertexID jobVertexId, KeyGroupRange keyGroupRange, String registrationName) throws FlinkJobNotFoundException {
        this.kvStateHandler.notifyKvStateUnregistered(jobId, jobVertexId, keyGroupRange, registrationName);
    }

    CompletableFuture<String> triggerSavepoint(String targetDirectory, boolean cancelJob) {
        CheckpointCoordinator checkpointCoordinator = this.executionGraph.getCheckpointCoordinator();
        if (checkpointCoordinator == null) {
            throw new IllegalStateException(String.format("Job %s is not a streaming job.", this.executionGraph.getJobID()));
        }
        if (targetDirectory == null && !checkpointCoordinator.getCheckpointStorage().hasDefaultSavepointLocation()) {
            this.logger.info("Trying to cancel job {} with savepoint, but no savepoint directory configured.", (Object)this.executionGraph.getJobID());
            throw new IllegalStateException("No savepoint directory configured. You can either specify a directory while cancelling via -s :targetDirectory or configure a cluster-wide default via key '" + CheckpointingOptions.SAVEPOINT_DIRECTORY.key() + "'.");
        }
        this.logger.info("Triggering {}savepoint for job {}.", (Object)(cancelJob ? "cancel-with-" : ""), (Object)this.executionGraph.getJobID());
        if (cancelJob) {
            checkpointCoordinator.stopCheckpointScheduler();
        }
        return ((CompletableFuture)checkpointCoordinator.triggerSavepoint(targetDirectory).thenApply(CompletedCheckpoint::getExternalPointer)).handleAsync((path, throwable) -> {
            if (throwable != null) {
                if (cancelJob && this.context.isState(this)) {
                    this.startCheckpointScheduler(checkpointCoordinator);
                }
                throw new CompletionException((Throwable)throwable);
            }
            if (cancelJob && this.context.isState(this)) {
                this.logger.info("Savepoint stored in {}. Now cancelling {}.", path, (Object)this.executionGraph.getJobID());
                this.cancel();
            }
            return path;
        }, this.context.getMainThreadExecutor());
    }

    private void startCheckpointScheduler(CheckpointCoordinator checkpointCoordinator) {
        if (checkpointCoordinator.isPeriodicCheckpointingConfigured()) {
            try {
                checkpointCoordinator.startCheckpointScheduler();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    void deliverOperatorEventToCoordinator(ExecutionAttemptID taskExecutionId, OperatorID operatorId, OperatorEvent evt) throws FlinkException {
        this.operatorCoordinatorHandler.deliverOperatorEventToCoordinator(taskExecutionId, operatorId, evt);
    }

    CompletableFuture<CoordinationResponse> deliverCoordinationRequestToCoordinator(OperatorID operatorId, CoordinationRequest request) throws FlinkException {
        return this.operatorCoordinatorHandler.deliverCoordinationRequestToCoordinator(operatorId, request);
    }

    abstract boolean updateTaskExecutionState(TaskExecutionStateTransition var1);

    abstract void onGloballyTerminalState(JobStatus var1);

    static interface Context {
        public void runIfState(State var1, Runnable var2);

        public boolean isState(State var1);

        public Executor getMainThreadExecutor();

        public void goToFinished(ArchivedExecutionGraph var1);
    }
}

