/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.shaded.akka.org.jboss.netty.channel.socket.oio;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import org.apache.flink.shaded.akka.org.jboss.netty.buffer.ChannelBuffer;
import org.apache.flink.shaded.akka.org.jboss.netty.channel.ChannelFuture;
import org.apache.flink.shaded.akka.org.jboss.netty.channel.Channels;
import org.apache.flink.shaded.akka.org.jboss.netty.channel.ReceiveBufferSizePredictor;
import org.apache.flink.shaded.akka.org.jboss.netty.channel.socket.oio.AbstractOioWorker;
import org.apache.flink.shaded.akka.org.jboss.netty.channel.socket.oio.OioDatagramChannel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OioDatagramWorker
extends AbstractOioWorker<OioDatagramChannel> {
    OioDatagramWorker(OioDatagramChannel channel) {
        super(channel);
    }

    @Override
    boolean process() throws IOException {
        ReceiveBufferSizePredictor predictor = ((OioDatagramChannel)this.channel).getConfig().getReceiveBufferSizePredictor();
        byte[] buf = new byte[predictor.nextReceiveBufferSize()];
        DatagramPacket packet = new DatagramPacket(buf, buf.length);
        try {
            ((OioDatagramChannel)this.channel).socket.receive(packet);
        }
        catch (InterruptedIOException e) {
            return true;
        }
        Channels.fireMessageReceived(this.channel, (Object)((OioDatagramChannel)this.channel).getConfig().getBufferFactory().getBuffer(buf, 0, packet.getLength()), packet.getSocketAddress());
        return true;
    }

    static void write(OioDatagramChannel channel, ChannelFuture future, Object message, SocketAddress remoteAddress) {
        boolean iothread = OioDatagramWorker.isIoThread(channel);
        try {
            DatagramPacket packet;
            ChannelBuffer buf = (ChannelBuffer)message;
            int offset = buf.readerIndex();
            int length = buf.readableBytes();
            ByteBuffer nioBuf = buf.toByteBuffer();
            if (nioBuf.hasArray()) {
                packet = new DatagramPacket(nioBuf.array(), nioBuf.arrayOffset() + offset, length);
            } else {
                byte[] arrayBuf = new byte[length];
                buf.getBytes(0, arrayBuf);
                packet = new DatagramPacket(arrayBuf, length);
            }
            if (remoteAddress != null) {
                packet.setSocketAddress(remoteAddress);
            }
            channel.socket.send(packet);
            if (iothread) {
                Channels.fireWriteComplete(channel, (long)length);
            } else {
                Channels.fireWriteCompleteLater(channel, length);
            }
            future.setSuccess();
        }
        catch (Throwable t) {
            future.setFailure(t);
            if (iothread) {
                Channels.fireExceptionCaught(channel, t);
            }
            Channels.fireExceptionCaughtLater(channel, t);
        }
    }

    static void disconnect(OioDatagramChannel channel, ChannelFuture future) {
        boolean connected = channel.isConnected();
        boolean iothread = OioDatagramWorker.isIoThread(channel);
        try {
            channel.socket.disconnect();
            future.setSuccess();
            if (connected) {
                if (iothread) {
                    Channels.fireChannelDisconnected(channel);
                } else {
                    Channels.fireChannelDisconnectedLater(channel);
                }
            }
        }
        catch (Throwable t) {
            future.setFailure(t);
            if (iothread) {
                Channels.fireExceptionCaught(channel, t);
            }
            Channels.fireExceptionCaughtLater(channel, t);
        }
    }
}

