/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler;

import org.apache.flink.configuration.MemorySize;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.jobmanager.scheduler.SlotSharingGroup;
import org.apache.flink.runtime.scheduler.ExecutionVertexSchedulingRequirements;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;

public final class ExecutionVertexSchedulingRequirementsMapper {
    public static ExecutionVertexSchedulingRequirements from(ExecutionVertex executionVertex) {
        ExecutionVertexID executionVertexId = executionVertex.getID();
        AllocationID latestPriorAllocation = executionVertex.getLatestPriorAllocation();
        SlotSharingGroup slotSharingGroup = executionVertex.getJobVertex().getSlotSharingGroup();
        return new ExecutionVertexSchedulingRequirements.Builder().withExecutionVertexId(executionVertexId).withPreviousAllocationId(latestPriorAllocation).withTaskResourceProfile(executionVertex.getResourceProfile()).withPhysicalSlotResourceProfile(ExecutionVertexSchedulingRequirementsMapper.getPhysicalSlotResourceProfile(executionVertex)).withSlotSharingGroupId(slotSharingGroup.getSlotSharingGroupId()).withCoLocationConstraint(executionVertex.getLocationConstraint()).build();
    }

    public static ResourceProfile getPhysicalSlotResourceProfile(ExecutionVertex executionVertex) {
        SlotSharingGroup slotSharingGroup = executionVertex.getJobVertex().getSlotSharingGroup();
        return ResourceProfile.fromResourceSpec(slotSharingGroup.getResourceSpec(), MemorySize.ZERO);
    }

    private ExecutionVertexSchedulingRequirementsMapper() {
    }
}

