/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager.slotmanager;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.resourcemanager.slotmanager.BiDirectionalResourceToRequirementMapping;
import org.apache.flink.runtime.slots.ResourceCounter;
import org.apache.flink.runtime.slots.ResourceRequirement;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JobScopedResourceTracker {
    private static final Logger LOG = LoggerFactory.getLogger(JobScopedResourceTracker.class);
    private final JobID jobId;
    private final ResourceCounter resourceRequirements = new ResourceCounter();
    private final BiDirectionalResourceToRequirementMapping resourceToRequirementMapping = new BiDirectionalResourceToRequirementMapping();
    private final ResourceCounter excessResources = new ResourceCounter();

    JobScopedResourceTracker(JobID jobId) {
        this.jobId = (JobID)Preconditions.checkNotNull((Object)jobId);
    }

    public void notifyResourceRequirements(Collection<ResourceRequirement> newResourceRequirements) {
        Preconditions.checkNotNull(newResourceRequirements);
        this.resourceRequirements.clear();
        for (ResourceRequirement newResourceRequirement : newResourceRequirements) {
            this.resourceRequirements.incrementCount(newResourceRequirement.getResourceProfile(), newResourceRequirement.getNumberOfRequiredSlots());
        }
        this.findExcessSlots();
        this.tryAssigningExcessSlots();
    }

    public void notifyAcquiredResource(ResourceProfile resourceProfile) {
        Preconditions.checkNotNull((Object)resourceProfile);
        Optional<ResourceProfile> matchingRequirement = this.findMatchingRequirement(resourceProfile);
        if (matchingRequirement.isPresent()) {
            this.resourceToRequirementMapping.incrementCount(matchingRequirement.get(), resourceProfile, 1);
        } else {
            LOG.debug("Job {} acquired excess resource {}.", (Object)resourceProfile, (Object)this.jobId);
            this.excessResources.incrementCount(resourceProfile, 1);
        }
    }

    private Optional<ResourceProfile> findMatchingRequirement(ResourceProfile resourceProfile) {
        for (Map.Entry<ResourceProfile, Integer> requirementCandidate : this.resourceRequirements.getResourceProfilesWithCount().entrySet()) {
            ResourceProfile requirementProfile = requirementCandidate.getKey();
            if (!resourceProfile.isMatching(requirementProfile) || requirementCandidate.getValue() <= this.resourceToRequirementMapping.getNumFulfillingResources(requirementProfile)) continue;
            return Optional.of(requirementProfile);
        }
        return Optional.empty();
    }

    public void notifyLostResource(ResourceProfile resourceProfile) {
        Preconditions.checkNotNull((Object)resourceProfile);
        if (this.excessResources.getResourceCount(resourceProfile) > 0) {
            LOG.trace("Job {} lost excess resource {}.", (Object)this.jobId, (Object)resourceProfile);
            this.excessResources.decrementCount(resourceProfile, 1);
            return;
        }
        Set<ResourceProfile> fulfilledRequirements = this.resourceToRequirementMapping.getRequirementsFulfilledBy(resourceProfile).keySet();
        if (fulfilledRequirements.isEmpty()) {
            throw new IllegalStateException(String.format("Job %s lost a resource %s but no such resource was tracked.", this.jobId, resourceProfile));
        }
        ResourceProfile assignedRequirement = fulfilledRequirements.iterator().next();
        this.resourceToRequirementMapping.decrementCount(assignedRequirement, resourceProfile, 1);
        this.tryAssigningExcessSlots();
    }

    public Collection<ResourceRequirement> getMissingResources() {
        ArrayList<ResourceRequirement> missingResources = new ArrayList<ResourceRequirement>();
        for (Map.Entry<ResourceProfile, Integer> requirement : this.resourceRequirements.getResourceProfilesWithCount().entrySet()) {
            ResourceProfile requirementProfile = requirement.getKey();
            int numRequiredResources = requirement.getValue();
            int numAcquiredResources = this.resourceToRequirementMapping.getNumFulfillingResources(requirementProfile);
            if (numAcquiredResources >= numRequiredResources) continue;
            missingResources.add(ResourceRequirement.create(requirementProfile, numRequiredResources - numAcquiredResources));
        }
        return missingResources;
    }

    public Collection<ResourceRequirement> getAcquiredResources() {
        HashSet<ResourceProfile> knownResourceProfiles = new HashSet<ResourceProfile>();
        knownResourceProfiles.addAll(this.resourceToRequirementMapping.getAllResourceProfiles());
        knownResourceProfiles.addAll(this.excessResources.getResourceProfiles());
        ArrayList<ResourceRequirement> acquiredResources = new ArrayList<ResourceRequirement>();
        for (ResourceProfile knownResourceProfile : knownResourceProfiles) {
            int numTotalAcquiredResources = this.resourceToRequirementMapping.getNumFulfilledRequirements(knownResourceProfile) + this.excessResources.getResourceCount(knownResourceProfile);
            ResourceRequirement resourceRequirement = ResourceRequirement.create(knownResourceProfile, numTotalAcquiredResources);
            acquiredResources.add(resourceRequirement);
        }
        return acquiredResources;
    }

    public boolean isEmpty() {
        return this.resourceRequirements.isEmpty() && this.excessResources.isEmpty();
    }

    private void findExcessSlots() {
        ArrayList<ExcessResource> excessResources = new ArrayList<ExcessResource>();
        block0: for (ResourceProfile requirementProfile : this.resourceToRequirementMapping.getAllRequirementProfiles()) {
            int numTotalRequiredResources = this.resourceRequirements.getResourceCount(requirementProfile);
            int numTotalAcquiredResources = this.resourceToRequirementMapping.getNumFulfillingResources(requirementProfile);
            if (numTotalAcquiredResources <= numTotalRequiredResources) continue;
            int numExcessResources = numTotalAcquiredResources - numTotalRequiredResources;
            for (Map.Entry<ResourceProfile, Integer> acquiredResource : this.resourceToRequirementMapping.getResourcesFulfilling(requirementProfile).entrySet()) {
                ResourceProfile acquiredResourceProfile = acquiredResource.getKey();
                int numAcquiredResources = acquiredResource.getValue();
                if (numAcquiredResources <= numExcessResources) {
                    excessResources.add(new ExcessResource(requirementProfile, acquiredResourceProfile, numAcquiredResources));
                    numExcessResources -= numAcquiredResources;
                    continue;
                }
                excessResources.add(new ExcessResource(requirementProfile, acquiredResourceProfile, numExcessResources));
                continue block0;
            }
        }
        if (!excessResources.isEmpty()) {
            LOG.debug("Detected excess resources for job {}: {}", (Object)this.jobId, excessResources);
            for (ExcessResource excessResource : excessResources) {
                this.resourceToRequirementMapping.decrementCount(excessResource.requirementProfile, excessResource.resourceProfile, excessResource.numExcessResources);
                this.excessResources.incrementCount(excessResource.resourceProfile, excessResource.numExcessResources);
            }
        }
    }

    private void tryAssigningExcessSlots() {
        if (LOG.isTraceEnabled()) {
            LOG.trace("There are {} excess resources for job {} before re-assignment.", (Object)this.jobId, (Object)this.excessResources.getResourceCount());
        }
        ResourceCounter copy = this.excessResources.copy();
        this.excessResources.clear();
        for (Map.Entry<ResourceProfile, Integer> resourceProfileIntegerEntry : copy.getResourceProfilesWithCount().entrySet()) {
            for (int x = 0; x < resourceProfileIntegerEntry.getValue(); ++x) {
                this.notifyAcquiredResource(resourceProfileIntegerEntry.getKey());
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("There are {} excess resources for job {} after re-assignment.", (Object)this.jobId, (Object)this.excessResources.getResourceCount());
        }
    }

    private static class ExcessResource {
        private final ResourceProfile requirementProfile;
        private final ResourceProfile resourceProfile;
        private final int numExcessResources;

        private ExcessResource(ResourceProfile requirementProfile, ResourceProfile resourceProfile, int numExcessResources) {
            this.requirementProfile = requirementProfile;
            this.resourceProfile = resourceProfile;
            this.numExcessResources = numExcessResources;
        }
    }
}

