/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.groups;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.api.common.JobID;
import org.apache.flink.metrics.CharacterFilter;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.metrics.dump.QueryScopeInfo;
import org.apache.flink.runtime.metrics.groups.ComponentMetricGroup;
import org.apache.flink.runtime.metrics.groups.JobManagerJobMetricGroup;
import org.apache.flink.runtime.metrics.scope.ScopeFormat;

public class JobManagerMetricGroup
extends ComponentMetricGroup<JobManagerMetricGroup> {
    private final Map<JobID, JobManagerJobMetricGroup> jobs = new HashMap<JobID, JobManagerJobMetricGroup>();
    private final String hostname;

    public JobManagerMetricGroup(MetricRegistry registry, String hostname) {
        super(registry, registry.getScopeFormats().getJobManagerFormat().formatScope(hostname), null);
        this.hostname = hostname;
    }

    public String hostname() {
        return this.hostname;
    }

    @Override
    protected QueryScopeInfo.JobManagerQueryScopeInfo createQueryServiceMetricInfo(CharacterFilter filter) {
        return new QueryScopeInfo.JobManagerQueryScopeInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobManagerJobMetricGroup addJob(JobGraph job) {
        JobID jobId = job.getJobID();
        String jobName = job.getName();
        JobManagerMetricGroup jobManagerMetricGroup = this;
        synchronized (jobManagerMetricGroup) {
            if (!this.isClosed()) {
                JobManagerJobMetricGroup currentJobGroup = this.jobs.get(jobId);
                if (currentJobGroup == null || currentJobGroup.isClosed()) {
                    currentJobGroup = new JobManagerJobMetricGroup(this.registry, this, jobId, jobName);
                    this.jobs.put(jobId, currentJobGroup);
                }
                return currentJobGroup;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeJob(JobID jobId) {
        if (jobId == null) {
            return;
        }
        JobManagerMetricGroup jobManagerMetricGroup = this;
        synchronized (jobManagerMetricGroup) {
            JobManagerJobMetricGroup containedGroup = this.jobs.remove(jobId);
            if (containedGroup != null) {
                containedGroup.close();
            }
        }
    }

    public int numRegisteredJobMetricGroups() {
        return this.jobs.size();
    }

    @Override
    protected void putVariables(Map<String, String> variables) {
        variables.put(ScopeFormat.SCOPE_HOST, this.hostname);
    }

    @Override
    protected Iterable<? extends ComponentMetricGroup> subComponents() {
        return this.jobs.values();
    }

    @Override
    protected String getGroupName(CharacterFilter filter) {
        return "jobmanager";
    }
}

