/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.io.IOException;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.apache.flink.runtime.checkpoint.channel.ChannelStateWriter;
import org.apache.flink.runtime.io.network.buffer.BufferCompressor;
import org.apache.flink.runtime.io.network.buffer.BufferPool;
import org.apache.flink.runtime.io.network.partition.BufferWritingResultPartition;
import org.apache.flink.runtime.io.network.partition.ChannelStateHolder;
import org.apache.flink.runtime.io.network.partition.CheckpointedResultPartition;
import org.apache.flink.runtime.io.network.partition.CheckpointedResultSubpartition;
import org.apache.flink.runtime.io.network.partition.PipelinedSubpartition;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.ResultPartitionManager;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.io.network.partition.ResultSubpartition;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.SupplierWithException;

public class PipelinedResultPartition
extends BufferWritingResultPartition
implements CheckpointedResultPartition,
ChannelStateHolder {
    private static final int PIPELINED_RESULT_PARTITION_ITSELF = -42;
    private final Object releaseLock = new Object();
    @GuardedBy(value="releaseLock")
    private final boolean[] consumedSubpartitions;
    @GuardedBy(value="releaseLock")
    private int numberOfUsers;

    public PipelinedResultPartition(String owningTaskName, int partitionIndex, ResultPartitionID partitionId, ResultPartitionType partitionType, ResultSubpartition[] subpartitions, int numTargetKeyGroups, ResultPartitionManager partitionManager, @Nullable BufferCompressor bufferCompressor, SupplierWithException<BufferPool, IOException> bufferPoolFactory) {
        super(owningTaskName, partitionIndex, partitionId, PipelinedResultPartition.checkResultPartitionType(partitionType), subpartitions, numTargetKeyGroups, partitionManager, bufferCompressor, bufferPoolFactory);
        this.consumedSubpartitions = new boolean[subpartitions.length];
        this.numberOfUsers = subpartitions.length + 1;
    }

    @Override
    public void setChannelStateWriter(ChannelStateWriter channelStateWriter) {
        for (ResultSubpartition subpartition : this.subpartitions) {
            if (!(subpartition instanceof ChannelStateHolder)) continue;
            ((PipelinedSubpartition)subpartition).setChannelStateWriter(channelStateWriter);
        }
    }

    @Override
    void onConsumedSubpartition(int subpartitionIndex) {
        this.decrementNumberOfUsers(subpartitionIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decrementNumberOfUsers(int subpartitionIndex) {
        int remainingUnconsumed;
        if (this.isReleased()) {
            return;
        }
        Object object = this.releaseLock;
        synchronized (object) {
            if (subpartitionIndex != -42) {
                if (this.consumedSubpartitions[subpartitionIndex]) {
                    return;
                }
                this.consumedSubpartitions[subpartitionIndex] = true;
            }
            remainingUnconsumed = --this.numberOfUsers;
        }
        LOG.debug("{}: Received consumed notification for subpartition {}.", (Object)this, (Object)subpartitionIndex);
        if (remainingUnconsumed == 0) {
            this.partitionManager.onConsumedPartition(this);
        } else if (remainingUnconsumed < 0) {
            throw new IllegalStateException("Received consume notification even though all subpartitions are already consumed.");
        }
    }

    @Override
    public CheckpointedResultSubpartition getCheckpointedSubpartition(int subpartitionIndex) {
        return (CheckpointedResultSubpartition)((Object)this.subpartitions[subpartitionIndex]);
    }

    @Override
    public void flushAll() {
        this.flushAllSubpartitions(false);
    }

    @Override
    public void flush(int targetSubpartition) {
        this.flushSubpartition(targetSubpartition, false);
    }

    @Override
    public String toString() {
        return "PipelinedResultPartition " + this.partitionId.toString() + " [" + (Object)((Object)this.partitionType) + ", " + this.subpartitions.length + " subpartitions, " + this.numberOfUsers + " pending consumptions]";
    }

    private static ResultPartitionType checkResultPartitionType(ResultPartitionType type) {
        Preconditions.checkArgument((type == ResultPartitionType.PIPELINED || type == ResultPartitionType.PIPELINED_BOUNDED || type == ResultPartitionType.PIPELINED_APPROXIMATE ? 1 : 0) != 0);
        return type;
    }

    @Override
    public void finishReadRecoveredState(boolean notifyAndBlockOnCompletion) throws IOException {
        for (ResultSubpartition subpartition : this.subpartitions) {
            ((CheckpointedResultSubpartition)((Object)subpartition)).finishReadRecoveredState(notifyAndBlockOnCompletion);
        }
    }

    @Override
    public void close() {
        this.decrementNumberOfUsers(-42);
        super.close();
    }
}

