/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.io.Serializable;
import java.util.Objects;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.checkpoint.CheckpointType;
import org.apache.flink.runtime.state.CheckpointStorageLocationReference;
import org.apache.flink.util.Preconditions;

public class CheckpointOptions
implements Serializable {
    public static final long NO_ALIGNMENT_TIME_OUT = Long.MAX_VALUE;
    private static final long serialVersionUID = 5010126558083292915L;
    private final CheckpointType checkpointType;
    private final CheckpointStorageLocationReference targetLocation;
    private final AlignmentType alignmentType;
    private final long alignmentTimeout;
    private static final CheckpointOptions CHECKPOINT_AT_DEFAULT_LOCATION = new CheckpointOptions(CheckpointType.CHECKPOINT, CheckpointStorageLocationReference.getDefault());

    public static CheckpointOptions notExactlyOnce(CheckpointType type, CheckpointStorageLocationReference location) {
        return new CheckpointOptions(type, location, AlignmentType.AT_LEAST_ONCE, Long.MAX_VALUE);
    }

    public static CheckpointOptions alignedNoTimeout(CheckpointType type, CheckpointStorageLocationReference location) {
        return new CheckpointOptions(type, location, AlignmentType.ALIGNED, Long.MAX_VALUE);
    }

    public static CheckpointOptions unaligned(CheckpointStorageLocationReference location) {
        return new CheckpointOptions(CheckpointType.CHECKPOINT, location, AlignmentType.UNALIGNED, Long.MAX_VALUE);
    }

    public static CheckpointOptions alignedWithTimeout(CheckpointStorageLocationReference location, long alignmentTimeout) {
        return new CheckpointOptions(CheckpointType.CHECKPOINT, location, AlignmentType.ALIGNED, alignmentTimeout);
    }

    private static CheckpointOptions forceAligned(CheckpointStorageLocationReference location, long alignmentTimeout) {
        return new CheckpointOptions(CheckpointType.CHECKPOINT, location, AlignmentType.FORCED_ALIGNED, alignmentTimeout);
    }

    public static CheckpointOptions create(CheckpointType checkpointType, CheckpointStorageLocationReference locationReference, boolean isExactlyOnceMode, boolean unalignedCheckpointsEnabled, long alignmentTimeout) {
        boolean canBeUnaligned = checkpointType == CheckpointType.CHECKPOINT && unalignedCheckpointsEnabled;
        return CheckpointOptions.forConfig(checkpointType, locationReference, isExactlyOnceMode, canBeUnaligned && alignmentTimeout == 0L, canBeUnaligned ? alignmentTimeout : Long.MAX_VALUE);
    }

    public static CheckpointOptions forConfig(CheckpointType checkpointType, CheckpointStorageLocationReference locationReference, boolean isExactlyOnceMode, boolean isUnalignedEnabled, long alignmentTimeout) {
        if (!isExactlyOnceMode) {
            return CheckpointOptions.notExactlyOnce(checkpointType, locationReference);
        }
        if (checkpointType.isSavepoint()) {
            return CheckpointOptions.alignedNoTimeout(checkpointType, locationReference);
        }
        if (!isUnalignedEnabled) {
            return CheckpointOptions.alignedNoTimeout(checkpointType, locationReference);
        }
        if (alignmentTimeout == 0L || alignmentTimeout == Long.MAX_VALUE) {
            return CheckpointOptions.unaligned(locationReference);
        }
        return CheckpointOptions.alignedWithTimeout(locationReference, alignmentTimeout);
    }

    @VisibleForTesting
    public CheckpointOptions(CheckpointType checkpointType, CheckpointStorageLocationReference targetLocation) {
        this(checkpointType, targetLocation, AlignmentType.ALIGNED, Long.MAX_VALUE);
    }

    public CheckpointOptions(CheckpointType checkpointType, CheckpointStorageLocationReference targetLocation, AlignmentType alignmentType, long alignmentTimeout) {
        Preconditions.checkArgument((alignmentType != AlignmentType.UNALIGNED || !checkpointType.isSavepoint() ? 1 : 0) != 0, (Object)"Savepoint can't be unaligned");
        Preconditions.checkArgument((alignmentTimeout == Long.MAX_VALUE || alignmentType != AlignmentType.UNALIGNED ? 1 : 0) != 0, (String)"Unaligned checkpoint can't have timeout (%s)", (Object[])new Object[]{alignmentTimeout});
        this.checkpointType = (CheckpointType)((Object)Preconditions.checkNotNull((Object)((Object)checkpointType)));
        this.targetLocation = (CheckpointStorageLocationReference)Preconditions.checkNotNull((Object)targetLocation);
        this.alignmentType = (AlignmentType)((Object)Preconditions.checkNotNull((Object)((Object)alignmentType)));
        this.alignmentTimeout = alignmentTimeout;
    }

    public boolean needsAlignment() {
        return this.isExactlyOnceMode() && (this.getCheckpointType().isSavepoint() || !this.isUnalignedCheckpoint());
    }

    public long getAlignmentTimeout() {
        return this.alignmentTimeout;
    }

    public AlignmentType getAlignment() {
        return this.alignmentType;
    }

    public boolean isTimeoutable() {
        if (this.alignmentType == AlignmentType.FORCED_ALIGNED) {
            return false;
        }
        return this.alignmentType == AlignmentType.ALIGNED && this.alignmentTimeout > 0L && this.alignmentTimeout != Long.MAX_VALUE;
    }

    public CheckpointType getCheckpointType() {
        return this.checkpointType;
    }

    public CheckpointStorageLocationReference getTargetLocation() {
        return this.targetLocation;
    }

    public boolean isExactlyOnceMode() {
        return this.alignmentType != AlignmentType.AT_LEAST_ONCE;
    }

    public boolean isUnalignedCheckpoint() {
        return this.alignmentType == AlignmentType.UNALIGNED;
    }

    public CheckpointOptions withUnalignedSupported() {
        if (this.alignmentType == AlignmentType.FORCED_ALIGNED) {
            return this.alignmentTimeout != Long.MAX_VALUE ? CheckpointOptions.alignedWithTimeout(this.targetLocation, this.alignmentTimeout) : CheckpointOptions.unaligned(this.targetLocation);
        }
        return this;
    }

    public CheckpointOptions withUnalignedUnsupported() {
        if (this.isUnalignedCheckpoint() || this.isTimeoutable()) {
            return CheckpointOptions.forceAligned(this.targetLocation, this.alignmentTimeout);
        }
        return this;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.targetLocation, this.checkpointType, this.alignmentType, this.alignmentTimeout});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && obj.getClass() == CheckpointOptions.class) {
            CheckpointOptions that = (CheckpointOptions)obj;
            return this.checkpointType == that.checkpointType && this.targetLocation.equals(that.targetLocation) && this.alignmentType == that.alignmentType && this.alignmentTimeout == that.alignmentTimeout;
        }
        return false;
    }

    public String toString() {
        return "CheckpointOptions {checkpointType = " + (Object)((Object)this.checkpointType) + ", targetLocation = " + this.targetLocation + ", alignment = " + (Object)((Object)this.alignmentType) + ", alignmentTimeout = " + this.alignmentTimeout + "}";
    }

    @VisibleForTesting
    public static CheckpointOptions forCheckpointWithDefaultLocation() {
        return CHECKPOINT_AT_DEFAULT_LOCATION;
    }

    public CheckpointOptions toUnaligned() {
        Preconditions.checkState((this.alignmentType == AlignmentType.ALIGNED ? 1 : 0) != 0);
        return CheckpointOptions.unaligned(this.targetLocation);
    }

    public static enum AlignmentType {
        AT_LEAST_ONCE,
        ALIGNED,
        UNALIGNED,
        FORCED_ALIGNED;

    }
}

