/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.apache.flink.runtime.util.DependencyVisitor;
import org.apache.flink.shaded.org.objectweb.asm.ClassReader;

public class JarFileCreator {
    private static final String CLASS_EXTENSION = ".class";
    private final Set<Class<?>> classSet = new HashSet();
    private final File outputFile;
    private final Set<String> packages = new HashSet<String>();

    public JarFileCreator(File outputFile) {
        this.outputFile = outputFile;
    }

    public synchronized JarFileCreator addClass(Class<?> clazz) {
        this.classSet.add(clazz);
        String name = clazz.getName();
        int n = name.lastIndexOf(46);
        if (n > -1) {
            name = name.substring(0, n);
        }
        return this.addPackage(name);
    }

    public synchronized JarFileCreator addPackage(String p) {
        this.packages.add(p);
        return this;
    }

    public synchronized JarFileCreator addPackages(String[] packages) {
        for (String p : packages) {
            this.addPackage(p);
        }
        return this;
    }

    private synchronized void addDependencies() throws IOException {
        ArrayList<String> dependencies = new ArrayList<String>();
        for (Class<?> clazz : this.classSet) {
            dependencies.add(clazz.getName());
        }
        for (int head = 0; head != dependencies.size(); ++head) {
            DependencyVisitor v = new DependencyVisitor(327680);
            v.addNameSpace(this.packages);
            InputStream classInputStream = null;
            String name = (String)dependencies.get(head);
            try {
                Class<?> clazz = Class.forName(name);
                int n = name.lastIndexOf(46);
                String className = null;
                if (n > -1) {
                    className = name.substring(n + 1, name.length());
                }
                classInputStream = clazz.getResourceAsStream(className + CLASS_EXTENSION);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e.getMessage());
            }
            new ClassReader(classInputStream).accept(v, 0);
            classInputStream.close();
            Set<String> classPackages = v.getPackages();
            for (String s : classPackages) {
                if (dependencies.contains(s.replace('/', '.'))) continue;
                dependencies.add(s.replace('/', '.'));
            }
        }
        for (String dependency : dependencies) {
            try {
                this.classSet.add(Class.forName(dependency));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e.getMessage());
            }
        }
    }

    public synchronized void createJarFile() throws IOException {
        this.addDependencies();
        byte[] buf = new byte[128];
        if (this.outputFile == null) {
            throw new IOException("Output file is null");
        }
        if (this.outputFile.exists()) {
            this.outputFile.delete();
        }
        try (JarOutputStream jos = new JarOutputStream((OutputStream)new FileOutputStream(this.outputFile), new Manifest());){
            for (Class<?> clazz : this.classSet) {
                String entry = clazz.getName().replace('.', '/') + CLASS_EXTENSION;
                jos.putNextEntry(new JarEntry(entry));
                String name = clazz.getName();
                int n = name.lastIndexOf(46);
                String className = null;
                if (n > -1) {
                    className = name.substring(n + 1, name.length());
                }
                InputStream classInputStream = clazz.getResourceAsStream(className + CLASS_EXTENSION);
                int num = classInputStream.read(buf);
                while (num != -1) {
                    jos.write(buf, 0, num);
                    num = classInputStream.read(buf);
                }
                classInputStream.close();
                jos.closeEntry();
            }
        }
    }
}

