/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.groups;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.deployment.TaskDeploymentDescriptor;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.metrics.groups.ComponentMetricGroup;
import org.apache.flink.runtime.metrics.groups.JobMetricGroup;
import org.apache.flink.runtime.metrics.groups.TaskManagerMetricGroup;
import org.apache.flink.runtime.metrics.groups.TaskMetricGroup;
import org.apache.flink.runtime.metrics.scope.TaskManagerJobScopeFormat;
import org.apache.flink.util.AbstractID;
import org.apache.flink.util.Preconditions;

public class TaskManagerJobMetricGroup
extends JobMetricGroup {
    private final TaskManagerMetricGroup parent;
    private final Map<AbstractID, TaskMetricGroup> tasks = new HashMap<AbstractID, TaskMetricGroup>();

    public TaskManagerJobMetricGroup(MetricRegistry registry, TaskManagerMetricGroup parent, JobID jobId, @Nullable String jobName) {
        this(registry, (TaskManagerMetricGroup)Preconditions.checkNotNull((Object)parent), registry.getScopeFormats().getTaskManagerJobFormat(), jobId, jobName);
    }

    public TaskManagerJobMetricGroup(MetricRegistry registry, TaskManagerMetricGroup parent, TaskManagerJobScopeFormat scopeFormat, JobID jobId, @Nullable String jobName) {
        super(registry, jobId, jobName, scopeFormat.formatScope(parent, jobId, jobName));
        this.parent = (TaskManagerMetricGroup)Preconditions.checkNotNull((Object)parent);
    }

    public final TaskManagerMetricGroup parent() {
        return this.parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskMetricGroup addTask(TaskDeploymentDescriptor tdd) {
        JobVertexID vertexId = tdd.getVertexID();
        ExecutionAttemptID executionId = tdd.getExecutionId();
        String taskName = tdd.getTaskName();
        int subtaskIndex = tdd.getIndexInSubtaskGroup();
        int attemptNumber = tdd.getAttemptNumber();
        Preconditions.checkNotNull((Object)((Object)executionId));
        TaskManagerJobMetricGroup taskManagerJobMetricGroup = this;
        synchronized (taskManagerJobMetricGroup) {
            if (!this.isClosed()) {
                TaskMetricGroup task = new TaskMetricGroup(this.registry, this, vertexId, executionId, taskName, subtaskIndex, attemptNumber);
                this.tasks.put(executionId, task);
                return task;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTaskMetricGroup(AbstractID executionId) {
        Preconditions.checkNotNull((Object)executionId);
        boolean removeFromParent = false;
        TaskManagerJobMetricGroup taskManagerJobMetricGroup = this;
        synchronized (taskManagerJobMetricGroup) {
            if (!this.isClosed() && this.tasks.remove(executionId) != null && this.tasks.isEmpty()) {
                removeFromParent = true;
                this.close();
            }
        }
        if (removeFromParent) {
            this.parent.removeJobMetricsGroup(this.jobId, this);
        }
    }

    @Override
    protected Iterable<? extends ComponentMetricGroup> subComponents() {
        return this.tasks.values();
    }
}

