/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmanager.scheduler;

import org.apache.flink.runtime.executiongraph.Execution;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobmanager.scheduler.CoLocationConstraint;
import org.apache.flink.runtime.jobmanager.scheduler.SlotSharingGroup;
import org.apache.flink.util.Preconditions;

public class ScheduledUnit {
    private final Execution vertexExecution;
    private final SlotSharingGroup sharingGroup;
    private final CoLocationConstraint locationConstraint;

    public ScheduledUnit(Execution task) {
        Preconditions.checkNotNull((Object)task);
        this.vertexExecution = task;
        this.sharingGroup = null;
        this.locationConstraint = null;
    }

    public ScheduledUnit(Execution task, SlotSharingGroup sharingUnit) {
        Preconditions.checkNotNull((Object)task);
        this.vertexExecution = task;
        this.sharingGroup = sharingUnit;
        this.locationConstraint = null;
    }

    public ScheduledUnit(Execution task, SlotSharingGroup sharingUnit, CoLocationConstraint locationConstraint) {
        Preconditions.checkNotNull((Object)task);
        Preconditions.checkNotNull((Object)sharingUnit);
        Preconditions.checkNotNull((Object)locationConstraint);
        this.vertexExecution = task;
        this.sharingGroup = sharingUnit;
        this.locationConstraint = locationConstraint;
    }

    public JobVertexID getJobVertexId() {
        return this.vertexExecution.getVertex().getJobvertexId();
    }

    public Execution getTaskToExecute() {
        return this.vertexExecution;
    }

    public SlotSharingGroup getSlotSharingGroup() {
        return this.sharingGroup;
    }

    public CoLocationConstraint getLocationConstraint() {
        return this.locationConstraint;
    }

    public String toString() {
        return "{task=" + this.vertexExecution.getVertexWithAttempt() + ", sharingUnit=" + this.sharingGroup + ", locationConstraint=" + this.locationConstraint + '}';
    }
}

