/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.util.ArrayDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.partition.PipelinedSubpartition;
import org.apache.flink.runtime.io.network.partition.ResultSubpartitionView;
import org.apache.flink.runtime.util.event.NotificationListener;
import org.apache.flink.util.Preconditions;

class PipelinedSubpartitionView
implements ResultSubpartitionView {
    private final PipelinedSubpartition parent;
    private AtomicBoolean isReleased = new AtomicBoolean();

    PipelinedSubpartitionView(PipelinedSubpartition parent) {
        this.parent = (PipelinedSubpartition)Preconditions.checkNotNull((Object)parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Buffer getNextBuffer() {
        ArrayDeque<Buffer> arrayDeque = this.parent.buffers;
        synchronized (arrayDeque) {
            return this.parent.buffers.poll();
        }
    }

    @Override
    public boolean registerListener(NotificationListener listener) {
        return !this.isReleased.get() && this.parent.registerListener(listener);
    }

    @Override
    public void notifySubpartitionConsumed() {
        this.releaseAllResources();
    }

    @Override
    public void releaseAllResources() {
        if (this.isReleased.compareAndSet(false, true)) {
            this.parent.onConsumedSubpartition();
        }
    }

    @Override
    public boolean isReleased() {
        return this.isReleased.get();
    }

    @Override
    public Throwable getFailureCause() {
        return this.parent.getFailureCause();
    }

    public String toString() {
        return String.format("PipelinedSubpartitionView(index: %d) of ResultPartition %s", this.parent.index, this.parent.parent.getPartitionId());
    }
}

