/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.instance;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Queue;
import java.util.Set;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.instance.ActorGateway;
import org.apache.flink.runtime.instance.HardwareDescription;
import org.apache.flink.runtime.instance.InstanceConnectionInfo;
import org.apache.flink.runtime.instance.InstanceDiedException;
import org.apache.flink.runtime.instance.InstanceID;
import org.apache.flink.runtime.instance.SharedSlot;
import org.apache.flink.runtime.instance.SimpleSlot;
import org.apache.flink.runtime.instance.Slot;
import org.apache.flink.runtime.instance.SlotSharingGroupAssignment;
import org.apache.flink.runtime.jobmanager.scheduler.SlotAvailabilityListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Instance {
    private static final Logger LOG = LoggerFactory.getLogger(Instance.class);
    private final Object instanceLock = new Object();
    private final ActorGateway actorGateway;
    private final InstanceConnectionInfo connectionInfo;
    private final HardwareDescription resources;
    private final ResourceID resourceId;
    private final InstanceID instanceId;
    private final int numberOfSlots;
    private final Queue<Integer> availableSlots;
    private final Set<Slot> allocatedSlots = new HashSet<Slot>();
    private SlotAvailabilityListener slotAvailabilityListener;
    private volatile long lastReceivedHeartBeat = System.currentTimeMillis();
    private byte[] lastMetricsReport;
    private volatile boolean isDead;

    public Instance(ActorGateway actorGateway, InstanceConnectionInfo connectionInfo, ResourceID resourceId, InstanceID id, HardwareDescription resources, int numberOfSlots) {
        this.actorGateway = actorGateway;
        this.connectionInfo = connectionInfo;
        this.resourceId = resourceId;
        this.instanceId = id;
        this.resources = resources;
        this.numberOfSlots = numberOfSlots;
        this.availableSlots = new ArrayDeque<Integer>(numberOfSlots);
        for (int i = 0; i < numberOfSlots; ++i) {
            this.availableSlots.add(i);
        }
    }

    public ResourceID getResourceId() {
        return this.resourceId;
    }

    public InstanceID getId() {
        return this.instanceId;
    }

    public HardwareDescription getResources() {
        return this.resources;
    }

    public int getTotalNumberOfSlots() {
        return this.numberOfSlots;
    }

    public boolean isAlive() {
        return !this.isDead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markDead() {
        ArrayList<Slot> slots;
        Iterator iterator = this.instanceLock;
        synchronized (iterator) {
            if (this.isDead) {
                return;
            }
            this.isDead = true;
            this.slotAvailabilityListener = null;
            slots = new ArrayList<Slot>(this.allocatedSlots);
            this.allocatedSlots.clear();
            this.availableSlots.clear();
        }
        for (Slot slot : slots) {
            slot.releaseSlot();
        }
    }

    public long getLastHeartBeat() {
        return this.lastReceivedHeartBeat;
    }

    public void reportHeartBeat() {
        this.lastReceivedHeartBeat = System.currentTimeMillis();
    }

    public void setMetricsReport(byte[] lastMetricsReport) {
        this.lastMetricsReport = lastMetricsReport;
    }

    public byte[] getLastMetricsReport() {
        return this.lastMetricsReport;
    }

    public boolean isStillAlive(long now, long cleanUpInterval) {
        return this.lastReceivedHeartBeat + cleanUpInterval > now;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleSlot allocateSimpleSlot(JobID jobID) throws InstanceDiedException {
        if (jobID == null) {
            throw new IllegalArgumentException();
        }
        Object object = this.instanceLock;
        synchronized (object) {
            if (this.isDead) {
                throw new InstanceDiedException(this);
            }
            Integer nextSlot = this.availableSlots.poll();
            if (nextSlot == null) {
                return null;
            }
            SimpleSlot slot = new SimpleSlot(jobID, this, nextSlot);
            this.allocatedSlots.add(slot);
            return slot;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SharedSlot allocateSharedSlot(JobID jobID, SlotSharingGroupAssignment sharingGroupAssignment) throws InstanceDiedException {
        if (jobID == null) {
            throw new IllegalArgumentException();
        }
        Object object = this.instanceLock;
        synchronized (object) {
            if (this.isDead) {
                throw new InstanceDiedException(this);
            }
            Integer nextSlot = this.availableSlots.poll();
            if (nextSlot == null) {
                return null;
            }
            SharedSlot slot = new SharedSlot(jobID, this, nextSlot, sharingGroupAssignment);
            this.allocatedSlots.add(slot);
            return slot;
        }
    }

    public boolean returnAllocatedSlot(Slot slot) {
        if (slot == null || slot.getInstance() != this) {
            throw new IllegalArgumentException("Slot is null or belongs to the wrong TaskManager.");
        }
        if (slot.isAlive()) {
            throw new IllegalArgumentException("Slot is still alive");
        }
        if (slot.markReleased()) {
            LOG.debug("Return allocated slot {}.", (Object)slot);
            Object object = this.instanceLock;
            synchronized (object) {
                if (this.isDead) {
                    return false;
                }
                if (this.allocatedSlots.remove(slot)) {
                    this.availableSlots.add(slot.getSlotNumber());
                    if (this.slotAvailabilityListener != null) {
                        this.slotAvailabilityListener.newSlotAvailable(this);
                    }
                    return true;
                }
                throw new IllegalArgumentException("Slot was not allocated from this TaskManager.");
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAndReleaseAllSlots() {
        ArrayList<Slot> copy;
        Iterator iterator = this.instanceLock;
        synchronized (iterator) {
            copy = new ArrayList<Slot>(this.allocatedSlots);
        }
        for (Slot slot : copy) {
            slot.releaseSlot();
        }
    }

    public ActorGateway getActorGateway() {
        return this.actorGateway;
    }

    public InstanceConnectionInfo getInstanceConnectionInfo() {
        return this.connectionInfo;
    }

    public int getNumberOfAvailableSlots() {
        return this.availableSlots.size();
    }

    public int getNumberOfAllocatedSlots() {
        return this.allocatedSlots.size();
    }

    public boolean hasResourcesAvailable() {
        return !this.isDead && this.getNumberOfAvailableSlots() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSlotAvailabilityListener(SlotAvailabilityListener slotAvailabilityListener) {
        Object object = this.instanceLock;
        synchronized (object) {
            if (this.slotAvailabilityListener != null) {
                throw new IllegalStateException("Instance has already a slot listener.");
            }
            this.slotAvailabilityListener = slotAvailabilityListener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSlotListener() {
        Object object = this.instanceLock;
        synchronized (object) {
            this.slotAvailabilityListener = null;
        }
    }

    public String toString() {
        return String.format("%s @ %s - %d slots - URL: %s", new Object[]{this.instanceId, this.connectionInfo.getHostname(), this.numberOfSlots, this.actorGateway != null ? this.actorGateway.path() : "No instance gateway"});
    }
}

