/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.UUID;
import org.apache.flink.runtime.akka.FlinkUntypedActor;
import org.apache.flink.runtime.checkpoint.CheckpointCoordinator;
import org.apache.flink.runtime.jobgraph.JobStatus;
import org.apache.flink.runtime.messages.ExecutionGraphMessages;
import org.apache.flink.util.Preconditions;

public class CheckpointCoordinatorDeActivator
extends FlinkUntypedActor {
    private final CheckpointCoordinator coordinator;
    private final UUID leaderSessionID;

    public CheckpointCoordinatorDeActivator(CheckpointCoordinator coordinator, UUID leaderSessionID) {
        this.LOG.info("Create CheckpointCoordinatorDeActivator");
        this.coordinator = (CheckpointCoordinator)Preconditions.checkNotNull((Object)coordinator, (String)"The checkpointCoordinator must not be null.");
        this.leaderSessionID = leaderSessionID;
    }

    @Override
    public void handleMessage(Object message) throws Exception {
        if (message instanceof ExecutionGraphMessages.JobStatusChanged) {
            JobStatus status = ((ExecutionGraphMessages.JobStatusChanged)message).newJobStatus();
            if (status == JobStatus.RUNNING) {
                this.coordinator.startCheckpointScheduler();
            } else {
                this.coordinator.stopCheckpointScheduler();
            }
        }
    }

    @Override
    public UUID getLeaderSessionID() {
        return this.leaderSessionID;
    }
}

